/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.building;

import cz.cvut.fel.ida.learning.results.Progress;
import cz.cvut.fel.ida.logic.constructs.example.LogicSample;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.grounding.GroundingSample;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralModel;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralSample;
import cz.cvut.fel.ida.pipelines.Merge;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.RecurrentPipe;
import cz.cvut.fel.ida.pipelines.building.GroundingBuilder;
import cz.cvut.fel.ida.pipelines.building.NeuralNetsBuilder;
import cz.cvut.fel.ida.pipelines.building.SamplesProcessingBuilder;
import cz.cvut.fel.ida.pipelines.building.TemplateSamplesBuilder;
import cz.cvut.fel.ida.pipelines.bulding.AbstractPipelineBuilder;
import cz.cvut.fel.ida.pipelines.pipes.generic.DuplicateBranch;
import cz.cvut.fel.ida.pipelines.pipes.generic.FirstFromPairExtractionBranch;
import cz.cvut.fel.ida.pipelines.pipes.generic.LambdaPipe;
import cz.cvut.fel.ida.pipelines.pipes.generic.PairMerge;
import cz.cvut.fel.ida.pipelines.pipes.specific.NeuralTrainingPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.TemplateToNeuralPipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Source;
import cz.cvut.fel.ida.setup.Sources;
import cz.cvut.fel.ida.utils.exporting.Exporter;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class TrainingBuilder
extends AbstractPipelineBuilder<Sources, Pair<Pair<Template, NeuralModel>, Progress>> {
    private static final Logger LOG = Logger.getLogger(TrainingBuilder.class.getName());
    Sources sources;
    private static int exportNumber = 0;

    public TrainingBuilder(Settings settings, Sources sources) {
        super(settings);
        this.sources = sources;
    }

    @Override
    public Pipeline<Sources, Pair<Pair<Template, NeuralModel>, Progress>> buildPipeline() {
        return this.buildPipeline(this.sources);
    }

    public Pipeline<Sources, Pair<Pair<Template, NeuralModel>, Progress>> buildPipeline(Sources sources) {
        Pipeline<Sources, Pair<Pair<Template, NeuralModel>, Progress>> pipeline = new Pipeline<Sources, Pair<Pair<Template, NeuralModel>, Progress>>("TrainingPipeline", this);
        if (sources.templateProvided) {
            LogicLearningBuilder logicTrainingBuilder = new LogicLearningBuilder(this.settings);
            Pipeline<Pair<Template, Stream<LogicSample>>, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.registerEnd(logicTrainingBuilder.buildPipeline());
            TemplateSamplesBuilder templateSamplesBuilder = new TemplateSamplesBuilder(sources, this.settings);
            Pipeline<Sources, Pair<Template, Stream<LogicSample>>> templateSourcesPipeline = pipeline.registerStart(templateSamplesBuilder.buildPipeline());
            templateSourcesPipeline.connectAfter(trainingPipeline);
        } else {
            LambdaPipe<Sources, Source> getTrainSource = pipeline.register(new LambdaPipe<Sources, Source>("getTrainSourcePipe", srcs -> srcs.train, this.settings));
            SamplesProcessingBuilder trainingSamplesProcessor = new SamplesProcessingBuilder(this.settings, sources.train);
            Pipeline<Source, Stream<LogicSample>> getLogicSampleStream = pipeline.register(trainingSamplesProcessor.buildPipeline());
            getTrainSource.connectAfter(getLogicSampleStream);
            pipeline.registerStart(getTrainSource);
            Pipeline<Stream<LogicSample>, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.registerEnd(new StructureLearningBuilder(this.settings).buildPipeline());
            getLogicSampleStream.connectAfter(trainingPipeline);
        }
        return pipeline;
    }

    public static class NeuralLearningBuilder
    extends AbstractPipelineBuilder<Pair<NeuralModel, Stream<NeuralSample>>, Pair<NeuralModel, Progress>> {
        public NeuralLearningBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Pair<NeuralModel, Progress>> buildPipeline() {
            Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Pair<NeuralModel, Progress>> pipeline = new Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Pair<NeuralModel, Progress>>("NeuralTrainingPipeline", this);
            NeuralTrainingPipe neuralTrainingPipe = pipeline.registerEnd(pipeline.registerStart(new NeuralTrainingPipe(this.settings)));
            return pipeline;
        }
    }

    public static class StructureLearningBuilder
    extends AbstractPipelineBuilder<Stream<LogicSample>, Pair<Pair<Template, NeuralModel>, Progress>> {
        public StructureLearningBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Stream<LogicSample>, Pair<Pair<Template, NeuralModel>, Progress>> buildPipeline() {
            RecurrentPipe recurrentPipe = new RecurrentPipe(){

                public int hashCode() {
                    return super.hashCode();
                }
            };
            return null;
        }
    }

    public class LogicLearningBuilder
    extends AbstractPipelineBuilder<Pair<Template, Stream<LogicSample>>, Pair<Pair<Template, NeuralModel>, Progress>> {
        public LogicLearningBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<Template, Stream<LogicSample>>, Pair<Pair<Template, NeuralModel>, Progress>> buildPipeline() {
            Pipeline<Pair<Template, Stream<LogicSample>>, Pair<Pair<Template, NeuralModel>, Progress>> pipeline = new Pipeline<Pair<Template, Stream<LogicSample>>, Pair<Pair<Template, NeuralModel>, Progress>>("LearningPipeline", this);
            FirstFromPairExtractionBranch templateSamplesBranch = pipeline.registerStart(new FirstFromPairExtractionBranch());
            DuplicateBranch duplicateBranch = pipeline.register(new DuplicateBranch());
            GroundingBuilder groundingBuilder = new GroundingBuilder(this.settings);
            Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> groundingPipeline = pipeline.register(groundingBuilder.buildPipeline());
            NeuralNetsBuilder neuralNetsBuilder = new NeuralNetsBuilder(this.settings, groundingBuilder.weightFactory);
            Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> neuralizationPipeline = pipeline.register(neuralNetsBuilder.buildPipeline());
            TemplateToNeuralPipe templateToNeuralPipe = pipeline.register(new TemplateToNeuralPipe(this.settings));
            PairMerge neuralMerge = pipeline.register(new PairMerge("NeuralMerge"));
            Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Pair<NeuralModel, Progress>> trainingPipeline = pipeline.register(new NeuralLearningBuilder(this.settings).buildPipeline());
            1 finalMerge = pipeline.registerEnd(new Merge<Template, Pair<NeuralModel, Progress>, Pair<Pair<Template, NeuralModel>, Progress>>("ModelMerge", this.settings){

                @Override
                protected Pair<Pair<Template, NeuralModel>, Progress> merge(Template template, Pair<NeuralModel, Progress> training) {
                    if (this.settings.exportTrainedModel) {
                        Exporter exporter = Exporter.getExporter(this.settings.exportDir, "/models/trainedTemplate" + exportNumber++, "JAVA");
                        exporter.export(template);
                    }
                    return new Pair<Pair<Template, Object>, Object>(new Pair<Template, Object>(template, training.r), training.s);
                }
            });
            templateSamplesBranch.connectAfterL(groundingPipeline);
            templateSamplesBranch.connectAfterR(duplicateBranch);
            groundingPipeline.connectAfter(neuralizationPipeline);
            duplicateBranch.connectAfterL(templateToNeuralPipe);
            neuralMerge.connectBeforeL(templateToNeuralPipe);
            neuralMerge.connectBeforeR(neuralizationPipeline);
            neuralMerge.connectAfter(trainingPipeline);
            finalMerge.connectBeforeL(duplicateBranch.output2);
            finalMerge.connectBeforeR(trainingPipeline);
            return pipeline;
        }
    }
}

