/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.debugging;

import cz.cvut.fel.ida.logic.constructs.example.LogicSample;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.debugging.End2EndDebugger;
import cz.cvut.fel.ida.pipelines.debugging.drawing.TemplateDrawer;
import cz.cvut.fel.ida.pipelines.pipes.generic.FirstFromPairPipe;
import cz.cvut.fel.ida.pipelines.pipes.generic.StreamifyPipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Sources;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class TemplateDebugger
extends End2EndDebugger<Template> {
    private static final Logger LOG = Logger.getLogger(TemplateDebugger.class.getName());

    public TemplateDebugger(Settings settings) {
        super(settings);
        if (settings.drawing) {
            this.drawer = new TemplateDrawer(settings);
        }
    }

    public TemplateDebugger(Sources sources, Settings settings) {
        super(sources, settings);
        if (settings.drawing) {
            this.drawer = new TemplateDrawer(settings);
        }
    }

    @Override
    public void debug(Template obj) {
        LOG.fine(obj.toString());
        if (this.settings.drawing) {
            this.drawer.draw(obj);
        }
    }

    @Override
    public Pipeline<Sources, Stream<Template>> buildPipeline() {
        Pipeline<Sources, Pair<Template, Stream<LogicSample>>> sourcesPairPipeline = this.pipeline.registerStart(this.end2endTrainigBuilder.buildFromSources(this.sources, this.settings));
        this.pipeline.registerEnd(this.pipeline.register(sourcesPairPipeline.connectAfter(new FirstFromPairPipe())).connectAfter(new StreamifyPipe()));
        return this.pipeline;
    }
}

