/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.setup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Sources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;

public class SourceFiles
extends Sources {
    private static final Logger LOG = Logger.getLogger(SourceFiles.class.getName());
    public File template;
    public File trainExamples;
    public File valExamples;
    public File testExamples;
    public File trainQueries;
    public File valQueries;
    public File testQueries;
    private transient List<Path> subTemplates;
    transient Path mergedTemplatePath;

    public SourceFiles(String foldId, Settings settings) {
        super(foldId, settings);
    }

    public SourceFiles(Settings settings) {
        super(settings);
    }

    @Override
    public Boolean validate(Settings settings, StringBuilder problems) {
        Boolean valid = this.isValid(settings, problems);
        return valid;
    }

    @Override
    public void infer(Settings settings) {
        if (this.checkForSubstring(this.trainExamples, settings.queryExampleSeparator, 2)) {
            LOG.info("Queries within train examples file detected via separator " + settings.queryExampleSeparator);
            this.train.QueriesProvided = true;
        }
        if (this.checkForSubstring(this.valExamples, settings.queryExampleSeparator, 2)) {
            LOG.info("Queries within validation examples file detected via separator " + settings.queryExampleSeparator);
            this.val.QueriesProvided = true;
        }
        if (this.checkForSubstring(this.testExamples, settings.queryExampleSeparator, 2)) {
            LOG.info("Queries within test examples file detected via separator " + settings.queryExampleSeparator);
            this.test.QueriesProvided = true;
        }
        super.infer(settings);
    }

    public Boolean isValid(Settings settings, StringBuilder problems) {
        Boolean validate = super.validate(settings, problems);
        return validate;
    }

    public SourceFiles(Settings settings, CommandLine cmd) {
        super(settings);
        String foldPrefix;
        String sourcePath = cmd.getOptionValue("sourcesDir", settings.sourcePath);
        if (cmd.hasOption("sourcesFile")) {
            String sources_ = cmd.getOptionValue("sourcesFile");
            this.loadFromJson(sources_);
        }
        if (cmd.hasOption("foldPrefix") && (foldPrefix = cmd.getOptionValue("foldPrefix", settings.foldsPrefix)).contains(File.separator)) {
            LOG.severe("Invalid folds prefix name, it must not contain file separators: " + foldPrefix);
            throw new IllegalArgumentException(foldPrefix);
        }
        File[] foldSubdirs = this.getFoldSubdirs(settings, cmd, sourcePath);
        if (foldSubdirs != null && foldSubdirs.length > 0) {
            this.setupFromDir(settings, cmd, Paths.get(sourcePath, new String[0]).toAbsolutePath().toFile());
            this.crawlFolds(settings, cmd, sourcePath);
        } else {
            this.setupFromDir(settings, cmd, Paths.get(sourcePath, new String[0]).toAbsolutePath().toFile());
        }
    }

    private File[] getFoldSubdirs(Settings settings, CommandLine cmd, String sourcePath) {
        File dir = new File(sourcePath);
        File[] foldDirs = dir.listFiles((dir1, name) -> name.startsWith(cmd.getOptionValue("foldPrefix", settings.foldsPrefix)));
        return foldDirs;
    }

    private void crawlFolds(Settings settings, CommandLine cmd, String path) {
        Object[] foldDirs = this.getFoldSubdirs(settings, cmd, path);
        this.folds = new ArrayList();
        boolean i = false;
        if (foldDirs != null) {
            Arrays.sort(foldDirs);
            for (Object foldDir : foldDirs) {
                SourceFiles sFold = new SourceFiles(((File)foldDir).getName(), settings);
                sFold.parent = this;
                sFold.setupFromDir(settings, cmd, (File)foldDir);
                this.folds.add(sFold);
                sFold.crawlFolds(settings, cmd, Paths.get(path, ((File)foldDir).toString()).toString());
            }
        }
    }

    private SourceFiles setupFromDir(Settings settings, CommandLine cmd, File foldDir) {
        LOG.info("Setting up input sourceFiles from directory: " + foldDir);
        try {
            if (this.template != null) {
                settings.templateFile = this.template.getPath();
            }
            String templatePath = cmd.getOptionValue("template", settings.templateFile);
            File template_ = this.sanitizePath(settings, cmd, foldDir, SourceFiles.sanitizeTempl(templatePath));
            this.mergedTemplatePath = Paths.get(template_ + settings.mergedTemplatesSuffix + this.foldId, new String[0]);
            if (templatePath.contains(",")) {
                LOG.warning("There are multiple templates, will try to merge them first");
                this.subTemplates = new ArrayList<Path>();
                if (templatePath.startsWith("[")) {
                    templatePath = templatePath.substring(1, templatePath.length() - 2);
                }
                String[] split = templatePath.split(",");
                this.mergedTemplatePath.toFile().delete();
                template_ = this.mergeTemplates(settings, cmd, foldDir, split);
            } else {
                template_ = this.getTemplate(settings, cmd, foldDir, templatePath);
            }
            if (template_ != null) {
                String fileType = this.recognizeFileType(template_.toString(), template_, settings);
                if (fileType.equals("text/x-java")) {
                    this.binaryTemplateStream = new FileInputStream(template_.toString());
                } else {
                    this.setupTemplate(template_, foldDir);
                }
            }
        }
        catch (IOException e) {
            LOG.info("There is no learning template");
        }
        try {
            if (this.trainExamples != null) {
                settings.trainExamplesFile = this.trainExamples.getPath();
            }
            String trainExamplesPath = cmd.getOptionValue("trainExamples", settings.trainExamplesFile);
            File trainExamples_ = null;
            trainExamples_ = trainExamplesPath.startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), trainExamplesPath).toFile() : Paths.get(trainExamplesPath, new String[0]).toFile();
            if (!trainExamples_.exists()) {
                LOG.finer("Could not find trainExamples file in " + trainExamples_ + ", will try to use " + Paths.get(foldDir.toString(), settings.trainExamplesFile2) + " file for the same purpose");
                trainExamples_ = Paths.get(foldDir.toString(), settings.trainExamplesFile2).toFile();
            }
            this.train.ExamplesReader = new FileReader(trainExamples_);
            this.trainExamples = trainExamples_;
            this.recognizeFileType(this.trainExamples.getAbsolutePath(), trainExamples_, settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no train examples");
        }
        try {
            if (this.valExamples != null) {
                settings.valExamplesFile = this.valExamples.getPath();
            }
            String valExamplesPath = cmd.getOptionValue("valExamples", settings.valExamplesFile);
            File valExamples_ = null;
            valExamples_ = valExamplesPath.startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), valExamplesPath).toFile() : Paths.get(valExamplesPath, new String[0]).toFile();
            this.val.ExamplesReader = new FileReader(valExamples_);
            this.valExamples = valExamples_;
            this.recognizeFileType(this.valExamples.getAbsolutePath(), valExamples_, settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no separate validation examples found.");
        }
        try {
            if (this.testExamples != null) {
                settings.testExamplesFile = this.testExamples.getPath();
            }
            String testExamplesPath = cmd.getOptionValue("testExamples", settings.testExamplesFile);
            File testExamples_ = null;
            testExamples_ = testExamplesPath.startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), testExamplesPath).toFile() : Paths.get(testExamplesPath, new String[0]).toFile();
            this.test.ExamplesReader = new FileReader(testExamples_);
            this.testExamples = testExamples_;
            this.recognizeFileType(this.testExamples.getAbsolutePath(), testExamples_, settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no separate test examples found.");
        }
        try {
            if (this.trainQueries != null) {
                settings.trainQueriesFile = this.trainQueries.getPath();
            }
            String trainQueriesPath = cmd.getOptionValue("trainQueries", settings.trainQueriesFile);
            File trainQueries_ = null;
            trainQueries_ = trainQueriesPath.startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), trainQueriesPath).toFile() : Paths.get(trainQueriesPath, new String[0]).toFile();
            if (!trainQueries_.exists()) {
                LOG.finer("Could not find trainQueries file in " + trainQueries_ + ", will try to use " + Paths.get(foldDir.toString(), settings.trainQueriesFile2) + " file for the same purpose");
                trainQueries_ = Paths.get(foldDir.toString(), settings.trainQueriesFile2).toFile();
            }
            this.train.QueriesReader = new FileReader(trainQueries_);
            this.trainQueries = trainQueries_;
            this.recognizeFileType(this.trainQueries.getAbsolutePath(), trainQueries_, settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no separate train queries found.");
        }
        try {
            String valQueriesPath;
            if (this.valQueries != null) {
                settings.valQueriesFile = this.valQueries.getPath();
            }
            File valQueries_ = (valQueriesPath = cmd.getOptionValue("valQueries", settings.valQueriesFile)).startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), valQueriesPath).toFile() : Paths.get(valQueriesPath, new String[0]).toFile();
            this.val.QueriesReader = new FileReader(valQueries_);
            this.valQueries = valQueries_;
            this.recognizeFileType(this.valQueries.getAbsolutePath(), valQueries_, settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no separate validation queries found.");
        }
        try {
            String testQueriesPath;
            if (this.testQueries != null) {
                settings.testQueriesFile = this.testQueries.getPath();
            }
            File testQueries_ = (testQueriesPath = cmd.getOptionValue("testQueries", settings.testQueriesFile)).startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), testQueriesPath).toFile() : Paths.get(testQueriesPath, new String[0]).toFile();
            this.test.QueriesReader = new FileReader(testQueries_);
            this.testQueries = testQueries_;
            this.recognizeFileType(this.testQueries.getAbsolutePath(), testQueries_, settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no separate test queries found.");
        }
        return this;
    }

    public static String sanitizeTempl(String name) {
        String sane = name.replaceAll("[,:;'\\[\\]]", "_");
        return sane;
    }

    private void setupTemplate(File template_, File foldDir) throws IOException {
        AtomicBoolean changed = new AtomicBoolean(false);
        Path templPath = template_.toPath();
        String content = this.checkTemplate4Imports(templPath, changed, foldDir);
        if (changed.get()) {
            Files.write(this.mergedTemplatePath, content.getBytes(), new OpenOption[0]);
            template_ = this.mergedTemplatePath.toFile();
        }
        this.setTemplateReader(new FileReader(template_));
        this.template = template_;
    }

    private String checkTemplate4Imports(Path path, AtomicBoolean changed, File foldDir) throws FileNotFoundException {
        try {
            if (path.toString().startsWith(".")) {
                path = Paths.get(foldDir + "/" + path, new String[0]);
            }
            List<String> strings = Files.readAllLines(path);
            for (int i = 0; i < strings.size(); ++i) {
                String line = strings.get(i);
                if (!line.startsWith("import ")) continue;
                changed.set(true);
                line = line.substring(7);
                line = line.replaceAll(" ", "");
                if (line.contains(",")) {
                    String[] split = line.split(",");
                    StringBuilder sb = new StringBuilder();
                    for (String templ : split) {
                        sb.append(this.checkTemplate4Imports(Paths.get(templ, new String[0]), changed, foldDir));
                    }
                    strings.set(i, sb.toString());
                    continue;
                }
                String imported = this.checkTemplate4Imports(Paths.get(line, new String[0]), changed, foldDir);
                strings.set(i, imported);
            }
            return String.join((CharSequence)"\n", strings);
        }
        catch (IOException e) {
            LOG.severe("There is no subtemplate found at the specified path! : " + path);
            throw new FileNotFoundException();
        }
    }

    private File mergeTemplates(Settings settings, CommandLine cmd, File foldDir, String[] split) throws FileNotFoundException {
        File templ = this.mergedTemplatePath.toFile();
        for (String path : split) {
            File setupTemplate = this.getTemplate(settings, cmd, foldDir, path);
            if (setupTemplate == null) continue;
            this.subTemplates.add(Paths.get(setupTemplate.getPath(), new String[0]));
        }
        for (Path subTemplate : this.subTemplates) {
            try {
                List<String> strings = Files.readAllLines(subTemplate);
                if (templ.exists()) {
                    Files.write(templ.toPath(), strings, StandardOpenOption.APPEND);
                    continue;
                }
                Files.write(templ.toPath(), strings, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                LOG.severe("There is no subtemplate found at the specified path! : " + subTemplate);
                throw new FileNotFoundException();
            }
        }
        return templ;
    }

    private File getTemplate(Settings settings, CommandLine cmd, File foldDir, String templatePath) throws FileNotFoundException {
        File template_ = this.sanitizePath(settings, cmd, foldDir, templatePath);
        if (template_.exists()) {
            if (this.parent != null && this.parent.getTemplateReader() != null) {
                LOG.warning("Inconsistent setting - there are templates both in parent folder and fold folder (don't know which one to use)");
            }
            return template_;
        }
        if (this.parent != null) {
            this.setTemplateReader(this.parent.getTemplateReader());
            this.template = ((SourceFiles)this.parent).template;
            return null;
        }
        LOG.finer("Could not find template file in " + template_ + ", will try to use " + foldDir.toString() + "/" + settings.templateFile2 + " file for the same purpose");
        template_ = Paths.get(foldDir.toString(), settings.templateFile2).toFile();
        if (template_.exists()) {
            return template_;
        }
        LOG.severe("There is no template found at the specified path! : " + templatePath);
        throw new FileNotFoundException();
    }

    private File sanitizePath(Settings settings, CommandLine cmd, File foldDir, String templatePath) {
        File template_ = !cmd.hasOption("foldPrefix") && templatePath.startsWith(".") || settings.sourcePathProvided && !cmd.hasOption("template") ? Paths.get(foldDir.toString(), templatePath).toFile() : (templatePath.startsWith(".") ? Paths.get(System.getProperty("user.dir"), templatePath).toFile() : Paths.get(templatePath, new String[0]).toFile());
        return template_;
    }

    private String recognizeFileType(String path, File sourceType, Settings settings) {
        String contentType;
        switch (contentType = SourceFiles.identifyFileTypeUsingFilesProbeContentType(path)) {
            case "text/plain": {
                settings.plaintextInput = true;
                LOG.fine("Input " + sourceType + " file type identified as plain text");
                break;
            }
            case "text/x-microdvd": {
                settings.plaintextInput = true;
                LOG.fine("Input " + sourceType + " file type identified as plain text (text/x-microdvd)");
                break;
            }
            case "application/xml": {
                LOG.fine("Input " + sourceType + " file type identified as xml");
                break;
            }
            case "application/json": {
                LOG.fine("Input " + sourceType + " file type identified as json");
                break;
            }
            case "text/x-java": {
                LOG.fine("Input " + sourceType + " file type identified as binary/java");
                break;
            }
            default: {
                LOG.warning("File type of input " + sourceType + " not recognized!");
            }
        }
        return contentType;
    }

    public boolean checkForSubstring(File file, String substring, int numberOfLines) {
        if (file == null) {
            return false;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            String line;
            int i = 0;
            while ((line = bufferedReader.readLine()) != null && i++ < numberOfLines) {
                if (!line.contains(substring)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void importFromCSV(String inPath) {
    }

    public SourceFiles loadFromJson(String inPath) {
        InstanceCreator<SourceFiles> creator = new InstanceCreator<SourceFiles>(){

            @Override
            public SourceFiles createInstance(Type type) {
                return SourceFiles.this;
            }
        };
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)SourceFiles.class), creator).create();
        try {
            String json = new String(Files.readAllBytes(Paths.get(inPath, new String[0])));
            SourceFiles sources = gson.fromJson(json, SourceFiles.class);
            return sources;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SourceFiles loadFromJson(Settings settings, String inPath) {
        SourceFiles sourceFiles = null;
        if (new File(inPath).exists()) {
            sourceFiles = new SourceFiles(settings).loadFromJson(inPath);
        } else if (Paths.get(inPath, "sources.json").toFile().exists()) {
            sourceFiles = new SourceFiles(settings).loadFromJson(Paths.get(inPath, "sources.json").toString());
        }
        if (sourceFiles == null) {
            LOG.warning("No SourceFiles have been found at: " + inPath);
        }
        return sourceFiles;
    }

    public void exportToCSV(String outPath) {
    }

    public static String identifyFileTypeUsingFilesProbeContentType(String fileName) {
        String fileType = null;
        File file = new File(fileName);
        try {
            fileType = Files.probeContentType(file.toPath());
        }
        catch (IOException ioException) {
            LOG.severe("ERROR: Unable to determine file type for " + fileName + " due to IOException " + ioException);
        }
        if (fileType == null) {
            LOG.severe("ERROR: Unable to determine file type (for unknown reason, probably opened by other process?): " + fileName + " defaulting to text/plain");
            fileType = "text/plain";
        }
        return fileType;
    }

    @Override
    public Reader getTemplateReader() {
        if (this.template == null) {
            return null;
        }
        try {
            if (super.getTemplateReader() == null || !super.getTemplateReader().ready()) {
                this.setTemplateReader(new FileReader(this.template));
            }
        }
        catch (Exception e) {
            try {
                this.setTemplateReader(new FileReader(this.template));
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        return super.getTemplateReader();
    }
}

