/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.generic;

import cz.cvut.fel.ida.utils.generic.Pair;
import cz.cvut.fel.ida.utils.generic.Timing;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    public static DecimalFormat numberFormat = new DecimalFormat("##.##");
    public static int mb = 0x100000;
    public static double gcPercentLimit = 0.2;
    public static long remainingMemoryLimit = 500L;
    private static long tic = System.currentTimeMillis();
    private static long lastGarbageCollectionTime = 0L;
    public static long allocatedMemory = 0L;

    public static void myExit(Logger log, String msg) throws Exception {
        log.severe(msg);
        throw new Exception(msg);
    }

    public static String[] splitArgs(String args) {
        return args.split("(?=\")|(?<=\")\\s| ");
    }

    public static String[] getDatasetArgs(String ... args) {
        String datasetDirResourcePath = args[0];
        StringBuilder additional = new StringBuilder(" ");
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                additional.append(args[i]).append(" ");
            }
        }
        String resourcePath = Utilities.getResourcePath(datasetDirResourcePath);
        return Utilities.splitArgs("-sd " + resourcePath + additional.toString());
    }

    public static String getResourcePath(String filename) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(filename);
        String path = resource.getPath();
        if (path.startsWith("/C:")) {
            path = path.substring(1, path.length());
        }
        return path;
    }

    public static String readResourceFile(String path) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
            return null;
        }
        try {
            return result.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public static String sanitize(String name) {
        String sane = name.replaceAll("[:.;'/\\\\]", "_");
        return sane;
    }

    public static void logMemory() {
        long appRemainingMemory = Utilities.getAppRemainingMemory();
        if (appRemainingMemory < remainingMemoryLimit) {
            LOG.warning("Possible performance decrease due to GC and sweeping - please increase memory via -Xmx ! Remaining Java application memory only : " + appRemainingMemory + "mb");
        } else {
            LOG.finer("Remaining Java application memory : " + appRemainingMemory + "mb");
        }
        Utilities.logGCStats();
    }

    public static long getAppRemainingMemory() {
        allocatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long presumableFreeMemory = Runtime.getRuntime().maxMemory() - allocatedMemory;
        return presumableFreeMemory / (long)mb;
    }

    public static void logGCStats() {
        long totalGarbageCollections = 0L;
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGarbageCollections += gc.getCollectionCount();
            garbageCollectionTime += gc.getCollectionTime();
        }
        double gcDelta = garbageCollectionTime - lastGarbageCollectionTime;
        long now = System.currentTimeMillis();
        double gcPercent = gcDelta / (double)(now - tic);
        if (gcPercent > gcPercentLimit) {
            LOG.warning("Garbage collection takes " + numberFormat.format(gcPercent * 100.0) + "% of time!!");
        }
        LOG.finer(totalGarbageCollections + " garbage colletions with total time: " + garbageCollectionTime / 1000L + "s, made " + gcPercent * 100.0 + "% of time spent in GC since the last time.");
        tic = now;
        lastGarbageCollectionTime = garbageCollectionTime;
    }

    public static <A, B> List<Pair<A, B>> zipLists(ArrayList<A> as, ArrayList<B> bs) {
        return IntStream.range(0, Math.min(as.size(), bs.size())).mapToObj(i -> new Pair(as.get(i), bs.get(i))).collect(Collectors.toList());
    }

    public static <A, B> List<Pair<A, B>> zipLists(List<A> as, List<B> bs) {
        Iterator<A> it1 = as.iterator();
        Iterator<B> it2 = bs.iterator();
        LinkedList<Pair<A, B>> result = new LinkedList<Pair<A, B>>();
        while (it1.hasNext() && it2.hasNext()) {
            result.add(new Pair<A, B>(it1.next(), it2.next()));
        }
        return result;
    }

    public static <A, B, C> Stream<C> zipStreams(Stream<? extends A> a, Stream<? extends B> b, final BiFunction<? super A, ? super B, ? extends C> zipper) {
        Objects.requireNonNull(zipper);
        Spliterator aSpliterator = Objects.requireNonNull(a).spliterator();
        Spliterator bSpliterator = Objects.requireNonNull(b).spliterator();
        int characteristics = aSpliterator.characteristics() & bSpliterator.characteristics() & 0xFFFFFFFA;
        long zipSize = (characteristics & 0x40) != 0 ? Math.min(aSpliterator.getExactSizeIfKnown(), bSpliterator.getExactSizeIfKnown()) : -1L;
        final Iterator aIterator = Spliterators.iterator(aSpliterator);
        final Iterator bIterator = Spliterators.iterator(bSpliterator);
        Iterator cIterator = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                boolean hasNextA = aIterator.hasNext();
                boolean hasNextB = bIterator.hasNext();
                if (hasNextA && hasNextB) {
                    return true;
                }
                if (hasNextA || hasNextB) {
                    LOG.severe("Streams to be zipped have different sizes! Possibly mismatch of examples and labels?");
                    throw new IllegalStateException("Stream size mismatch");
                }
                return false;
            }

            @Override
            public C next() {
                return zipper.apply(aIterator.next(), bIterator.next());
            }
        };
        Spliterator split = Spliterators.spliterator(cIterator, zipSize, characteristics);
        return a.isParallel() || b.isParallel() ? StreamSupport.stream(split, true) : StreamSupport.stream(split, false);
    }

    public static <T> List<T> terminateSampleStream(Stream<T> stream) {
        Timing timing = new Timing();
        timing.tic();
        LOG.fine("--------------------- PROCESSING SAMPLES (= terminating stream) ------------------------------");
        List list = stream.collect(Collectors.toList());
        stream.close();
        timing.toc();
        LOG.fine("--------------------- SAMPLES PROCESSED into list of " + list.get(0).getClass().getSimpleName() + " (in " + timing.getTimeTaken() + ") -----------------------");
        Utilities.logMemory();
        return list;
    }

    public static class BatchSpliterator<E>
    implements Spliterator<List<E>> {
        private final Spliterator<E> base;
        private final int batchSize;

        public BatchSpliterator(Spliterator<E> base, int batchSize) {
            this.base = base;
            this.batchSize = batchSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super List<E>> action) {
            ArrayList batch = new ArrayList(this.batchSize);
            for (int i = 0; i < this.batchSize; ++i) {
                if (!this.base.tryAdvance(batch::add)) break;
            }
            if (batch.isEmpty()) {
                return false;
            }
            action.accept(batch);
            return true;
        }

        @Override
        public Spliterator<List<E>> trySplit() {
            if (this.base.estimateSize() <= (long)this.batchSize) {
                return null;
            }
            Spliterator<E> splitBase = this.base.trySplit();
            return splitBase == null ? null : new BatchSpliterator<E>(splitBase, this.batchSize);
        }

        @Override
        public long estimateSize() {
            double baseSize = this.base.estimateSize();
            return baseSize == 0.0 ? 0L : (long)Math.ceil(baseSize / (double)this.batchSize);
        }

        @Override
        public int characteristics() {
            return this.base.characteristics();
        }
    }
}

