/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math;

public abstract class IntegerFunction {
    public abstract int f(int var1);

    public static class Exponential
    extends IntegerFunction {
        private int a;
        private int b;
        private int c;

        public Exponential(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public Exponential(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        @Override
        public int f(int n) {
            return this.a * (int)Math.exp((double)n / (double)this.b) + this.c;
        }
    }

    public static class Cubic
    extends IntegerFunction {
        private int a;
        private int b;
        private int c;
        private int d;

        public Cubic(int a, int b, int c, int d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        @Override
        public int f(int n) {
            return this.a * n * n * n + this.b * n * n + this.c * n + this.d;
        }
    }

    public static class Quadratic
    extends IntegerFunction {
        private int a;
        private int b;
        private int c;

        public Quadratic(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        @Override
        public int f(int n) {
            return this.a * n * n + this.b * n + this.c;
        }
    }

    public static class Identity
    extends IntegerFunction {
        @Override
        public int f(int n) {
            return n;
        }
    }

    public static class ConstantFunction
    extends IntegerFunction {
        private int value;

        public ConstantFunction(int value) {
            this.value = value;
        }

        @Override
        public int f(int n) {
            return this.value;
        }
    }
}

