/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic;

import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.Cache;
import cz.cvut.fel.ida.utils.math.StringUtils;

public class Constant
implements Term {
    private static int GENERIC = 1;
    private static int INTEGER = 2;
    private static int DOUBLE = 3;
    private int constantType = -1;
    private int intValue;
    private double doubleValue;
    private String type;
    private String name;
    private String toString;
    private int hashCode = Integer.MIN_VALUE;
    private static Cache<String, Constant> cache = new Cache();
    private static Cache<Pair<String, String>, Constant> cache2 = new Cache();

    private Constant(String name) {
        this.name = name.trim().intern();
        if (StringUtils.isNumeric(this.name())) {
            if (StringUtils.isInteger(this.name())) {
                this.intValue = Integer.parseInt(this.name());
                this.constantType = INTEGER;
            } else if (StringUtils.isDouble(this.name())) {
                this.doubleValue = Double.parseDouble(this.name());
                this.constantType = DOUBLE;
            }
        } else {
            this.constantType = GENERIC;
        }
    }

    private Constant(String name, String type) {
        this(name);
        this.type = type;
        this.toString = type + ":" + name;
    }

    public static Constant construct(String name) {
        Constant retVal = cache.get(name);
        if (retVal == null) {
            retVal = new Constant(name);
            cache.put(name, retVal);
        }
        return retVal;
    }

    public static Constant construct(String name, String type) {
        if (type == null) {
            return Constant.construct(name);
        }
        Pair<String, String> queryPair = new Pair<String, String>(name, type);
        Constant retVal = cache2.get(queryPair);
        if (retVal == null) {
            retVal = new Constant(name, type);
            cache2.put(queryPair, retVal);
        }
        return retVal;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    public String toString() {
        if (this.type == null) {
            return this.name;
        }
        return this.toString;
    }

    public boolean equals(Object o) {
        if (o instanceof Constant) {
            Constant c = (Constant)o;
            return !(o != this && (!c.name.equals(this.name) || c.type == null && this.type != null || c.type != null && this.type == null || c.type != this.type && !c.type.equals(this.type)));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode != Integer.MIN_VALUE) {
            return this.hashCode;
        }
        return this.type == null ? (this.hashCode = this.name.hashCode()) : (this.hashCode = this.toString.hashCode());
    }

    public static void clearCache() {
        cache.clear();
        cache2.clear();
    }

    public boolean isInteger() {
        return this.constantType == INTEGER;
    }

    public boolean isDouble() {
        return this.constantType == DOUBLE;
    }

    public boolean isNumeric() {
        return this.isInteger() || this.isDouble();
    }

    public int intValue() {
        return this.intValue;
    }

    public double doubleValue() {
        return this.doubleValue;
    }
}

