/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.setup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Source;
import cz.cvut.fel.ida.setup.SourceFiles;
import java.io.FileInputStream;
import java.io.Reader;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class Sources {
    private static final Logger LOG = Logger.getLogger(Sources.class.getName());
    protected String foldId = "";
    protected transient Settings settings;
    public List<Sources> folds;
    protected transient Sources parent;
    public Source train;
    public Source val;
    public Source test;
    private transient Reader templateReader;
    public boolean commonTemplate;
    public boolean templateProvided;
    public transient FileInputStream binaryTemplateStream;
    public boolean foldFiles;
    public boolean crossvalidation = false;
    public boolean trainTest = false;
    public boolean trainOnly = false;
    public boolean testOnly = false;

    public static Sources getSources(CommandLine cmd, Settings settings) throws Exception {
        Sources sources = null;
        try {
            settings = settings.setupFromCommandline(cmd);
            LOG.info("Settings loaded and set up.");
            sources = Sources.setupFromCommandline(settings, cmd);
            LOG.info("Sources loaded and set up.");
        }
        catch (Exception ex) {
            throw new Exception("Unable to parse Commandline arguments into settings/source files.\n" + ex);
        }
        settings.infer();
        StringBuilder problems = new StringBuilder();
        Boolean validation = settings.validate(problems);
        if (!validation.booleanValue()) {
            throw new Exception("Invalid pipelines setting.\n" + problems);
        }
        validation = sources.validate(settings, problems);
        if (!validation.booleanValue()) {
            throw new Exception("Invalid source files configuration.\n" + problems);
        }
        return sources;
    }

    public Sources(String foldId, Settings settings) {
        this(settings);
        this.foldId = foldId;
    }

    public Sources(Settings settings) {
        this.settings = settings;
        this.train = new Source();
        this.val = new Source();
        this.test = new Source();
    }

    public void infer(Settings settings) {
        if (this.folds != null && !this.folds.isEmpty()) {
            this.foldFiles = true;
            this.crossvalidation = true;
            settings.foldsCount = this.folds.size();
            for (Sources fold : this.folds) {
                fold.infer(settings);
            }
        } else {
            this.foldFiles = false;
        }
        if (this.getTemplateReader() == null && this.binaryTemplateStream == null) {
            this.templateProvided = false;
            settings.structureLearning = true;
        } else {
            this.templateProvided = true;
            if (this.folds != null && !this.folds.isEmpty()) {
                this.commonTemplate = true;
            }
        }
        this.train.infer(settings);
        this.val.infer(settings);
        this.test.infer(settings);
        if (!this.crossvalidation) {
            if (this.train.QueriesProvided && this.test.QueriesProvided) {
                this.trainTest = true;
            } else if (this.train.QueriesProvided) {
                this.trainOnly = true;
            } else if (this.test.QueriesProvided) {
                if (!this.templateProvided) {
                    LOG.warning("Incosistent learning mode inference for this Source (missing template).");
                }
                this.testOnly = true;
            } else {
                LOG.warning("Incosistent learning mode inferred for this Source.");
            }
        }
        if (this.templateProvided && this.train.QueriesProvided && !this.train.ExamplesProvided) {
            settings.groundingMode = Settings.GroundingMode.GLOBAL;
        }
        this.finish(settings);
    }

    private void finish(Settings settings) {
    }

    public Boolean validate(Settings settings, StringBuilder problems) {
        String msg;
        boolean valid = true;
        this.infer(settings);
        if (!settings.allowStructureLearning && !this.templateProvided) {
            msg = "Structure learning is forbidden (not implemented) but no template provided\n";
            LOG.severe("Structure learning is forbidden (not implemented) but no template provided\n");
            problems.append(msg);
            valid = false;
        }
        if (!(this.train.QueriesProvided || this.test.QueriesProvided || this.folds != null && !this.folds.isEmpty())) {
            msg = "Invalid learning setup - no training queries nor testing queries provided " + this.foldId + " \n";
            LOG.severe(msg);
            problems.append(msg);
            valid = false;
        }
        if (this.getTemplateReader() == null && this.train.QueriesReader == null && this.test.QueriesReader == null) {
            msg = "Invalid learning setup - no template nor queries provided\n";
            LOG.severe("Invalid learning setup - no template nor queries provided\n");
            problems.append(msg);
            valid = false;
        }
        if (this.crossvalidation && (this.testOnly || this.trainTest || this.trainOnly)) {
            msg = "Invalid learning setup - cannot decide between crossvalidation and other modes.\n";
            LOG.severe("Invalid learning setup - cannot decide between crossvalidation and other modes.\n");
            problems.append(msg);
            valid = false;
        }
        if (this.foldFiles) {
            boolean val = this.checkJointConsistency(this.folds, problems);
            valid &= val;
        }
        Boolean valtrain = this.train.validate(settings, problems);
        valid &= valtrain.booleanValue();
        Boolean valtest = this.test.validate(settings, problems);
        return valid &= valtest.booleanValue();
    }

    private boolean checkJointConsistency(List<Sources> folds, StringBuilder problems) {
        boolean valid = true;
        for (int i = 1; i < folds.size(); ++i) {
            if (folds.get((int)i).templateProvided == folds.get((int)(i - 1)).templateProvided) continue;
            problems.append("Some folds provide a template while others do not - this is ambiguous.");
            valid = false;
        }
        for (Sources fold : folds) {
            valid &= fold.validate(this.settings, problems).booleanValue();
        }
        return valid;
    }

    public static Sources setupFromCommandline(Settings settings, CommandLine cmd) {
        if (!settings.sourceFiles) {
            LOG.severe("Input streams other than from source files not implemented yet");
            throw new NotImplementedException();
        }
        SourceFiles sources = new SourceFiles(settings, cmd);
        if (cmd.hasOption("xval") || settings.crossvalidation) {
            sources.crossvalidation = true;
        }
        return sources;
    }

    public String export() {
        if (this.settings.exportType == Settings.ExportFileType.JSON) {
            return this.exportToJson();
        }
        LOG.warning("Only exporting of Sources to JSON is supported");
        return this.exportToJson();
    }

    public String exportToJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeSpecialFloatingPointValues().create();
        String json = gson.toJson((Object)this);
        return json;
    }

    public Reader getTemplateReader() {
        return this.templateReader;
    }

    public void setTemplateReader(Reader templateReader) {
        this.templateReader = templateReader;
    }

    public Source getTrainOrTest() {
        if (this.testOnly) {
            return this.test;
        }
        if (this.trainOnly) {
            return this.train;
        }
        throw new RuntimeException("Invalid setup of files in folds (ambiguous train vs. test)");
    }
}

