/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.exporting;

import cz.cvut.fel.ida.utils.exporting.Exportable;
import cz.cvut.fel.ida.utils.exporting.JavaExporter;
import cz.cvut.fel.ida.utils.exporting.JsonExporter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Logger;

public abstract class Exporter {
    private static final Logger LOG = Logger.getLogger(Exporter.class.getName());
    String exportDir;
    File exportFile;
    String type;
    String id;
    String suffix = "";

    protected Exporter(String exportDir, String id, String type) {
        this.exportDir = exportDir;
        this.type = type;
        this.id = id;
        this.suffix = "." + type.toLowerCase();
        this.exportFile = new File(Paths.get(exportDir, id) + this.suffix);
    }

    protected Exporter() {
    }

    public static Exporter getFrom(String exportDir, String id, String[] exportBlocks, String type) {
        for (String exportPipeline : exportBlocks) {
            if (!id.startsWith(exportPipeline) || id.length() >= exportPipeline.length() + 2) continue;
            return Exporter.getExporter(exportDir, id, type);
        }
        return null;
    }

    public abstract void export(Exportable var1);

    public abstract <I> List<I> importListFrom(Path var1, Class<I> var2);

    public abstract <I> I importObjectFrom(Path var1, Class<I> var2);

    public void deleteDir(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                this.deleteDir(f);
            }
        }
        file.delete();
    }

    public static Exporter getExporter(String exportDir, String id, String type) {
        if (type == "JSON") {
            return new JsonExporter(exportDir, id);
        }
        if (type == "JAVA") {
            return new JavaExporter(exportDir, id);
        }
        return new JsonExporter(exportDir, id);
    }

    public abstract void delimitNext();

    public abstract void delimitStart();

    public abstract void delimitEnd();

    public abstract void finish();
}

