/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math;

import cz.cvut.fel.ida.utils.math.VectorUtils;
import java.util.Arrays;
import java.util.BitSet;

public class MatrixUtils {
    public static boolean isZero(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                if (matrix[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isZero(int[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                if (matrix[i][j] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static double[][] eye(int n) {
        double[][] e = new double[n][n];
        for (int i = 0; i < e.length; ++i) {
            e[i][i] = 1.0;
        }
        return e;
    }

    public static double[][] eye(int n, double value) {
        double[][] e = new double[n][n];
        for (int i = 0; i < e.length; ++i) {
            e[i][i] = value;
        }
        return e;
    }

    public static int[][] integerEye(int n) {
        int[][] e = new int[n][n];
        for (int i = 0; i < e.length; ++i) {
            e[i][i] = 1;
        }
        return e;
    }

    public static boolean[][] randomBooleanMatrix(int rows, int columns) {
        boolean[][] matrix = new boolean[rows][];
        for (int i = 0; i < rows; ++i) {
            matrix[i] = VectorUtils.randomBooleanVector(columns);
        }
        return matrix;
    }

    public static int[][] randomintegerMatrix(int rows, int columns) {
        int[][] matrix = new int[rows][];
        for (int i = 0; i < rows; ++i) {
            matrix[i] = VectorUtils.randomVector(columns);
        }
        return matrix;
    }

    public static double[][] randomDoubleMatrix(int rows, int columns) {
        double[][] matrix = new double[rows][columns];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = Math.random();
            }
        }
        return matrix;
    }

    public static boolean equal(double[][] a, double[][] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length != b[i].length) {
                return false;
            }
            for (int j = 0; j < a[i].length; ++j) {
                if (a[i][j] == b[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equal(int[][] a, int[][] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length != b[i].length) {
                return false;
            }
            for (int j = 0; j < a[i].length; ++j) {
                if (a[i][j] == b[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equal(boolean[][] a, boolean[][] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length != b[i].length) {
                return false;
            }
            for (int j = 0; j < a[i].length; ++j) {
                if (a[i][j] == b[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String doubleMatrixToString(double[][] m) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < m.length; ++i) {
            sb.append(VectorUtils.doubleArrayToString(m[i]));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String booleanMatrixToString(boolean[][] m) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < m.length; ++i) {
            sb.append(VectorUtils.booleanArrayToString(m[i]));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String doubleMatrixToMatlabString(double[][] matrix) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                sb.append(matrix[i][j]);
                if (j >= matrix[i].length - 1) continue;
                sb.append(" ");
            }
            if (i >= matrix.length - 1) continue;
            sb.append("; ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String intMatrixToMatlabString(int[][] matrix) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                sb.append(matrix[i][j]);
                if (j >= matrix[i].length - 1) continue;
                sb.append(" ");
            }
            if (i >= matrix.length - 1) continue;
            sb.append("; ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String intMatrixToString(int[][] m) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < m.length; ++i) {
            sb.append(VectorUtils.intArrayToString(m[i]));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static int deepHashCode(double[][] matrix) {
        int retVal = 0;
        for (int i = 0; i < matrix.length; ++i) {
            retVal += Arrays.hashCode(matrix[i]);
        }
        return retVal;
    }

    public static double[][] transpose(double[][] matrix) {
        double[][] retVal = new double[matrix[0].length][matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                retVal[j][i] = matrix[i][j];
            }
        }
        return retVal;
    }

    public static double[][] sum(double[][] a, double[][] b) {
        double[][] retVal = new double[a.length][a[0].length];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                retVal[i][j] = a[i][j] + b[i][j];
            }
        }
        return retVal;
    }

    public static void add(double[][] a, double[][] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                double[] dArray = a[i];
                int n = j;
                dArray[n] = dArray[n] + b[i][j];
            }
        }
    }

    public static void add(double[][] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                double[] dArray = a[i];
                int n = j;
                dArray[n] = dArray[n] + b[j];
            }
        }
    }

    public static double[][] product(double[][] a, double b) {
        double[][] retVal = new double[a.length][a[0].length];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                retVal[i][j] = a[i][j] * b;
            }
        }
        return retVal;
    }

    public static void multiply(double[][] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            int j = 0;
            while (j < a[0].length) {
                double[] dArray = a[i];
                int n = j++;
                dArray[n] = dArray[n] * b;
            }
        }
    }

    public static double trace(double[][] matrix) {
        double trace = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            trace += matrix[i][i];
        }
        return trace;
    }

    public static void swapRows(double[][] matrix, int i1, int i2) {
        double[] row1 = matrix[i1];
        matrix[i1] = matrix[i2];
        matrix[i2] = row1;
    }

    public static void swapColumns(double[][] matrix, int j1, int j2) {
        for (int i = 0; i < matrix.length; ++i) {
            double val1 = matrix[i][j1];
            matrix[i][j1] = matrix[i][j2];
            matrix[i][j2] = val1;
        }
    }

    public double[][] copy(double[][] matrix) {
        double[][] newMatrix = new double[matrix.length][];
        for (int i = 0; i < newMatrix.length; ++i) {
            newMatrix[i] = VectorUtils.copyArray(matrix[i]);
        }
        return newMatrix;
    }

    public static double mean(double[][] matrix) {
        double m = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                m += matrix[i][j];
            }
        }
        return m / (double)(matrix.length * matrix[0].length);
    }

    public static double[] means(double[][] matrix) {
        double[] weights = new double[matrix.length];
        Arrays.fill(weights, 1.0);
        return MatrixUtils.means(matrix, weights);
    }

    public static double[] means(double[][] matrix, double[] weights) {
        if (matrix.length == 0) {
            return new double[0];
        }
        double[] retVal = new double[matrix[0].length];
        int rowIndex = 0;
        for (double[] row : matrix) {
            for (int j = 0; j < retVal.length; ++j) {
                int n = j;
                retVal[n] = retVal[n] + weights[rowIndex] * row[j];
            }
            ++rowIndex;
        }
        int i = 0;
        while (i < retVal.length) {
            int n = i++;
            retVal[n] = retVal[n] / VectorUtils.sum(weights);
        }
        return retVal;
    }

    public static void set(double[][] matrix, double[][] smallerMatrix, int startRow, int startColumn) {
        for (int i = 0; i < smallerMatrix.length; ++i) {
            for (int j = 0; j < smallerMatrix[i].length; ++j) {
                matrix[startRow + i][startColumn + j] = smallerMatrix[i][j];
            }
        }
    }

    public static double[][] submatrix(double[][] matrix, int startRow, int startColumn, int rowCount, int columnCount) {
        double[][] retVal = new double[rowCount][columnCount];
        for (int i = startRow; i < startRow + rowCount; ++i) {
            for (int j = startColumn; j < startColumn + columnCount; ++j) {
                retVal[i - startRow][j - startColumn] = matrix[i][j];
            }
        }
        return retVal;
    }

    public static double[][] copyMatrix(double[][] matrix) {
        double[][] retVal = new double[matrix.length][];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = VectorUtils.copyArray(matrix[i]);
        }
        return retVal;
    }

    public static int[][] copyMatrix(int[][] matrix) {
        int[][] retVal = new int[matrix.length][];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = VectorUtils.copyArray(matrix[i]);
        }
        return retVal;
    }

    public static boolean[][] copyMatrix(boolean[][] matrix) {
        boolean[][] retVal = new boolean[matrix.length][];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = VectorUtils.copyArray(matrix[i]);
        }
        return retVal;
    }

    public static boolean gaussianElimination(boolean[][] a, boolean[] b) {
        int j;
        int i;
        if (a.length == 0) {
            return true;
        }
        BitSet[] bs = new BitSet[a.length];
        for (i = 0; i < a.length; ++i) {
            bs[i] = new BitSet(a[i].length + 1);
        }
        for (i = 0; i < a.length; ++i) {
            for (j = 0; j < a[i].length; ++j) {
                bs[i].set(j, a[i][j]);
            }
        }
        if (!MatrixUtils.gaussianElimination(bs, a[0].length)) {
            return false;
        }
        for (i = 0; i < a.length; ++i) {
            for (j = 0; j < a[i].length; ++j) {
                a[i][j] = bs[i].get(j);
            }
            b[i] = bs[i].get(a[i].length);
        }
        return true;
    }

    private static boolean gaussianElimination(BitSet[] system, int length) {
        int i;
        for (i = 0; i < system.length; ++i) {
            int j;
            int col = -1;
            int selected = 0;
            for (j = i; j < system.length; ++j) {
                int c = system[j].nextSetBit(0);
                if (c == length) {
                    return false;
                }
                if (c == -1 || c >= col && col != -1) continue;
                selected = j;
                col = c;
            }
            if (col == -1) break;
            if (selected > i) {
                MatrixUtils.swap(system, i, selected);
            }
            for (j = i + 1; j < system.length; ++j) {
                if (!system[j].get(col)) continue;
                MatrixUtils.add(system, i, j);
            }
        }
        for (i = 0; i < system.length; ++i) {
            if (MatrixUtils.isRowConsistent(system, i, length)) continue;
            return false;
        }
        return true;
    }

    private static void swap(BitSet[] system, int i, int j) {
        if (i != j) {
            BitSet temp = system[i];
            system[i] = system[j];
            system[j] = temp;
        }
    }

    private static void add(BitSet[] system, int what, int to) {
        system[to].xor(system[what]);
    }

    private static boolean isRowConsistent(BitSet[] system, int row, int length) {
        int firstOne = system[row].nextSetBit(0);
        if (firstOne == length) {
            return false;
        }
        if (firstOne == -1) {
            return true;
        }
        return true;
    }
}

