/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import cz.cvut.fel.ida.utils.generic.tuples.Tuple;
import cz.cvut.fel.ida.utils.math.Combinatorics;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.NaturalNumbersList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class IntegerSet {
    private int hashCode = -1;
    private int[] values;
    public static final EmptySet emptySet = new EmptySet();

    private IntegerSet() {
    }

    private IntegerSet(int[] values) {
        this(values, false);
    }

    private IntegerSet(int[] values, boolean sort) {
        this.values = new int[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
        if (sort) {
            Arrays.sort(this.values);
        }
    }

    public int min() {
        return this.values[0];
    }

    public int max() {
        return this.values[this.values.length - 1];
    }

    public static IntegerSet createIntegerSet(int ... values) {
        Arrays.sort(values);
        if (values.length == 0) {
            return emptySet;
        }
        return IntegerSet.createIntegerSetFromSortedArray(values);
    }

    public static IntegerSet createIntegerSetFromSortedArray(int[] values) {
        int duplicates = 0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (values[i] != values[i + 1]) continue;
            ++duplicates;
        }
        if (duplicates > 0) {
            int[] newValues = new int[values.length - duplicates];
            int j = 0;
            for (int i = 0; i < values.length; ++i) {
                if (i != values.length - 1 && values[i] == values[i + 1]) continue;
                newValues[j] = values[i];
                ++j;
            }
            values = newValues;
        }
        if (values.length == 0) {
            return emptySet;
        }
        IntegerSet retVal = new IntegerSet();
        retVal.values = values;
        return retVal;
    }

    public static IntegerSet createIntegerSet(Set<Integer> set) {
        int[] values = new int[set.size()];
        int index = 0;
        Iterator<Integer> iterator = set.iterator();
        while (iterator.hasNext()) {
            int integer;
            values[index] = integer = iterator.next().intValue();
            ++index;
        }
        return IntegerSet.createIntegerSet(values);
    }

    public static IntegerSet createIntegerSetFromRange(int start, int end) {
        int[] v = new int[end - start];
        int i = start;
        int index = 0;
        while (i < end) {
            v[index] = i++;
            ++index;
        }
        return IntegerSet.createIntegerSet(v);
    }

    public static IntegerSet createRandomIntegerSet(int start, int end, int k) {
        return IntegerSet.createRandomIntegerSet(start, end, k, new Random());
    }

    public static IntegerSet createRandomIntegerSet(int start, int end, int k, Random random) {
        Tuple<Integer> randomTuple = Combinatorics.randomCombination(new NaturalNumbersList(start, end), k, random);
        int[] randomArray = new int[randomTuple.size()];
        for (int i = 0; i < randomArray.length; ++i) {
            randomArray[i] = randomTuple.get(i);
        }
        return IntegerSet.createIntegerSet(randomArray);
    }

    public static IntegerSet intersection(IntegerSet a, IntegerSet b) {
        if (a.isEmpty() || b.isEmpty() || a.values[0] > b.values[b.values.length - 1] || b.values[0] > a.values[a.values.length - 1]) {
            return emptySet;
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        int aLength = a.values.length;
        int bLength = b.values.length;
        while (indexA < aLength && indexB < bLength) {
            if (a.values[indexA] == b.values[indexB]) {
                ++count;
                ++indexA;
                ++indexB;
                continue;
            }
            if (a.values[indexA] < b.values[indexB]) {
                ++indexA;
                continue;
            }
            if (a.values[indexA] <= b.values[indexB]) continue;
            ++indexB;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        int[] newValues = new int[count];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength && indexB < bLength) {
            if (a.values[indexA] == b.values[indexB]) {
                newValues[index] = a.values[indexA];
                ++indexA;
                ++indexB;
                ++index;
                continue;
            }
            if (a.values[indexA] < b.values[indexB]) {
                ++indexA;
                continue;
            }
            if (a.values[indexA] <= b.values[indexB]) continue;
            ++indexB;
        }
        if (count == 0) {
            return emptySet;
        }
        IntegerSet set = new IntegerSet();
        set.values = newValues;
        return set;
    }

    public static IntegerSet union(IntegerSet a, IntegerSet b) {
        if (a instanceof EmptySet) {
            return b;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        int aLength = a.values.length;
        int bLength = b.values.length;
        int[] aValues = a.values;
        int[] bValues = b.values;
        if (a == b) {
            return a;
        }
        if (aValues[aLength - 1] < bValues[0]) {
            int[] values = VectorUtils.concat(aValues, bValues);
            return new IntegerSet(values);
        }
        if (aValues[0] > bValues[bLength - 1]) {
            int[] values = VectorUtils.concat(bValues, aValues);
            return new IntegerSet(values);
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                int aValue = aValues[indexA];
                int bValue = bValues[indexB];
                if (aValue == bValue) {
                    ++indexA;
                    ++indexB;
                    ++count;
                    continue;
                }
                if (aValue < bValue) {
                    ++indexA;
                    ++count;
                    continue;
                }
                if (aValue <= bValue) continue;
                ++indexB;
                ++count;
                continue;
            }
            if (indexA < aLength) {
                ++indexA;
                ++count;
                continue;
            }
            if (indexB >= bLength) continue;
            ++indexB;
            ++count;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        int[] newValues = new int[count];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                int aValue = aValues[indexA];
                int bValue = bValues[indexB];
                if (aValue == bValue) {
                    newValues[index] = aValue;
                    ++indexA;
                    ++indexB;
                    ++index;
                    continue;
                }
                if (aValue < bValue) {
                    newValues[index] = aValue;
                    ++indexA;
                    ++index;
                    continue;
                }
                if (aValue <= bValue) continue;
                newValues[index] = bValue;
                ++indexB;
                ++index;
                continue;
            }
            if (indexA < aLength) {
                newValues[index] = aValues[indexA];
                ++indexA;
                ++index;
                continue;
            }
            if (indexB >= bLength) continue;
            newValues[index] = bValues[indexB];
            ++indexB;
            ++index;
        }
        IntegerSet set = new IntegerSet();
        set.values = newValues;
        return set;
    }

    public static IntegerSet difference(IntegerSet a, IntegerSet b) {
        int indexA;
        if (a == b) {
            return emptySet;
        }
        if (a instanceof EmptySet) {
            return emptySet;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        int indexB = 0;
        int count = 0;
        for (indexA = 0; indexA < a.values.length; ++indexA) {
            while (indexB < b.values.length && b.values[indexB] < a.values[indexA]) {
                ++indexB;
            }
            if (indexB < b.values.length && b.values[indexB] > a.values[indexA]) {
                ++count;
                continue;
            }
            if (indexB < b.values.length) continue;
            ++count;
        }
        int[] newValues = new int[count];
        indexB = 0;
        count = 0;
        for (indexA = 0; indexA < a.values.length; ++indexA) {
            while (indexB < b.values.length && b.values[indexB] < a.values[indexA]) {
                ++indexB;
            }
            if (indexB < b.values.length && b.values[indexB] > a.values[indexA]) {
                newValues[count] = a.values[indexA];
                ++count;
                continue;
            }
            if (indexB < b.values.length) continue;
            newValues[count] = a.values[indexA];
            ++count;
        }
        if (newValues.length == 0) {
            return emptySet;
        }
        IntegerSet set = new IntegerSet();
        set.values = newValues;
        return set;
    }

    public static boolean allAreSubsets(List<IntegerSet> a, List<IntegerSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).isSubsetOf(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreSubsets(IntegerSet[] a, IntegerSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].isSubsetOf(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEmpty(List<IntegerSet> a) {
        for (IntegerSet is : a) {
            if (is.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEmpty(IntegerSet[] a) {
        for (IntegerSet is : a) {
            if (is.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEmpty(List<IntegerSet> a) {
        for (IntegerSet is : a) {
            if (!is.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreEmpty(IntegerSet[] a) {
        for (IntegerSet is : a) {
            if (!is.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEmpty(IntegerSet[] a, boolean[] mask) {
        int i = 0;
        for (IntegerSet is : a) {
            if (mask[i] && !is.isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean someAreEmpty(IntegerSet[] a, boolean[] mask) {
        int i = 0;
        for (IntegerSet is : a) {
            if (mask[i] && is.isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean someAreSubsets(List<IntegerSet> a, List<IntegerSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).isSubsetOf(b.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreSubsets(IntegerSet[] a, IntegerSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].isSubsetOf(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreSubsets(IntegerSet[] a, IntegerSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].isSubsetOf(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreSubsets(IntegerSet[] a, IntegerSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || !a[i].isSubsetOf(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEqual(List<IntegerSet> a, List<IntegerSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEqual(IntegerSet[] a, IntegerSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEqual(List<IntegerSet> a, List<IntegerSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).equals(b.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreEqual(IntegerSet[] a, IntegerSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEqual(IntegerSet[] a, IntegerSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEqual(IntegerSet[] a, IntegerSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || !a[i].equals(b[i])) continue;
            return true;
        }
        return false;
    }

    public static IntegerSet intersection(Collection<IntegerSet> sets) {
        IntegerSet result = null;
        for (IntegerSet set : sets) {
            if (set == null) continue;
            if (result == null) {
                result = set;
                continue;
            }
            result = IntegerSet.intersection(result, set);
        }
        return result;
    }

    public static IntegerSet intersection(IntegerSet ... sets) {
        Arrays.sort(sets, new Comparator<IntegerSet>(){

            @Override
            public int compare(IntegerSet o1, IntegerSet o2) {
                return o1.size() - o2.size();
            }
        });
        IntegerSet result = null;
        for (IntegerSet set : sets) {
            if (set == null) continue;
            result = result == null ? set : IntegerSet.intersection(result, set);
        }
        return result;
    }

    public static IntegerSet[] intersection(IntegerSet[] a, IntegerSet[] b) {
        IntegerSet[] retVal = new IntegerSet[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = IntegerSet.intersection(a[i], b[i]);
        }
        return retVal;
    }

    public static List<IntegerSet> intersection(List<IntegerSet> a, List<IntegerSet> b) {
        ArrayList<IntegerSet> retVal = new ArrayList<IntegerSet>(a.size());
        Iterator<IntegerSet> iter1 = a.iterator();
        Iterator<IntegerSet> iter2 = b.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            retVal.add(IntegerSet.intersection(iter1.next(), iter2.next()));
        }
        return retVal;
    }

    public static IntegerSet union(Collection<IntegerSet> sets) {
        if (sets.size() > 2) {
            int sumOfSizes = 0;
            for (IntegerSet is : sets) {
                sumOfSizes += is.size();
            }
            int[] aux = new int[sumOfSizes];
            int index = 0;
            for (IntegerSet is : sets) {
                System.arraycopy(is.values, 0, aux, index, is.values.length);
                index += is.size();
            }
            return IntegerSet.createIntegerSet(aux);
        }
        IntegerSet result = null;
        for (IntegerSet set : sets) {
            if (set == null) continue;
            if (result == null) {
                result = set;
                continue;
            }
            result = IntegerSet.union(result, set);
        }
        return result;
    }

    public static IntegerSet union(IntegerSet ... sets) {
        if (sets.length > 2) {
            int sumOfSizes = 0;
            for (IntegerSet is : sets) {
                sumOfSizes += is.size();
            }
            int[] aux = new int[sumOfSizes];
            int index = 0;
            for (IntegerSet is : sets) {
                System.arraycopy(is.values, 0, aux, index, is.values.length);
                index += is.size();
            }
            return IntegerSet.createIntegerSet(aux);
        }
        IntegerSet result = null;
        for (IntegerSet set : sets) {
            if (set == null) continue;
            result = result == null ? set : IntegerSet.union(result, set);
        }
        return result;
    }

    public static IntegerSet[] union(IntegerSet[] a, IntegerSet[] b) {
        IntegerSet[] retVal = new IntegerSet[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = IntegerSet.union(a[i], b[i]);
        }
        return retVal;
    }

    public static List<IntegerSet> union(List<IntegerSet> a, List<IntegerSet> b) {
        ArrayList<IntegerSet> retVal = new ArrayList<IntegerSet>(a.size());
        Iterator<IntegerSet> iter1 = a.iterator();
        Iterator<IntegerSet> iter2 = b.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            retVal.add(IntegerSet.union(iter1.next(), iter2.next()));
        }
        return retVal;
    }

    public static int countNonEmpty(List<IntegerSet> sets) {
        int count = 0;
        for (IntegerSet is : sets) {
            if (is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countEmpty(List<IntegerSet> sets) {
        int count = 0;
        for (IntegerSet is : sets) {
            if (!is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countNonEmpty(IntegerSet[] sets) {
        int count = 0;
        for (IntegerSet is : sets) {
            if (is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countEmpty(IntegerSet[] sets) {
        int count = 0;
        for (IntegerSet is : sets) {
            if (!is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countNonEmpty(IntegerSet[] sets, boolean[] mask) {
        int count = 0;
        int i = 0;
        for (IntegerSet is : sets) {
            if (mask[i] && !is.isEmpty()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int countEmpty(IntegerSet[] sets, boolean[] mask) {
        int count = 0;
        int i = 0;
        for (IntegerSet is : sets) {
            if (mask[i] && is.isEmpty()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int sumSizes(IntegerSet[] sets) {
        int sum = 0;
        for (IntegerSet is : sets) {
            sum += is.size();
        }
        return sum;
    }

    public static int sumSizes(IntegerSet[] sets, boolean[] mask) {
        int sum = 0;
        int i = 0;
        for (IntegerSet is : sets) {
            if (mask[i]) {
                sum += is.size();
            }
            ++i;
        }
        return sum;
    }

    public boolean contains(int integer) {
        if (this.values.length < 16) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == integer) {
                    return true;
                }
                if (this.values[i] <= integer) continue;
                return false;
            }
        }
        return Arrays.binarySearch(this.values, integer) > -1;
    }

    public boolean containsAny(IntegerSet b) {
        if (b.isEmpty() || this.max() < b.min() || this.min() > b.max()) {
            return false;
        }
        int i2 = 0;
        for (int i = 0; i < this.values.length; ++i) {
            while (i2 < b.values.length && b.values[i2] < this.values[i]) {
                ++i2;
            }
            if (i2 == b.values.length || this.values[i] != b.values[i2]) continue;
            return true;
        }
        return false;
    }

    public boolean isSubsetOf(IntegerSet b) {
        if (b.isEmpty() || b.size() < this.size() || this.values[0] < b.values[0] || this.values[this.values.length - 1] > b.values[b.values.length - 1]) {
            return false;
        }
        int i2 = 0;
        for (int i = 0; i < this.values.length; ++i) {
            while (i2 < b.values.length && b.values[i2] < this.values[i]) {
                ++i2;
            }
            if (i2 != b.values.length && b.values[i2] <= this.values[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictSubsetOf(IntegerSet b) {
        return !this.equals(b) && this.isSubsetOf(b);
    }

    public boolean equals(Object o) {
        if (o instanceof IntegerSet) {
            IntegerSet cis = (IntegerSet)o;
            if (this.isEmpty() != cis.isEmpty()) {
                return false;
            }
            if (cis.hashCode != -1 && this.hashCode != -1 && cis.hashCode != this.hashCode || cis.values.length != this.values.length) {
                return false;
            }
            if (cis.values[cis.values.length - 1] != this.values[this.values.length - 1]) {
                return false;
            }
            for (int i = 0; i < this.values.length - 1; ++i) {
                if (this.values[i] == cis.values[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void computeHashCode() {
        int hash = 1;
        for (int i = 0; i < this.values.length; ++i) {
            hash = (hash + 1) * (1 + this.values[i] * i * i) % 0xFFFFFF;
        }
        this.hashCode = hash;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    public Set<Integer> toSet() {
        LinkedHashSet<Integer> retVal = new LinkedHashSet<Integer>();
        for (int i : this.values) {
            retVal.add(i);
        }
        return retVal;
    }

    public List<Integer> toList() {
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        for (int i : this.values) {
            retVal.add(i);
        }
        return retVal;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return "IntegerSet" + VectorUtils.intArrayToString(this.values);
    }

    public int[] values() {
        return this.values;
    }

    public int size() {
        return this.values.length;
    }

    private static class EmptySet
    extends IntegerSet {
        private EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(int integer) {
            return false;
        }

        @Override
        public boolean isSubsetOf(IntegerSet b) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EmptySet;
        }

        @Override
        public String toString() {
            return "EmptySet[]";
        }

        @Override
        public int[] values() {
            return new int[0];
        }

        @Override
        public Set<Integer> toSet() {
            return new HashSet<Integer>(1);
        }
    }
}

