/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class VectorSet {
    private static Random random = new Random();
    private int startTwoPow = 5;
    private int capacity = BigInteger.probablePrime(this.startTwoPow, random).intValue();
    private int size;
    private int[][] data = new int[this.capacity][];
    private List<int[]>[] collisions = new List[this.capacity];

    public final void add(int[] vector) {
        int hash = this.hash(vector);
        if (this.data[hash] == null) {
            this.data[hash] = vector;
            ++this.size;
        } else {
            if (this.collisions[hash] == null) {
                this.collisions[hash] = new ArrayList<int[]>(1);
            }
            for (int[] array : this.collisions[hash]) {
                if (!Arrays.equals(array, vector)) continue;
                return;
            }
            this.collisions[hash].add(vector);
            ++this.size;
        }
        if ((double)this.size >= (double)this.capacity / 1.5 + 1.0) {
            this.resize();
        }
    }

    private void resize() {
        ++this.startTwoPow;
        this.capacity = BigInteger.probablePrime(this.startTwoPow, random).intValue();
        int[][] oldData = this.data;
        List<int[]>[] oldCollisions = this.collisions;
        this.data = new int[this.capacity][];
        this.collisions = new List[this.capacity];
        for (int i = 0; i < oldData.length; ++i) {
            if (oldData[i] == null) continue;
            this.add(oldData[i]);
        }
        for (List<int[]> list : oldCollisions) {
            if (list == null) continue;
            for (int[] array : list) {
                this.add(array);
            }
        }
    }

    public final boolean contains(int[] vector) {
        int hash = this.hash(vector);
        int[] array0 = this.data[hash];
        if (Arrays.equals(array0, vector)) {
            return true;
        }
        if (this.collisions[hash] != null) {
            for (int[] array : this.collisions[hash]) {
                if (!Arrays.equals(array, vector)) continue;
                return true;
            }
        }
        return false;
    }

    public void printStats() {
        double num = 0.0;
        double max = 0.0;
        for (List<int[]> c : this.collisions) {
            if (c == null) continue;
            num += (double)c.size();
            max = Math.max(max, (double)c.size());
        }
        System.out.println("size: " + this.size + ", capacity: " + this.capacity + ", num collisions: " + num + ", max: " + max);
    }

    private int hash(int[] vector) {
        int ret = 0;
        int cap = this.capacity;
        for (int i = 0; i < vector.length; ++i) {
            ret = (ret + 1) * (vector[i] + 1 + i * i * i) % cap;
        }
        if (ret < 0) {
            ret = (cap - ret) % cap;
        }
        return ret;
    }
}

