/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.molecules.preprocessing.molecules;

public class Atom {
    private String name;
    private String type;
    private double charge;
    private double x;
    private double y;
    private double z;
    private int hashCode = -1;
    private int usedConstructor;

    public Atom(String name, String type) {
        this.name = name;
        this.type = type;
        this.usedConstructor = 1;
    }

    public Atom(String name, String type, double charge) {
        this(name, type);
        this.charge = charge;
        this.usedConstructor = 2;
    }

    public Atom(String name, String type, double charge, double x, double y, double z) {
        this(name, type, charge);
        this.x = x;
        this.y = y;
        this.z = z;
        this.usedConstructor = 3;
    }

    private void computeHashCode() {
        int hash = 5;
        hash = 23 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 23 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 23 * hash + (int)(Double.doubleToLongBits(this.charge) ^ Double.doubleToLongBits(this.charge) >>> 32);
        hash = 23 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 23 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        this.hashCode = hash = 23 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
    }

    public boolean equals(Object obj) {
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (obj instanceof Atom) {
            Atom a = (Atom)obj;
            return a.name.equals(this.name) && a.type.equals(this.type) && a.charge == this.charge && a.x == this.x && a.y == this.y && a.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public double getCharge() {
        return this.charge;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Atom[");
        sb.append(this.name);
        sb.append(", type = ");
        sb.append(this.type);
        if (this.usedConstructor > 1) {
            sb.append(", charge = ");
            sb.append(this.charge);
        }
        if (this.usedConstructor > 2) {
            sb.append(", x = ");
            sb.append(this.x);
            sb.append(", y = ");
            sb.append(this.y);
            sb.append(", z = ");
            sb.append(this.z);
        }
        sb.append(")");
        return sb.toString();
    }
}

