/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.molecules.preprocessing.molecules;

import cz.cvut.fel.ida.utils.molecules.preprocessing.molecules.Atom;
import cz.cvut.fel.ida.utils.molecules.preprocessing.molecules.Bond;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;

public class Molecule {
    private String name;
    private TreeMap<String, Atom> atoms = new TreeMap();
    private Set<Bond> bonds = new LinkedHashSet<Bond>();
    private int hashCode = -1;

    public Molecule(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addAtom(Atom atom) {
        this.hashCode = -1;
        this.atoms.put(atom.getName(), atom);
    }

    public void addBond(Bond bond) {
        this.hashCode = -1;
        this.bonds.add(bond);
    }

    public Collection<Atom> atoms() {
        return this.atoms.values();
    }

    public Atom getAtom(String name) {
        return this.atoms.get(name);
    }

    public Collection<Bond> bonds() {
        return this.bonds;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int hash = 5;
            hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 79 * hash + (this.atoms != null ? this.atoms.hashCode() : 0);
            this.hashCode = hash = 79 * hash + (this.bonds != null ? this.bonds.hashCode() : 0);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Molecule other = (Molecule)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!(this.atoms == other.atoms || this.atoms != null && this.atoms.equals(other.atoms))) {
            return false;
        }
        return this.bonds == other.bonds || this.bonds != null && this.bonds.equals(other.bonds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Molecule[");
        sb.append(this.name);
        sb.append(", ");
        sb.append(this.atoms);
        sb.append(", ");
        sb.append(this.bonds);
        sb.append("]");
        return sb.toString();
    }
}

