/*
 * Decompiled with CFR 0.152.
 */
import java.util.logging.Logger;
import pipelines.Pipeline;
import settings.Settings;
import settings.Sources;
import utils.generic.Pair;
import utils.logging.Logging;

public class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        Main.main(args, new Settings());
    }

    public static void main(String[] args, Settings settings) {
        Pipeline<Sources, ?> pipeline;
        Logging logging = Logging.initLogging();
        if (settings == null) {
            settings = new Settings();
        }
        Sources sources = Sources.getSources(args, settings);
        settings.root = pipeline = Pipeline.getPipeline(settings, sources);
        LOG.finest("Running the main pipeline on the provided sources...");
        Pair<String, ?> target = pipeline.execute(sources);
        LOG.info("Pipeline: " + (String)target.r + " finished with result: " + target.s.toString());
        logging.finish();
    }

    public static String testConnection(String msg) {
        return msg + " succesfully connected";
    }
}

