/*
 * Decompiled with CFR 0.152.
 */
package constructs.building;

import constructs.Conjunction;
import constructs.building.SamplesBuilder;
import constructs.example.LiftedExample;
import constructs.example.LogicSample;
import constructs.example.ValuedFact;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import java.util.stream.Stream;
import parsing.antlr.NeuralogicParser;
import parsing.examples.PlainExamplesParseTree;
import parsing.examples.PlainExamplesParseTreeExtractor;
import parsing.grammarParsing.PlainGrammarVisitor;
import pipelines.Pipeline;
import settings.Settings;
import utils.generic.Pair;

public class ExamplesBuilder
extends SamplesBuilder<PlainExamplesParseTree, Pair<Conjunction, LiftedExample>> {
    private static final Logger LOG = Logger.getLogger(ExamplesBuilder.class.getName());

    public ExamplesBuilder(Settings settings) {
        super(settings);
    }

    @Override
    public PlainExamplesParseTree parseTreeFrom(Reader reader) {
        try {
            return new PlainExamplesParseTree(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Pair<Conjunction, LiftedExample>> buildFrom(PlainExamplesParseTree parseTree) {
        PlainGrammarVisitor plainGrammarVisitor = new PlainGrammarVisitor(this);
        PlainExamplesParseTreeExtractor examplesParseTreeExtractor = new PlainExamplesParseTreeExtractor(plainGrammarVisitor);
        NeuralogicParser.ExamplesFileContext examplesFileContext = parseTree.getRoot();
        this.inferInputFormatSettings(examplesFileContext);
        return examplesParseTreeExtractor.getLabeledExamples(examplesFileContext);
    }

    @Override
    public Stream<LogicSample> sampleFrom(Pair<Conjunction, LiftedExample> pair) {
        LiftedExample example = (LiftedExample)pair.s;
        if (pair.r == null || ((Conjunction)pair.r).facts == null || ((Conjunction)pair.r).facts.size() == 0) {
            return Stream.of(this.createUnlabeledSample(String.valueOf(this.queryCounter), example));
        }
        if (((Conjunction)pair.r).facts.size() == 1 && ((Conjunction)pair.r).facts.get(0).getValue() == null) {
            ValuedFact query2 = ((Conjunction)pair.r).facts.get(0);
            return Stream.of(new LogicSample(null, this.createQueryAtom(query2.literal.toString(), query2, example)));
        }
        if (((Conjunction)pair.r).facts.size() == 1 && ((Conjunction)pair.r).facts.get(0).getValue() != null) {
            ValuedFact query3 = ((Conjunction)pair.r).facts.get(0);
            return Stream.of(new LogicSample(query3.getValue(), this.createQueryAtom(String.valueOf(this.queryCounter), query3, example))).peek(s -> LOG.fine("New Sample created " + s.toString()));
        }
        String minibatch = String.valueOf(this.queryCounter);
        return ((Conjunction)pair.r).facts.stream().map(query -> new LogicSample(query.getValue(), this.createQueryAtom(this.settings.queriesBatchPrefix + minibatch, (ValuedFact)query, example))).peek(s -> LOG.fine("New Batch Sample created " + s.toString()));
    }

    private LogicSample createUnlabeledSample(String id, LiftedExample example) {
        return new LogicSample(null, this.createQueryAtom(id, null, example));
    }

    private void inferInputFormatSettings(NeuralogicParser.ExamplesFileContext examplesFileContext) {
        if (examplesFileContext.liftedExample().size() == 0) {
            LOG.warning("There are no examples in the example source (file)!");
        } else if (examplesFileContext.liftedExample().size() == 1) {
            LOG.info("Detecting exactly 1 (big) example in the examples source (file), switching to knowledge-base mode.");
            if (this.settings.groundingMode != Settings.GroundingMode.GLOBAL) {
                this.settings.groundingMode = Settings.GroundingMode.GLOBAL;
                LOG.warning("Settings were set to a different grounding mode than detected! Will perform online rebuild of the grounding pipeline!");
                Pipeline groundingPipeline = this.settings.root.findPipeline("GroundingPipeline");
                if (groundingPipeline == null) {
                    LOG.severe("Not able to rebuild grounding pipeline to perform GLOBAL grounding!!");
                } else {
                    groundingPipeline.rebuild(this.settings);
                }
            }
        } else {
            LOG.info("Detecting multiple individual examples in the examples source (file), assuming independent graph mode");
            this.settings.queriesAlignedWithExamples = true;
            if (this.settings.groundingMode != Settings.GroundingMode.STANDARD) {
                this.settings.groundingMode = Settings.GroundingMode.STANDARD;
                LOG.warning("Settings were set to a different grounding mode than detected! Will perform online rebuild of the grounding pipeline!");
                Pipeline groundingPipeline = this.settings.root.findPipeline("GroundingPipeline");
                groundingPipeline.rebuild(this.settings);
            }
        }
        if (examplesFileContext.label() != null && !examplesFileContext.label().isEmpty()) {
            this.settings.queriesAlignedWithExamples = false;
            LOG.info("Detecting examples to have ids/queries with them.");
        }
    }
}

