/*
 * Decompiled with CFR 0.152.
 */
package constructs.building;

import constructs.building.LogicSourceBuilder;
import constructs.example.LiftedExample;
import constructs.example.LogicSample;
import constructs.example.QueryAtom;
import constructs.example.ValuedFact;
import constructs.template.components.HeadAtom;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import learning.Example;
import learning.LearningSample;
import org.antlr.v4.runtime.ParserRuleContext;
import parsing.grammarParsing.PlainParseTree;
import settings.Settings;
import utils.Utilities;
import utils.generic.Pair;

public abstract class SamplesBuilder<I extends PlainParseTree<? extends ParserRuleContext>, O>
extends LogicSourceBuilder<I, Stream<O>> {
    private static final Logger LOG = Logger.getLogger(SamplesBuilder.class.getName());
    final String prefix;
    int queryCounter = 0;

    public SamplesBuilder(Settings settings) {
        this.settings = settings;
        this.prefix = settings.sampleIdPrefix;
    }

    public Stream<LogicSample> buildSamplesFrom(I parseTree) {
        return ((Stream)this.buildFrom(parseTree)).flatMap(this::sampleFrom);
    }

    protected abstract Stream<LogicSample> sampleFrom(O var1);

    public Stream<LogicSample> merge2streams(Stream<LogicSample> queries, Stream<LogicSample> examples) {
        AbstractMap map;
        if (this.settings.queriesAlignedWithExamples) {
            return Utilities.zipStreams(queries, examples, SamplesBuilder::merge2samples);
        }
        LOG.warning("Could not infer whether queries are directly aligned with examples, will need to consume (iterate) the stream first to align them!");
        if (queries.isParallel() || examples.isParallel()) {
            if (this.settings.oneQueryPerExample && this.settings.groundingMode != Settings.GroundingMode.GLOBAL) {
                ConcurrentMap<String, LogicSample> sampleMap = Stream.concat(queries, examples).collect(Collectors.toConcurrentMap(LearningSample::getId, q -> q, SamplesBuilder::merge2samples));
                return this.getSortedLogicSampleStream(sampleMap);
            }
            map = new ConcurrentHashMap();
        } else {
            if (this.settings.oneQueryPerExample && this.settings.groundingMode != Settings.GroundingMode.GLOBAL) {
                Map<String, LogicSample> sampleMap = Stream.concat(queries, examples).collect(Collectors.toMap(LearningSample::getId, q -> q, SamplesBuilder::merge2samples));
                return this.getSortedLogicSampleStream(sampleMap);
            }
            map = new HashMap();
        }
        examples.forEach(ls -> map.put(ls.getId(), new Pair(((QueryAtom)ls.query).evidence, new ArrayList())));
        if (map.size() == 0) {
            LOG.severe("There are no learning examples created!");
        } else if (map.size() == 1) {
            LOG.info("A single large example created. All queries will refer to it.");
            Pair pair2 = (Pair)map.values().iterator().next();
            queries.forEach(ls -> {
                ((QueryAtom)ls.query).evidence = (Example)pair.r;
                List qs = (List)pair.s;
                qs.add(ls);
                LOG.fine("Extracted Sample: " + ls);
            });
        } else {
            LOG.info("Multiple examples created. Will try to match them against the provided queries");
            queries.forEach(ls -> {
                Pair pair = (Pair)map.get(ls.getId());
                ((QueryAtom)ls.query).evidence = (Example)pair.r;
                List qs = (List)pair.s;
                LOG.fine("Extracted Sample: " + ls);
            });
        }
        return map.values().stream().map(pair -> ((List)pair.s).stream()).flatMap(f -> f);
    }

    private Stream<LogicSample> getSortedLogicSampleStream(Map<String, LogicSample> sampleMap) {
        LOG.info("Consumed 2 input streams of " + sampleMap.size() + " samples (queries+examples)");
        ArrayList<LogicSample> logicSamples = new ArrayList<LogicSample>(sampleMap.values());
        logicSamples.sort(LogicSample::compare);
        return logicSamples.stream();
    }

    private static LogicSample merge2samples(LogicSample q1, LogicSample q2) {
        LogicSample query;
        LogicSample example = ((QueryAtom)q1.query).evidence != null ? q1 : q2;
        LogicSample logicSample = query = q1.target != null ? q1 : q2;
        if (query == example) {
            LOG.severe("Example-Query merging inconsistency: " + q1 + " + " + q2);
        }
        ((QueryAtom)query.query).evidence = ((QueryAtom)example.query).evidence;
        LOG.info("Example and query have been merged into Sample: " + query);
        return query;
    }

    public QueryAtom createQueryAtom(String id, ValuedFact f, LiftedExample example) {
        HeadAtom headAtom = f == null ? null : new HeadAtom(f.offsettedPredicate, f.literal.termList());
        return new QueryAtom(this.prefix + id, this.queryCounter++, this.settings.defaultSampleImportance, headAtom, example);
    }

    public QueryAtom createQueryAtom(String id, double importance, ValuedFact f) {
        return new QueryAtom(this.prefix + id, this.queryCounter++, importance, new HeadAtom(f.offsettedPredicate, f.literal.termList()));
    }

    public QueryAtom createQueryAtom(String id, ValuedFact f) {
        return new QueryAtom(this.prefix + id, this.queryCounter++, this.settings.defaultSampleImportance, new HeadAtom(f.offsettedPredicate, f.literal.termList()));
    }
}

