/*
 * Decompiled with CFR 0.152.
 */
package constructs.building;

import constructs.Conjunction;
import constructs.WeightedPredicate;
import constructs.building.LogicSourceBuilder;
import constructs.example.ValuedFact;
import constructs.template.Template;
import constructs.template.components.WeightedRule;
import constructs.template.metadata.PredicateMetadata;
import constructs.template.metadata.TemplateMetadata;
import constructs.template.metadata.WeightMetadata;
import constructs.template.types.ParsedTemplate;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import networks.structure.components.weights.Weight;
import parsing.antlr.NeuralogicParser;
import parsing.grammarParsing.PlainGrammarVisitor;
import parsing.template.PlainTemplateParseTree;
import parsing.template.PlainTemplateParseTreeExtractor;
import settings.Settings;
import utils.generic.Pair;

public class TemplateBuilder
extends LogicSourceBuilder<PlainTemplateParseTree, ParsedTemplate> {
    private static final Logger LOG = Logger.getLogger(TemplateBuilder.class.getName());

    public TemplateBuilder(Settings settings) {
        this.settings = settings;
    }

    @Override
    public PlainTemplateParseTree parseTreeFrom(Reader reader) {
        if (this.settings.plaintextInput) {
            try {
                return new PlainTemplateParseTree(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            LOG.severe("Formats other than plaintext are not supported yet!");
        }
        return null;
    }

    public ParsedTemplate buildTemplateFrom(Reader reader) {
        if (reader != null) {
            return this.buildFrom(this.parseTreeFrom(reader));
        }
        LOG.severe("No way to create template from sources at request");
        return null;
    }

    @Override
    public ParsedTemplate buildFrom(PlainTemplateParseTree plainParseTree) {
        PlainGrammarVisitor plainGrammarVisitor = new PlainGrammarVisitor(this);
        return this.buildFrom(plainParseTree, new PlainTemplateParseTreeExtractor(plainGrammarVisitor));
    }

    public ParsedTemplate buildFrom(PlainTemplateParseTree plainParseTree, PlainTemplateParseTreeExtractor templateParseTreeExtractor) {
        NeuralogicParser.TemplateFileContext parseTreeRoot = plainParseTree.getRoot();
        List<WeightedRule> weightedRules = templateParseTreeExtractor.getWeightedRules(parseTreeRoot);
        List<ValuedFact> valuedFacts = templateParseTreeExtractor.getWeightedFacts(parseTreeRoot);
        List<Conjunction> weightedConjunctions = templateParseTreeExtractor.getWeightedConjunctions(parseTreeRoot);
        List<Pair<WeightedPredicate, Map<String, Object>>> predicatesMetadata = templateParseTreeExtractor.getPredicatesMetadata(parseTreeRoot);
        List<Pair<Weight, Map<String, Object>>> weightsMetadata = templateParseTreeExtractor.getWeightsMetadata(parseTreeRoot);
        Map<String, Object> templateMetadata = templateParseTreeExtractor.getTemplateMetadata(parseTreeRoot);
        ParsedTemplate template = new ParsedTemplate(weightedRules, valuedFacts);
        template.addConstraints(weightedConjunctions);
        template.originalString = ((NeuralogicParser)plainParseTree.parseTree).getInputStream().getText();
        if (templateMetadata != null) {
            template.templateMetadata = new TemplateMetadata(this.settings, templateMetadata);
        }
        template.predicatesMetadata = predicatesMetadata.stream().map(pair -> new Pair(pair.r, new PredicateMetadata(this.settings, (Map)pair.s))).collect(Collectors.toList());
        template.weightsMetadata = weightsMetadata.stream().map(pair -> new Pair(pair.r, new WeightMetadata(this.settings, (Map)pair.s))).collect(Collectors.toList());
        LOG.fine("Template has been built : " + template);
        return template;
    }

    public Template extendTemplateWith(Reader reader, Settings settings) {
        return null;
    }
}

