/*
 * Decompiled with CFR 0.152.
 */
package constructs.building.debugging;

import constructs.example.LogicSample;
import constructs.template.Template;
import java.util.logging.Logger;
import java.util.stream.Stream;
import pipelines.Pipeline;
import pipelines.pipes.generic.FirstFromPairPipe;
import pipelines.pipes.generic.StreamifyPipe;
import settings.Settings;
import settings.Sources;
import utils.Debugger;
import utils.drawing.TemplateDrawer;
import utils.generic.Pair;

public class TemplateDebugger
extends Debugger<Template> {
    private static final Logger LOG = Logger.getLogger(TemplateDebugger.class.getName());

    public TemplateDebugger(Settings settings) {
        super(settings);
        this.drawer = new TemplateDrawer(settings);
    }

    public TemplateDebugger(Sources sources, Settings settings) {
        super(sources, settings);
        this.drawer = new TemplateDrawer(settings);
    }

    public TemplateDebugger(String[] args, Settings settings) {
        super(args, settings);
        this.drawer = new TemplateDrawer(settings);
    }

    @Override
    public void debug(Template obj) {
        this.drawer.draw(obj);
    }

    @Override
    public Pipeline<Sources, Stream<Template>> buildPipeline() {
        Pipeline<Sources, Pair<Template, Stream<LogicSample>>> sourcesPairPipeline = this.pipeline.registerStart(this.end2endTrainigBuilder.buildFromSources(this.sources, this.settings));
        this.pipeline.registerEnd(this.pipeline.register(sourcesPairPipeline.connectAfter(new FirstFromPairPipe())).connectAfter(new StreamifyPipe()));
        return this.pipeline;
    }
}

