/*
 * Decompiled with CFR 0.152.
 */
package constructs.example;

import constructs.example.LiftedExample;
import constructs.template.Template;
import constructs.template.components.HeadAtom;
import grounding.GroundTemplate;
import grounding.Grounder;
import learning.Query;
import networks.computation.evaluation.values.ScalarValue;
import settings.Settings;

public class QueryAtom
extends Query<LiftedExample, Template> {
    public HeadAtom headAtom;

    public QueryAtom(String id, int queryCounter, double importance, HeadAtom query, LiftedExample evidence) {
        super(id, queryCounter, importance, evidence);
        this.headAtom = query;
    }

    public QueryAtom(String id, int queryCounter, double importance, HeadAtom query) {
        super(id, queryCounter, importance, null);
        this.headAtom = query;
    }

    public ScalarValue evaluate(Settings settings, Template template) {
        LiftedExample example = (LiftedExample)this.evidence;
        Grounder grounder = Grounder.getGrounder(settings);
        GroundTemplate groundTemplate = grounder.groundRulesAndFacts(example, template);
        ScalarValue present = groundTemplate.groundFacts.containsKey(this.headAtom.literal) || groundTemplate.groundRules.keySet().contains(this.headAtom.literal) ? new ScalarValue(1.0) : new ScalarValue(0.0);
        return present;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.headAtom != null) {
            sb.append(this.headAtom.toString());
        }
        if (this.evidence != null) {
            sb.append(" <- " + ((LiftedExample)this.evidence).toString());
        }
        return sb.toString();
    }
}

