/*
 * Decompiled with CFR 0.152.
 */
package constructs.example;

import constructs.Atom;
import constructs.WeightedPredicate;
import ida.ilp.logic.Term;
import java.util.List;
import java.util.logging.Logger;
import networks.computation.evaluation.values.Value;
import networks.structure.components.weights.Weight;

public class ValuedFact
extends Atom {
    private static final Logger LOG = Logger.getLogger(Atom.class.getName());
    public Weight weight;

    public ValuedFact(WeightedPredicate weightedPredicate, List<Term> terms, boolean negated, Weight weight) {
        super(weightedPredicate, terms, negated);
        if (weight != null) {
            this.weight = weight;
            this.setValue(weight.value);
        }
    }

    public Weight getOffset() {
        return this.offsettedPredicate.weight;
    }

    public Value getValue() {
        if (this.weight != null) {
            return this.weight.value;
        }
        return null;
    }

    public void setValue(Value value) {
        if (this.weight != null) {
            this.weight.value = value;
        } else {
            LOG.warning("Setting a ValuedFact value without a weight");
            this.weight = new Weight(-1, "foo", value, true, true);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.weight != null) {
            sb.append("w:").append(this.weight.toString()).append(" : ");
        }
        sb.append(super.toString());
        if (this.getOffset() != null) {
            sb.append(this.getOffset().toString());
        }
        return sb.toString();
    }
}

