/*
 * Decompiled with CFR 0.152.
 */
package constructs.template.metadata;

import constructs.template.metadata.Parameter;
import constructs.template.metadata.ParameterValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import settings.Settings;

public abstract class Metadata<T> {
    private static final Logger LOG = Logger.getLogger(Metadata.class.getName());
    Settings settings;
    protected Map<Parameter, ParameterValue> metadata;

    protected Metadata() {
    }

    public Metadata(Settings settings, Map<String, Object> stringObjectMap) {
        this.settings = settings;
        this.metadata = new LinkedHashMap<Parameter, ParameterValue>();
        for (Map.Entry<String, Object> ent : stringObjectMap.entrySet()) {
            this.addValidateMetadatum(ent.getKey(), ent.getValue());
        }
    }

    public abstract boolean addValidateMetadatum(String var1, Object var2);

    public abstract void applyTo(T var1);

    public static Metadata addAll(Metadata o, Metadata o1) {
        o.metadata.putAll(o1.metadata);
        return o;
    }

    public static Map<String, Object> merge(Map<String, Object> set1, Map<String, Object> set2) {
        set1.putAll(set2);
        return set1;
    }

    public Object getByName(String name) {
        ParameterValue parameterValue = this.metadata.get(new Parameter(name));
        if (parameterValue != null) {
            return parameterValue.value;
        }
        return null;
    }
}

