/*
 * Decompiled with CFR 0.152.
 */
package constructs.template.transforming;

import constructs.WeightedPredicate;
import constructs.template.components.WeightedRule;
import constructs.template.metadata.Metadata;
import constructs.template.metadata.PredicateMetadata;
import constructs.template.metadata.WeightMetadata;
import constructs.template.types.ParsedTemplate;
import java.util.logging.Logger;
import networks.structure.components.weights.Weight;
import settings.Settings;
import utils.generic.Pair;

public class MetadataProcessor {
    private static final Logger LOG = Logger.getLogger(MetadataProcessor.class.getName());

    public MetadataProcessor(Settings settings) {
    }

    public ParsedTemplate processMetadata(ParsedTemplate template) {
        for (Pair<WeightedPredicate, PredicateMetadata> pair : template.predicatesMetadata) {
            if (((WeightedPredicate)pair.r).metadata == null) {
                ((WeightedPredicate)pair.r).metadata = (PredicateMetadata)pair.s;
            } else {
                ((WeightedPredicate)pair.r).metadata.addAll((PredicateMetadata)pair.s);
            }
            ((WeightedPredicate)pair.r).metadata.applyTo((WeightedPredicate)pair.r);
        }
        for (Pair<Object, Metadata> pair : template.weightsMetadata) {
            if (((Weight)pair.r).metadata == null) {
                ((Weight)pair.r).metadata = (WeightMetadata)pair.s;
            } else {
                ((Weight)pair.r).metadata.addAll((WeightMetadata)pair.s);
            }
            ((WeightMetadata)pair.s).applyTo((Weight)pair.r);
        }
        for (WeightedRule weightedRule : template.rules) {
            if (weightedRule.getMetadata() == null) continue;
            weightedRule.getMetadata().applyTo(weightedRule);
        }
        if (template.templateMetadata != null) {
            template.templateMetadata.applyTo(template);
        }
        return template;
    }
}

