/*
 * Decompiled with CFR 0.152.
 */
package grounding.bottomUp;

import com.sun.istack.internal.NotNull;
import constructs.example.LiftedExample;
import constructs.example.ValuedFact;
import constructs.template.Template;
import constructs.template.components.GroundHeadRule;
import constructs.template.components.GroundRule;
import constructs.template.components.WeightedRule;
import grounding.GroundTemplate;
import grounding.Grounder;
import grounding.bottomUp.HerbrandModel;
import ida.ilp.logic.HornClause;
import ida.ilp.logic.Literal;
import ida.ilp.logic.Term;
import ida.utils.Sugar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import settings.Settings;
import utils.generic.Pair;

public class BottomUp
extends Grounder {
    private static final Logger LOG = Logger.getLogger(BottomUp.class.getName());
    HerbrandModel herbrandModel = new HerbrandModel();

    public BottomUp(Settings settings) {
        super(settings);
    }

    @Override
    @NotNull
    public GroundTemplate groundRulesAndFacts(LiftedExample example, Template template) {
        Set<Literal> templateAllFacts;
        Map ruleMap = template.hornClauses;
        Map groundFacts = null;
        if (example.rules.isEmpty() && ruleMap != null) {
            groundFacts = this.mapToLogic((Set)this.rulesAndFacts((LiftedExample)example, (Template)template).s);
        } else {
            Pair<Map<HornClause, List<WeightedRule>>, Map<Literal, ValuedFact>> rulesAndFacts = this.mapToLogic(this.rulesAndFacts(example, template));
            ruleMap = (Map)rulesAndFacts.r;
            groundFacts = (Map)rulesAndFacts.s;
            template.hornClauses = ruleMap;
        }
        LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, LinkedHashSet<GroundRule>>> groundRules = new LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, LinkedHashSet<GroundRule>>>();
        Set<Literal> facts = groundFacts.keySet();
        if (this.settings.inferTemplateFacts && (templateAllFacts = template.getAllFacts()) != null) {
            facts.addAll(templateAllFacts);
        }
        LOG.fine("Infering Herbrand model...");
        this.herbrandModel.inferModel(ruleMap.keySet(), facts);
        Map<Literal, Literal> allLiterals = Sugar.flatten(this.herbrandModel.herbrand.values()).stream().collect(Collectors.toMap(l -> l, l -> l));
        LOG.fine("...HerbrandModel inferred with " + allLiterals.size() + " facts");
        LOG.fine("Grounding of " + ruleMap.size() + " rules...");
        for (Map.Entry ruleEntry : ruleMap.entrySet()) {
            Pair<Term[], List<Term[]>> groundingSubstitutions = this.herbrandModel.groundingSubstitutions((HornClause)ruleEntry.getKey());
            for (WeightedRule weightedRule : (List)ruleEntry.getValue()) {
                List<GroundRule> groundings = this.herbrandModel.groundRules(weightedRule, groundingSubstitutions);
                for (GroundRule grounding : groundings) {
                    grounding.internLiterals(allLiterals);
                    Map rules2groundings = groundRules.computeIfAbsent(grounding.groundHead, k -> new LinkedHashMap());
                    GroundHeadRule groundHeadRule = weightedRule.groundHeadRule(grounding.groundHead);
                    LinkedHashSet ruleGroundings = rules2groundings.computeIfAbsent(groundHeadRule, k -> new LinkedHashSet());
                    ruleGroundings.add(grounding);
                }
            }
        }
        LOG.fine("...ground rules created.");
        GroundTemplate groundTemplate = new GroundTemplate(groundRules, groundFacts);
        this.herbrandModel.clear();
        return groundTemplate;
    }

    @Override
    public GroundTemplate groundRulesAndFacts(LiftedExample example, Template template, GroundTemplate memory) {
        if (memory == null) {
            memory = new GroundTemplate();
        }
        this.herbrandModel.populateHerbrand(memory.groundFacts.keySet());
        this.herbrandModel.populateHerbrand(memory.derivedGroundFacts);
        GroundTemplate bigger = this.groundRulesAndFacts(example, template);
        GroundTemplate diff = bigger.diffAgainst(memory);
        memory.groundRules = bigger.groundRules;
        memory.groundFacts = bigger.groundFacts;
        memory.derivedGroundFacts = bigger.derivedGroundFacts;
        return diff;
    }
}

