/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.logic;

import ida.ilp.logic.Clause;
import ida.ilp.logic.Constant;
import ida.ilp.logic.Literal;
import ida.ilp.logic.LogicUtils;
import ida.ilp.logic.Term;
import ida.ilp.logic.Variable;
import ida.ilp.logic.subsumption.Matching;
import ida.utils.Sugar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class HornClause {
    private static final Logger LOG = Logger.getLogger(HornClause.class.getName());
    private Clause body;
    private Literal head;

    public static Literal head(Clause c) {
        Literal head = null;
        int pos = 0;
        for (Literal l : c.literals()) {
            if (l.isNegated()) continue;
            head = l;
            ++pos;
        }
        if (pos == 1 && c.literals().size() > 1) {
            return head;
        }
        return null;
    }

    public HornClause(Literal head, Clause body) {
        this.head = head;
        this.body = body;
    }

    public HornClause(Clause c) {
        int pos = 0;
        for (Literal l : c.literals()) {
            if (l.isNegated()) continue;
            this.head = l;
            ++pos;
        }
        if (pos == 0) {
            this.body = LogicUtils.flipSigns(c);
        } else if (pos == 1) {
            this.body = LogicUtils.flipSigns(new Clause(Sugar.setDifference(c.literals(), this.head)));
        }
        if (pos > 1) {
            this.head = null;
            LOG.warning("Couldn't create HornClause from a given Clause");
        }
    }

    public Clause unify(Literal query) {
        if (query.predicateName() != this.head.predicateName() || query.arity() != this.head.arity()) {
            return null;
        }
        HashMap<Term, Term> subs = new HashMap<Term, Term>();
        for (int i = 0; i < query.arity(); ++i) {
            Term ht = this.head.get(i);
            Term qt = query.get(i);
            if (ht instanceof Constant && !ht.equals(qt)) {
                return null;
            }
            if (!(ht instanceof Variable)) continue;
            if (subs.containsKey(ht)) {
                Term substituted = (Term)subs.get(ht);
                if (substituted.equals(qt)) continue;
                return null;
            }
            subs.put(ht, qt);
        }
        return LogicUtils.flipSigns(LogicUtils.substitute(this.body, subs));
    }

    public Set<Variable> variables() {
        return Sugar.union(this.body.variables(), this.variables(this.head));
    }

    private Set<Variable> variables(Literal l) {
        HashSet<Variable> retVal = new HashSet<Variable>();
        if (l != null) {
            for (int i = 0; i < l.arity(); ++i) {
                if (!(l.get(i) instanceof Variable)) continue;
                retVal.add((Variable)l.get(i));
            }
        }
        return retVal;
    }

    public Literal head() {
        return this.head;
    }

    public Clause body() {
        return this.body;
    }

    public Set<Literal> getLiterals() {
        HashSet<Literal> literalSet = new HashSet<Literal>(this.body.literals());
        literalSet.add(this.head);
        return literalSet;
    }

    public Set<Literal> getNegatedLiterals() {
        HashSet<Literal> literalSet = new HashSet<Literal>(this.body.literals());
        literalSet.add(this.head.negation());
        return literalSet;
    }

    public Clause toClause() {
        return new Clause(Sugar.union(LogicUtils.flipSigns(this.body().literals()), this.head() == null ? Sugar.list() : Sugar.list(this.head)));
    }

    public String toString() {
        if (this.head == null) {
            return " <- " + this.body.toString();
        }
        return this.head.toString() + " <- " + this.body.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof HornClause) {
            HornClause hc = (HornClause)o;
            return hc.body.equals(this.body) && (hc.head == this.head || hc.head != null && this.head != null && hc.head.equals(this.head));
        }
        return false;
    }

    public int hashCode() {
        return this.body.hashCode() + (this.head == null ? 0 : this.head.hashCode());
    }

    public static boolean subsumption(HornClause query, HornClause target) {
        return HornClause.subsumption(query, target, new Matching());
    }

    public static boolean subsumption(HornClause query, HornClause target, Matching matching) {
        Clause unified = LogicUtils.flipSigns(query.unify(target.head()));
        return matching.subsumption(unified, target.body());
    }

    public static void main(String[] args) {
        HornClause c = new HornClause(Clause.parse("a(X,Y),!b(X),!b(X,Y),!c(X,Y,Z)"));
        HornClause d = new HornClause(Clause.parse("a(X,Y),!b(X,Y),!c(X,Y,Z)"));
        HornClause e = new HornClause(Clause.parse("a(X,Y),!b(X,Y),!c(X,Y,Z),!c(Z,Y,X)"));
        Literal q = Literal.parseLiteral("a(1,A)");
        System.out.println(HornClause.subsumption(d, c));
        System.out.println(HornClause.subsumption(e, c));
    }
}

