/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.logic;

import ida.ilp.logic.Constant;
import ida.ilp.logic.ParserUtils;
import ida.ilp.logic.Term;
import ida.ilp.logic.Variable;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrologList
implements Term {
    private int hashCode = -1;
    private Term[] items;
    private String toString;

    public PrologList(int itemsCount) {
        this.items = new Term[itemsCount];
    }

    public PrologList(List<Term> termList) {
        this(termList.size());
        int index = 0;
        Iterator<Term> iterator = termList.iterator();
        while (iterator.hasNext()) {
            Term t;
            this.items[index] = t = iterator.next();
            ++index;
        }
    }

    public Term get(int index) {
        return this.items[index];
    }

    public void set(Term term, int index) {
        this.items[index] = term;
    }

    public int countItems() {
        return this.items.length;
    }

    public boolean equals(Object o) {
        if (o instanceof PrologList) {
            PrologList pl = (PrologList)o;
            return pl.toString().equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.toString(this.items, null);
        }
        return this.toString;
    }

    private String toString(Term[] items, String type) {
        StringBuilder sb = new StringBuilder();
        if (type != null) {
            sb.append(type + ":");
        }
        sb.append("[");
        for (int i = 0; i < items.length; ++i) {
            sb.append(items[i]);
            if (i >= items.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String name() {
        return this.toString(this.items, null);
    }

    @Override
    public String type() {
        return null;
    }

    public PrologList flatten() {
        ArrayList<Term> termList = new ArrayList<Term>();
        this.flatten(this, termList);
        return new PrologList(termList);
    }

    private void flatten(PrologList prologList, List<Term> termList) {
        for (Term t : prologList.items) {
            if (t instanceof PrologList) {
                this.flatten((PrologList)t, termList);
                continue;
            }
            termList.add(t);
        }
    }

    public static PrologList parseList(String str, Map<Variable, Variable> variables, Map<Constant, Constant> constants) {
        char[] c = str.toCharArray();
        int index = 0;
        while (c[index++] != '[') {
        }
        ArrayList items = new ArrayList();
        while (index < c.length && c[index] != ']') {
            if (c[index] != ' ') {
                Pair<Term, Integer> pair = ParserUtils.parseTerm(c, index, ']', variables, constants);
                items.add(pair.r);
                index = (Integer)pair.s;
            }
            ++index;
        }
        PrologList retVal = new PrologList(items.size());
        for (int i = 0; i < items.size(); ++i) {
            retVal.set((Term)items.get(i), i);
        }
        return retVal;
    }
}

