/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.logic.io;

import ida.ilp.logic.Literal;
import ida.ilp.logic.LogicUtils;
import ida.ilp.logic.io.PrologParser;
import ida.utils.Sugar;
import ida.utils.tuples.Pair;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class Prolog2PseudoPrologReader
extends Reader {
    private StringReader sr;

    public Prolog2PseudoPrologReader(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean betweenBeginAndEnd = false;
        for (Pair<List<Literal>, List<Literal>> headTail : PrologParser.parse(reader, new String[0])) {
            Literal fact = (Literal)Sugar.chooseOne((Iterable)headTail.r);
            if (fact.predicateName().equalsIgnoreCase("begin")) {
                betweenBeginAndEnd = true;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                if (fact.arity() == 1) {
                    sb.append(new Literal("example_id", fact.get(0)));
                    continue;
                }
                if (fact.arity() <= 1) continue;
                sb.append("\"").append(LogicUtils.unquote(fact.get(1))).append("\" ").append(new Literal("example_id", fact.get(0)));
                continue;
            }
            if (fact.predicateName().equalsIgnoreCase("end")) {
                betweenBeginAndEnd = false;
                continue;
            }
            if (!betweenBeginAndEnd) continue;
            sb.append(", ").append(fact);
        }
        this.sr = new StringReader(sb.toString());
        this.sr.reset();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.sr.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.sr.close();
    }
}

