/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.logic.subsumption;

import ida.ilp.logic.subsumption.GlobalConstraint;
import ida.ilp.logic.subsumption.SubsumptionEngineJ2;
import ida.utils.VectorUtils;
import ida.utils.collections.IntegerSet;
import ida.utils.collections.ValueToIndex;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Stack;

public class MaxCardXorConstraint
implements GlobalConstraint {
    private ValueToIndex<Integer> termIdsToIndices = new ValueToIndex();
    private boolean[] certainOnes;
    private boolean[] certainZeros;
    private BitSet[] system;
    private static final int SWAP = 1;
    private static final int ADD = 2;
    private static final int SET = 3;
    private static final int STOP = 4;
    private int maxCard;
    private int numConstants = -1;
    private Stack<int[]> history = new Stack();
    private Stack<IntegerSet> termsInDomainsHistory = new Stack();

    private MaxCardXorConstraint(int maxCard, IntegerSet allRelevantTerms) {
        this.maxCard = maxCard;
        this.certainOnes = new boolean[allRelevantTerms.size()];
        this.certainZeros = new boolean[allRelevantTerms.size()];
        this.termsInDomainsHistory.push(allRelevantTerms);
        int[] allRelevant = allRelevantTerms.values();
        for (int i = 0; i < allRelevant.length; ++i) {
            this.termIdsToIndices.put(i, allRelevant[i]);
        }
    }

    public MaxCardXorConstraint(int maxCard, int numConstants, IntegerSet allRelevantTerms, boolean[][] leftHandSystem, boolean[] rightHandSystem, SubsumptionEngineJ2.ClauseC clauseC) {
        this(maxCard, allRelevantTerms);
        this.setXorSystem(leftHandSystem, rightHandSystem);
        this.numConstants = numConstants;
    }

    private void setXorSystem(boolean[][] left, boolean[] right) {
        BitSet[] s = new BitSet[left.length];
        for (int i = 0; i < left.length; ++i) {
            s[i] = VectorUtils.toBitSet(left[i]);
            s[i].set(left[i].length, right[i]);
        }
        this.system = s;
    }

    @Override
    public IntegerSet[] propagate(IntegerSet[] newDomains) {
        this.history.push(new int[]{4});
        IntegerSet termsInDomains = IntegerSet.union(newDomains);
        IntegerSet oldTermsInDomains = this.termsInDomainsHistory.peek();
        this.termsInDomainsHistory.push(termsInDomains);
        IntegerSet toBeSetToFalse = IntegerSet.difference(oldTermsInDomains, termsInDomains);
        for (int tbstf : toBeSetToFalse.values()) {
            int termIndex = this.termIdsToIndices.getIndex(tbstf);
            if (this.set_simple(termIndex, false)) continue;
            return null;
        }
        for (int i = 0; i < newDomains.length; ++i) {
            int termInDomainIndex;
            int termInDomain;
            if (newDomains[i].size() != 1 || !this.termIdsToIndices.containsValue(termInDomain = newDomains[i].values()[0]) || this.certainOnes[termInDomainIndex = this.termIdsToIndices.getIndex(termInDomain)] || this.set_simple(termInDomainIndex, true)) continue;
            return null;
        }
        if (!this.transformToRowEchelon()) {
            return null;
        }
        HashSet<Integer> forcedZerosSet = new HashSet<Integer>();
        for (int i = 0; i < this.system.length; ++i) {
            int forcedZero = this.forcedZero(i);
            if (forcedZero == -1) continue;
            forcedZerosSet.add(forcedZero);
        }
        IntegerSet forcedZeros = IntegerSet.createIntegerSet(forcedZerosSet);
        IntegerSet[] updatedDomains = new IntegerSet[newDomains.length];
        for (int i = 0; i < newDomains.length; ++i) {
            updatedDomains[i] = IntegerSet.difference(newDomains[i], forcedZeros);
        }
        return updatedDomains;
    }

    private boolean set_simple(int termIndex, boolean value) {
        if (value) {
            this.certainOnes[termIndex] = true;
        }
        if (!value) {
            this.certainZeros[termIndex] = false;
        }
        for (int i = 0; i < this.system.length; ++i) {
            if (!this.system[i].get(termIndex)) continue;
            this.history.add(new int[]{3, i, termIndex, value ? 1 : 0});
            this.system[i].set(termIndex, false);
            this.system[i].set(this.certainOnes.length, this.system[i].get(this.certainOnes.length) ^ value);
            if (this.isRowConsistent(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void undoPropagation() {
        int[] h;
        long m1 = System.nanoTime();
        while ((h = this.history.pop()) != null && h[0] != 4) {
            switch (h[0]) {
                case 1: {
                    this.swap(h[2], h[1], false);
                    break;
                }
                case 2: {
                    this.add(h[1], h[2], false);
                    break;
                }
                case 3: {
                    this.certainOnes[h[2]] = false;
                    this.certainZeros[h[2]] = false;
                    this.system[h[1]].set(h[2], true);
                    this.system[h[1]].set(this.certainOnes.length, this.system[h[1]].get(this.certainOnes.length) ^ h[3] == 1);
                }
            }
        }
        this.termsInDomainsHistory.pop();
        long m2 = System.nanoTime();
        System.out.println("undoing propagation: " + (double)(m2 - m1) / 1000000.0);
    }

    private boolean transformToRowEchelon() {
        int i;
        for (i = 0; i < this.system.length; ++i) {
            int j;
            int col = -1;
            int selected = 0;
            for (j = i; j < this.system.length; ++j) {
                int c = this.system[j].nextSetBit(0);
                if (c == this.certainOnes.length) {
                    return false;
                }
                if (c == -1 || c >= col && col != -1) continue;
                selected = j;
                col = c;
            }
            if (col == -1) break;
            if (selected > i) {
                this.swap(i, selected, true);
            }
            for (j = i + 1; j < this.system.length; ++j) {
                if (!this.system[j].get(col)) continue;
                this.add(i, j, true);
            }
        }
        for (i = 0; i < this.system.length; ++i) {
            if (!this.isRowConsistent(i)) {
                return false;
            }
            int forcedOne = this.forcedOne(i);
            if (forcedOne == -1 || this.certainOnes[forcedOne]) continue;
            this.set_simple(forcedOne, true);
        }
        return true;
    }

    private int forcedOne(int row) {
        int firstOne = this.system[row].nextSetBit(0);
        if (firstOne == -1) {
            return -1;
        }
        int secondOne = this.system[row].nextSetBit(firstOne + 1);
        if (secondOne == this.certainOnes.length) {
            return firstOne;
        }
        return -1;
    }

    private int forcedZero(int row) {
        int firstOne = this.system[row].nextSetBit(0);
        if (firstOne == -1) {
            return -1;
        }
        int secondOne = this.system[row].nextSetBit(firstOne + 1);
        if (secondOne == -1) {
            return firstOne;
        }
        return -1;
    }

    private void swap(int i, int j, boolean history) {
        if (i != j) {
            if (history) {
                this.history.add(new int[]{1, i, j});
            }
            BitSet temp = this.system[i];
            this.system[i] = this.system[j];
            this.system[j] = temp;
        }
    }

    private void add(int what, int to, boolean history) {
        if (history) {
            this.history.add(new int[]{2, what, to});
        }
        this.system[to].xor(this.system[what]);
    }

    private boolean isRowConsistent(int row) {
        int firstOne = this.system[row].nextSetBit(0);
        if (firstOne == this.certainOnes.length) {
            return false;
        }
        if (firstOne == -1) {
            return true;
        }
        return true;
    }

    @Override
    public boolean needsStrongPropagation() {
        return true;
    }

    public static void main(String[] args) {
    }
}

