/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.logic.subsumption;

import ida.ilp.logic.Clause;
import ida.ilp.logic.Constant;
import ida.ilp.logic.Literal;
import ida.ilp.logic.Term;
import ida.ilp.logic.Variable;
import ida.ilp.logic.subsumption.CustomPredicate;
import ida.ilp.logic.subsumption.GlobalConstraint;
import ida.ilp.logic.subsumption.SolutionConsumer;
import ida.ilp.logic.subsumption.SpecialBinaryPredicates;
import ida.ilp.logic.subsumption.SpecialVarargPredicates;
import ida.utils.Combinatorics;
import ida.utils.IntegerFunction;
import ida.utils.Sugar;
import ida.utils.VectorUtils;
import ida.utils.collections.Counters;
import ida.utils.collections.IntegerMultiMap;
import ida.utils.collections.IntegerSet;
import ida.utils.collections.MultiMap;
import ida.utils.collections.ValueToIndex;
import ida.utils.collections.VectorSet;
import ida.utils.random.CustomRandomGenerator;
import ida.utils.tuples.Pair;
import ida.utils.tuples.Triple;
import ida.utils.tuples.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;

public class SubsumptionEngineJ2 {
    public static int countFC = 0;
    private int lowArity = 3;
    private ValueToIndex<String> predicatesToIntegers = new ValueToIndex();
    private Set<Integer> specialPredicateIds = new HashSet<Integer>();
    private Map<String, CustomPredicate> customPredicates = new HashMap<String, CustomPredicate>();
    private Random random = new Random();
    private boolean learnVariableOrder = true;
    private int exploredNodesInCurrentRestart = 0;
    private int currentCutoff = Integer.MAX_VALUE;
    private int maxRestarts = Integer.MAX_VALUE;
    private int forcedVariable = -1;
    public static final int THETA = 1;
    public static final int OBJECT_IDENTITY = 2;
    private int subsumptionMode = 1;
    private int forwardCheckingFrom = 1;
    private int arcConsistencyFrom = 6;
    private int[] firstVariableOrder;
    private int[] lastVariableOrder;
    private IntegerFunction restartSequence = new IntegerFunction.ConstantFunction(Integer.MAX_VALUE);
    private boolean solvedWithoutSearch = false;
    private int numberOfLastRestart = -1;
    private long timeout = Long.MAX_VALUE;
    protected ValueToIndex<Term> termsToIntegers = new ValueToIndex();
    protected ValueToIndex<String> typesToIntegers = new ValueToIndex();
    private static final int NORMAL_PREDICATE = 1;
    private static final int COMPLETELY_SYMMETRIC_PREDICATE = 2;
    private static final int SPECIAL_PREDICATE = 4;
    private LinkedHashSet<SolutionConsumer> solutionConsumers = new LinkedHashSet();
    private Map<Integer, Number> numbers = new HashMap<Integer, Number>();
    private static final int alldiff = -1;
    private static final int neq = -2;
    private static final int eq = -3;
    private static final int leq = -4;
    private static final int lt = -5;
    private static final int geq = -6;
    private static final int gt = -7;
    private static final int maxcard = -8;
    private static final int in = -9;
    private static final int anypred = -10;
    private static final int truepred = -11;
    private static final int falsepred = -12;

    public SubsumptionEngineJ2() {
        this.predicatesToIntegers.put(-1, "@alldiff");
        this.predicatesToIntegers.put(-2, "@neq");
        this.predicatesToIntegers.put(-3, "@eq");
        this.predicatesToIntegers.put(-4, "@leq");
        this.predicatesToIntegers.put(-5, "@lt");
        this.predicatesToIntegers.put(-6, "@geq");
        this.predicatesToIntegers.put(-7, "@gt");
        this.predicatesToIntegers.put(-8, "@maxcard");
        this.predicatesToIntegers.put(-9, "@in");
        this.predicatesToIntegers.put(-10, "@anypred");
        this.predicatesToIntegers.put(-11, "@true");
        this.predicatesToIntegers.put(-12, "@false");
        for (String specialBinaryPredicate : SpecialBinaryPredicates.SPECIAL_PREDICATES) {
            this.specialPredicateIds.add(this.predicatesToIntegers.valueToIndex(specialBinaryPredicate));
        }
        for (String specialVarargPredicate : SpecialVarargPredicates.SPECIAL_PREDICATES) {
            this.specialPredicateIds.add(this.predicatesToIntegers.valueToIndex(specialVarargPredicate));
        }
    }

    public Pair<Term[], List<Term[]>> allSolutions(Clause c, Clause e) {
        return this.allSolutions(c, e, Integer.MAX_VALUE);
    }

    public Pair<Term[], List<Term[]>> allSolutions(Clause c, Clause e, int maxCount) {
        return this.allSolutions(new ClauseC(c), new ClauseE(e), maxCount);
    }

    public Pair<Term[], List<Term[]>> allSolutions(Clause c, Clause e, int maxCount, int depth) {
        return this.allSolutions(new ClauseC(c), new ClauseE(e), maxCount, depth);
    }

    public Pair<Term[], List<Term[]>> allSolutions(ClauseC c, ClauseE e) {
        return this.allSolutions(c, e, Integer.MAX_VALUE);
    }

    public Pair<Term[], List<Term[]>> allSolutions(ClauseC c, ClauseE e, int maxCount) {
        return this.allSolutions(c, e, maxCount, Integer.MAX_VALUE);
    }

    public Pair<Term[], List<Term[]>> allSolutions(ClauseC c, ClauseE e, int maxCount, int maxDepth) {
        return this.allSolutions_impl(c, e, maxCount, maxDepth, null, -1);
    }

    public Pair<Term[], List<Term[]>> allSolutions(ClauseC c, ClauseE e, int maxCount, int maxDepth, Term firstVariable) {
        return this.allSolutions_impl(c, e, maxCount, maxDepth, null, c.variablesToIntegers.valueToIndex(firstVariable));
    }

    public Pair<Term[], List<Term[]>> allSolutions(ClauseC c, ClauseE e, int maxCount, int maxDepth, Term[] variableOrder) {
        int i;
        int[] intVariableOrder = new int[c.containedIn.length];
        HashSet<Term> used = new HashSet<Term>();
        for (i = 0; i < variableOrder.length; ++i) {
            intVariableOrder[i] = c.variablesToIntegers.valueToIndex(variableOrder[i]);
            used.add(variableOrder[i]);
        }
        for (Term t : c.variablesToIntegers.values()) {
            if (used.contains(t)) continue;
            intVariableOrder[i] = c.variablesToIntegers.valueToIndex(t);
            ++i;
        }
        return this.allSolutions_impl(c, e, maxCount, maxDepth, intVariableOrder, -1);
    }

    private Pair<Term[], List<Term[]>> allSolutions_impl(ClauseC c, ClauseE e, int maxCount, int maxDepth, int[] variableOrder, int firstVariable) {
        if (variableOrder != null && firstVariable != -1) {
            throw new IllegalArgumentException();
        }
        if (!this.initialUnsatCheck(c, e) || !c.initialize(e) || this.arcConsistencyFrom <= 0 && !this.arcConsistencyOnProjection(c, e)) {
            this.solvedWithoutSearch = true;
            Term[] template = new Term[c.containedIn.length];
            for (int i = 0; i < template.length; ++i) {
                template[i] = (Term)c.variablesToIntegers.indexToValue(i);
            }
            return new Pair<Term[], List<Term[]>>(template, new ArrayList(1));
        }
        ArrayList<Term[]> solutions = new ArrayList<Term[]>();
        if (variableOrder == null) {
            variableOrder = this.variableOrder(c, e, firstVariable, false);
        }
        Term[] template = new Term[c.numActualVariables()];
        int j = 0;
        for (int i = 0; i < variableOrder.length; ++i) {
            if (c.isConstant(variableOrder[i])) continue;
            template[j] = (Term)c.variablesToIntegers.indexToValue(variableOrder[i]);
            ++j;
        }
        this.solvedWithoutSearch = false;
        this.solveAll(c, e, 0, 0, variableOrder, new HashSet<Integer>(), template, solutions, maxCount, maxDepth);
        return new Pair<Term[], List<Term[]>>(template, solutions);
    }

    private Boolean solveAll(ClauseC c, ClauseE e, int varIndex, int numActualVarsProcessed, int[] variableOrder, Set<Integer> oiSet, Term[] template, List<Term[]> solutions, int maxCount, int maxDepth) {
        while (varIndex < variableOrder.length && c.isConstant(variableOrder[varIndex])) {
            ++varIndex;
        }
        if (varIndex == variableOrder.length) {
            Term[] solution = new Term[c.numActualVariables()];
            int j = 0;
            for (int i = 0; i < variableOrder.length; ++i) {
                if (c.isConstant(variableOrder[i])) continue;
                solution[j] = this.termsToIntegers.indexToValue(c.groundedValues[variableOrder[i]]);
                ++j;
            }
            solutions.add(solution);
            for (SolutionConsumer consumer : this.solutionConsumers) {
                consumer.solution(template, solution);
            }
            return Boolean.TRUE;
        }
        int[] valueOrder = numActualVarsProcessed >= maxDepth || maxCount < Integer.MAX_VALUE ? this.valueOrder(c, e, variableOrder[varIndex], 1) : c.variableDomains[variableOrder[varIndex]].values();
        block3: for (int i = 0; i < valueOrder.length; ++i) {
            if (solutions.size() >= maxCount) {
                return Boolean.TRUE;
            }
            if (this.subsumptionMode == 2 && !c.isConstant(variableOrder[varIndex]) && oiSet.contains(valueOrder[i])) continue;
            Boolean result = null;
            IntegerSet[] oldDomains = c.oldDomains();
            if (c.groundFC(variableOrder[varIndex], valueOrder[i], e)) {
                if (this.subsumptionMode == 2 && !c.isConstant(variableOrder[varIndex])) {
                    oiSet.add(valueOrder[i]);
                }
                int j = 0;
                for (GlobalConstraint gc : c.globalConstraints) {
                    IntegerSet[] newDomains = gc.propagate(c.variableDomains);
                    if (newDomains == null) {
                        for (int k = 0; k <= j; ++k) {
                            ((GlobalConstraint)c.globalConstraints.get(k)).undoPropagation();
                        }
                        oiSet.remove(valueOrder[i]);
                        c.unground(variableOrder[varIndex]);
                        c.restoreDomains(oldDomains);
                        continue block3;
                    }
                    c.variableDomains = newDomains;
                    ++j;
                }
                result = this.solveAll(c, e, varIndex + 1, numActualVarsProcessed + (c.isConstant(variableOrder[varIndex]) ? 0 : 1), variableOrder, oiSet, template, solutions, maxCount, maxDepth);
                if (this.subsumptionMode == 2 && !c.isConstant(variableOrder[varIndex])) {
                    oiSet.remove(valueOrder[i]);
                }
                for (GlobalConstraint gc : c.globalConstraints) {
                    gc.undoPropagation();
                }
            }
            c.unground(variableOrder[varIndex]);
            c.restoreDomains(oldDomains);
            if (result == null || !result.booleanValue() || numActualVarsProcessed < maxDepth) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean solveWithResumer1(Clause c, Clause e) {
        return this.solveWithResumer(new ClauseC(c), new ClauseE(e), 1);
    }

    public Boolean solveWithResumer2(Clause c, Clause e) {
        return this.solveWithResumer(new ClauseC(c), new ClauseE(e), 2);
    }

    public Boolean solveWithResumer1(ClauseC c, ClauseE e) {
        return this.solveWithResumer(c, e, 1);
    }

    public Boolean solveWithResumer2(ClauseC c, ClauseE e) {
        return this.solveWithResumer(c, e, 2);
    }

    public Boolean solveWithResumer(Clause c, Clause e, int resumerType) {
        return this.solveWithResumer(new ClauseC(c), new ClauseE(e), resumerType);
    }

    public Boolean solveWithResumer(ClauseStructure cs, ClauseE e, int resumerVersion) {
        if (resumerVersion >= 3) {
            throw new UnsupportedOperationException();
        }
        this.numberOfLastRestart = 0;
        if (!this.initialUnsatCheck(cs, e)) {
            this.solvedWithoutSearch = true;
            return Boolean.FALSE;
        }
        ClauseC c = null;
        if (resumerVersion <= 2) {
            c = (ClauseC)cs;
        }
        Boolean success = null;
        IntegerSet[] oldDomains = null;
        int restart = 1;
        boolean ac = false;
        long deadline = Long.MAX_VALUE;
        if (this.timeout != Long.MAX_VALUE) {
            deadline = System.currentTimeMillis() + this.timeout;
        }
        if (!cs.initialize(e)) {
            this.solvedWithoutSearch = true;
            this.numberOfLastRestart = restart;
            return Boolean.FALSE;
        }
        if (c.literals.length == 0) {
            this.solvedWithoutSearch = true;
            return Boolean.TRUE;
        }
        do {
            this.exploredNodesInCurrentRestart = 0;
            this.currentCutoff = this.restartSequence.f(restart) + 2 * c.variableDomains.length;
            int[] variableOrder = resumerVersion > 1 && restart % 2 == 0 && this.forcedVariable != -1 ? this.variableOrder(c, e, this.forcedVariable, this.subsumptionMode == 1) : this.variableOrder(c, e, this.subsumptionMode == 1);
            c.unground();
            if (oldDomains != null) {
                c.restoreDomains(oldDomains);
            }
            if (!ac && restart >= this.getArcConsistencyFrom()) {
                if (!this.arcConsistencyOnProjection(c, e)) {
                    this.numberOfLastRestart = restart;
                    return false;
                }
                ac = true;
                oldDomains = c.oldDomains();
            }
            Term[] template = new Term[variableOrder.length];
            if (!(cs instanceof ClauseC)) continue;
            success = this.solveR(c, e, 0, variableOrder, restart, new HashSet<Integer>(), template, deadline);
        } while (success == null && restart++ < this.maxRestarts && System.currentTimeMillis() < deadline);
        this.solvedWithoutSearch = false;
        if (success == null) {
            this.firstVariableOrder = null;
        }
        this.numberOfLastRestart = restart;
        return success;
    }

    public void setRestartSequence(IntegerFunction f) {
        this.restartSequence = f;
    }

    public IntegerFunction getRestartSequence() {
        return this.restartSequence;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    private boolean initialUnsatCheck(ClauseStructure c, ClauseE e) {
        if (c.contradiction()) {
            return false;
        }
        return c.predicates().isSubsetOf(e.predicates);
    }

    private Boolean solveR(ClauseC c, ClauseE e, int varIndex, int[] variableOrder, int restart, Set<Integer> oiSet, Term[] template, long deadline) {
        while (varIndex < variableOrder.length && c.isConstant(variableOrder[varIndex])) {
            ++varIndex;
        }
        if (varIndex == variableOrder.length) {
            return Boolean.TRUE;
        }
        if (this.exploredNodesInCurrentRestart++ >= this.currentCutoff || this.exploredNodesInCurrentRestart % 100 == 0 && System.currentTimeMillis() >= deadline) {
            return null;
        }
        int[] valueOrder = this.valueOrder(c, e, variableOrder[varIndex], restart);
        for (int i = 0; i < valueOrder.length; ++i) {
            IntegerSet[] oldDomains = c.oldDomains();
            if (this.subsumptionMode == 2 && !c.isConstant(variableOrder[varIndex]) && oiSet.contains(valueOrder[i])) continue;
            if (restart < this.getForwardCheckingFrom() && c.ground(variableOrder[varIndex], valueOrder[i], e) || restart >= this.getForwardCheckingFrom() && c.groundFC(variableOrder[varIndex], valueOrder[i], e)) {
                Boolean success;
                if (this.subsumptionMode == 2 && !c.isConstant(variableOrder[varIndex])) {
                    oiSet.add(valueOrder[i]);
                }
                if ((success = this.solveR(c, e, varIndex + 1, variableOrder, restart, oiSet, template, deadline)) == null) {
                    return null;
                }
                if (success.booleanValue()) {
                    return true;
                }
                if (this.subsumptionMode == 2 && !c.isConstant(variableOrder[varIndex])) {
                    oiSet.remove(valueOrder[i]);
                }
            } else {
                this.forcedVariable = variableOrder[varIndex];
            }
            c.unground(variableOrder[varIndex]);
            c.restoreDomains(oldDomains);
        }
        return Boolean.FALSE;
    }

    private int[] valueOrder(ClauseC c, ClauseE e, int variable, int restart) {
        if (c.groundedValues[variable] == -1) {
            int[] array = null;
            if (restart == 1) {
                array = c.variableDomains[variable].values();
            } else {
                array = VectorUtils.copyArray(c.variableDomains[variable].values());
                VectorUtils.shuffle(array, this.random);
            }
            return array;
        }
        return new int[]{c.groundedValues[variable]};
    }

    private int[] variableOrder(ClauseC c, ClauseE e, boolean ignoreSingletons) {
        return this.variableOrder(c, e, -1, ignoreSingletons);
    }

    private int[] variableOrder(ClauseC c, ClauseE e, int fv, boolean ignoreSingletons) {
        if (c.containedIn.length == 0) {
            return new int[0];
        }
        if (this.learnVariableOrder && this.firstVariableOrder != null) {
            int[] ret = this.firstVariableOrder;
            this.firstVariableOrder = null;
            this.lastVariableOrder = ret;
            return ret;
        }
        Counters<Integer> predicateCounts = new Counters<Integer>();
        for (int i = 0; i < e.literals.length; i += e.literals[i + 1] + 2) {
            predicateCounts.increment(e.literals[i]);
        }
        ArrayList<Integer> variableOrder = new ArrayList<Integer>();
        double[] weights = new double[c.containedIn.length];
        int index = 0;
        for (IntegerSet containedIn : c.containedIn) {
            weights[index] = containedIn.size();
            int n = index;
            weights[n] = weights[n] / (double)c.variableDomains[index].size();
            ++index;
        }
        double[] heuristic1 = new double[c.containedIn.length];
        if (fv == -1) {
            CustomRandomGenerator crg = new CustomRandomGenerator(weights, this.random);
            variableOrder.add(crg.nextInt());
        } else {
            variableOrder.add(fv);
        }
        heuristic1[((Integer)variableOrder.get((int)0)).intValue()] = -1.0;
        for (int ci : c.containedIn[(Integer)variableOrder.get(0)].values()) {
            for (int i = 0; i < c.literals[ci + 1]; ++i) {
                if (heuristic1[c.literals[ci + 3 + i]] == -1.0) continue;
                int n = c.literals[ci + 3 + i];
                heuristic1[n] = heuristic1[n] + 1.0 * weights[c.literals[ci + 3 + i]];
            }
        }
        for (int i = 1; i < heuristic1.length; ++i) {
            int selected = this.maxIndexWithTieBreaking(heuristic1);
            heuristic1[selected] = -1.0;
            if (!ignoreSingletons || c.occurrences[selected] > 1) {
                variableOrder.add(selected);
            }
            for (int ci : c.containedIn[selected].values()) {
                for (int j = 0; j < c.literals[ci + 1]; ++j) {
                    if (heuristic1[c.literals[ci + 3 + j]] == -1.0) continue;
                    double count = predicateCounts.get(c.literals[ci]);
                    if (count == 0.0) {
                        count = 1.0E8;
                    }
                    int n = c.literals[ci + 3 + j];
                    heuristic1[n] = heuristic1[n] + 1.0 * weights[c.literals[ci + 3 + j]] / count;
                }
            }
        }
        this.lastVariableOrder = VectorUtils.toIntegerArray(variableOrder);
        return this.lastVariableOrder;
    }

    public int[] getLastVariableOrder() {
        return this.lastVariableOrder;
    }

    public void setFirstVariableOrder(int[] order) {
        this.firstVariableOrder = order;
    }

    private int maxIndexWithTieBreaking(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        int maxIndex = 0;
        int index = 0;
        int countOfEqualValues = 0;
        int[] equal = new int[values.length];
        for (double value : values) {
            if (value > max) {
                max = value;
                maxIndex = index;
                countOfEqualValues = 0;
            } else if (value == max) {
                if (countOfEqualValues == 0) {
                    equal[countOfEqualValues] = maxIndex;
                    ++countOfEqualValues;
                }
                equal[countOfEqualValues] = index;
                ++countOfEqualValues;
            }
            ++index;
        }
        if (countOfEqualValues > 0) {
            return equal[this.random.nextInt(countOfEqualValues)];
        }
        return maxIndex;
    }

    public void setSubsumptionMode(int subsumptionMode) {
        this.subsumptionMode = subsumptionMode;
    }

    public int subsumptionMode() {
        return this.subsumptionMode;
    }

    public boolean solvedWithoutSearch() {
        return this.solvedWithoutSearch;
    }

    public void setMaxRestarts(int maxRestarts) {
        this.maxRestarts = maxRestarts;
    }

    public void setForwardCheckingFrom(int forwardCheckingFrom) {
        this.forwardCheckingFrom = forwardCheckingFrom;
    }

    private boolean arcConsistencyOnProjection(ClauseC clauseC, ClauseE clauseE) {
        Stack<Triple<Integer, Integer, Integer>> stack = new Stack<Triple<Integer, Integer, Integer>>();
        HashMap<Integer, Set> domains = new HashMap<Integer, Set>();
        HashSet<Triple<Integer, Integer, Integer>> pairs = new HashSet<Triple<Integer, Integer, Integer>>();
        for (int i = 0; i < clauseC.literals.length; i += clauseC.literals[i + 1] + 3) {
            if (clauseC.literals[i + 1] <= 1) continue;
            for (int j = 0; j < clauseC.literals[i + 1]; ++j) {
                for (int k = 0; k < clauseC.literals[i + 1]; ++k) {
                    if (clauseC.literals[i + 3 + j] == clauseC.literals[i + 3 + k]) continue;
                    Triple<Integer, Integer, Integer> p1 = new Triple<Integer, Integer, Integer>(clauseC.literals[i + 3 + j], clauseC.literals[i + 3 + k], i);
                    if (!pairs.contains(p1)) {
                        stack.push(p1);
                        pairs.add(p1);
                    }
                    if (domains.containsKey(clauseC.literals[i + 3 + j])) continue;
                    domains.put(clauseC.literals[i + 3 + j], clauseC.variableDomains[clauseC.literals[i + 3 + j]].toSet());
                }
            }
        }
        while (!stack.isEmpty()) {
            Triple triple = (Triple)stack.pop();
            pairs.remove(triple);
            int oldSize = ((Set)domains.get(triple.r)).size();
            Set filteredDomain = clauseC.revise((Set)domains.get(triple.r), (Integer)triple.r, (Set)domains.get(triple.s), (Integer)triple.s, clauseE, (Integer)triple.t);
            if (filteredDomain.size() >= oldSize) continue;
            if (filteredDomain.isEmpty()) {
                return false;
            }
            for (int neighbour : clauseC.neighbours[(Integer)triple.r].values()) {
                if (neighbour == (Integer)triple.r) continue;
                for (int neighbLit : clauseC.containedIn[neighbour].values()) {
                    Triple<Integer, Integer, Integer> newTriple = new Triple<Integer, Integer, Integer>(neighbour, (Integer)triple.r, neighbLit);
                    if (pairs.contains(newTriple)) continue;
                    stack.push(newTriple);
                    pairs.add(newTriple);
                }
            }
            domains.put((Integer)triple.r, filteredDomain);
        }
        for (Map.Entry entry : domains.entrySet()) {
            clauseC.variableDomains[((Integer)entry.getKey()).intValue()] = IntegerSet.createIntegerSet((Set)entry.getValue());
        }
        return true;
    }

    public int getArcConsistencyFrom() {
        return this.arcConsistencyFrom;
    }

    public void setArcConsistencyFrom(int arcConsistencyFrom) {
        this.arcConsistencyFrom = arcConsistencyFrom;
    }

    public int getForwardCheckingFrom() {
        return this.forwardCheckingFrom;
    }

    public int getNoOfRestarts() {
        return this.numberOfLastRestart - 1;
    }

    private boolean isGround(int[] cliterals, int[] grounding, int index) {
        int i = index + 3;
        int j = 0;
        while (i < index + cliterals[index + 1] + 3) {
            if (grounding[cliterals[i]] == -1) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private boolean matchCustomLiteral(int[] cliterals, int[] grounding, int index) {
        String predicate = this.predicatesToIntegers.indexToValue(cliterals[index]);
        CustomPredicate cs = this.customPredicates.get(predicate);
        if (cs != null) {
            Term[] args = new Term[cliterals[index + 1]];
            int j = 0;
            for (int i = index + 3; i < index + cliterals[index + 1] + 3; ++i) {
                if (grounding[cliterals[i]] != -1) {
                    args[j] = this.termsToIntegers.indexToValue(grounding[cliterals[i]]);
                }
                ++j;
            }
            return cs.isSatisfiable(args);
        }
        return true;
    }

    private boolean matchSpecialLiteral(ClauseC c, int index, ClauseE e) {
        int[] cliterals = c.literals;
        int[] grounding = c.groundedValues;
        int predicate = cliterals[index];
        int arity = cliterals[index + 1];
        switch (predicate) {
            case -1: {
                int i;
                long pc = 0L;
                boolean precheckSucceeded = false;
                for (i = index + 3; i < index + arity + 3; ++i) {
                    if (grounding[cliterals[i]] == -1) continue;
                    int x = grounding[cliterals[i]] + 1;
                    if ((pc & (long)(x = x * x * x)) == (long)x) {
                        precheckSucceeded = true;
                        break;
                    }
                    pc |= (long)x;
                }
                if (precheckSucceeded) {
                    if (arity < 16) {
                        for (i = index + 3; i < index + arity + 3; ++i) {
                            if (grounding[cliterals[i]] == -1) continue;
                            for (int j = i + 1; j < index + arity + 3; ++j) {
                                if (grounding[cliterals[j]] == -1 || grounding[cliterals[i]] != grounding[cliterals[j]]) continue;
                                return false;
                            }
                        }
                    } else {
                        HashSet<Integer> values = new HashSet<Integer>();
                        for (int i2 = index + 3; i2 < index + arity + 3; ++i2) {
                            if (grounding[cliterals[i2]] == -1) continue;
                            if (values.contains(grounding[cliterals[i2]])) {
                                return false;
                            }
                            values.add(grounding[cliterals[i2]]);
                        }
                    }
                }
                return true;
            }
            case -10: {
                int[] cliteral = new int[cliterals[index + 1] + 3];
                System.arraycopy(cliterals, index, cliteral, 0, cliterals[index + 1] + 3);
                int[] i2 = e.predicates.values();
                int n = i2.length;
                for (int i = 0; i < n; ++i) {
                    int predE;
                    cliteral[0] = predE = i2[i];
                    if (!e.checkLiteral(c, 0, false)) continue;
                    return true;
                }
                return false;
            }
            case -11: {
                return true;
            }
            case -12: {
                return false;
            }
            case -9: {
                if (grounding[cliterals[index + 3]] == -1) {
                    return true;
                }
                for (int i = index + 4; i < index + cliterals[index + 1] + 3; ++i) {
                    if (grounding[cliterals[i]] != -1) {
                        if (grounding[cliterals[index + 3]] != grounding[cliterals[i]]) continue;
                        return true;
                    }
                    return true;
                }
                return false;
            }
            case -8: {
                if (grounding[cliterals[index + 3]] == -1) {
                    return true;
                }
                Term firstArg = this.termsToIntegers.indexToValue(grounding[cliterals[index + 3]]);
                if (firstArg instanceof Constant) {
                    Constant constant = (Constant)firstArg;
                    if (!constant.isNumeric()) {
                        return false;
                    }
                    int cardinality = constant.intValue();
                    if (cardinality >= arity - 1) {
                        return true;
                    }
                    int numGround = 0;
                    for (int i = index + 4; i < index + arity + 3; ++i) {
                        if (grounding[cliterals[i]] == -1) continue;
                        ++numGround;
                    }
                    if (numGround > cardinality) {
                        HashSet<Integer> values = new HashSet<Integer>();
                        for (int i = index + 4; i < index + arity + 3; ++i) {
                            if (grounding[cliterals[i]] == -1) continue;
                            values.add(grounding[cliterals[i]]);
                            if (values.size() <= cardinality) continue;
                            return false;
                        }
                    }
                } else {
                    return true;
                }
                return true;
            }
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: {
                if (this.isGround(cliterals, grounding, index)) {
                    Constant c2;
                    Constant c1;
                    Term arg1 = this.termsToIntegers.indexToValue(grounding[cliterals[index + 3]]);
                    Term arg2 = this.termsToIntegers.indexToValue(grounding[cliterals[index + 4]]);
                    String str1 = arg1.toString();
                    String str2 = arg2.toString();
                    if (arg1 instanceof Constant && arg2 instanceof Constant && (c1 = (Constant)arg1).isNumeric() && (c2 = (Constant)arg2).isNumeric()) {
                        switch (predicate) {
                            case -2: {
                                return c1.doubleValue() != c2.doubleValue();
                            }
                            case -3: {
                                return c1.doubleValue() == c2.doubleValue();
                            }
                            case -7: {
                                return c1.doubleValue() > c2.doubleValue();
                            }
                            case -6: {
                                return c1.doubleValue() >= c2.doubleValue();
                            }
                            case -5: {
                                return c1.doubleValue() < c2.doubleValue();
                            }
                            case -4: {
                                return c1.doubleValue() <= c2.doubleValue();
                            }
                        }
                        break;
                    }
                    String comparable1 = str1;
                    String comparable2 = str2;
                    switch (predicate) {
                        case -2: {
                            return grounding[cliterals[index + 3]] != grounding[cliterals[index + 4]];
                        }
                        case -3: {
                            return grounding[cliterals[index + 3]] == grounding[cliterals[index + 4]];
                        }
                        case -7: {
                            return comparable1.compareTo(comparable2) > 0;
                        }
                        case -6: {
                            return comparable1.compareTo(comparable2) >= 0;
                        }
                        case -5: {
                            return comparable1.compareTo(comparable2) < 0;
                        }
                        case -4: {
                            return comparable1.compareTo(comparable2) <= 0;
                        }
                    }
                    break;
                }
                return true;
            }
        }
        return this.matchCustomLiteral(cliterals, grounding, index);
    }

    public ClauseC createCluaseC(Clause c) {
        return new ClauseC(c);
    }

    public ClauseE createClauseE(Clause e) {
        return new ClauseE(e);
    }

    public void setRandomSeed(long seed) {
        this.random = new Random(seed);
    }

    public void setWhatIsLowArity(int lowArity) {
        this.lowArity = lowArity;
    }

    public void addCustomPredicate(CustomPredicate customPredicate) {
        this.customPredicates.put(customPredicate.name(), customPredicate);
        this.specialPredicateIds.add(this.predicatesToIntegers.valueToIndex(customPredicate.name()));
    }

    public void removeCustomPredicate(String name) {
        this.customPredicates.remove(name);
        this.specialPredicateIds.remove(this.predicatesToIntegers.valueToIndex(name));
    }

    public void addSolutionConsumer(SolutionConsumer solutionConsumer) {
        this.solutionConsumers.add(solutionConsumer);
    }

    public void removeSolutionConsumer(SolutionConsumer solutionConsumer) {
        this.solutionConsumers.remove(solutionConsumer);
    }

    protected Term[] lastVariableOrder(ClauseC c) {
        if (this.lastVariableOrder == null) {
            return null;
        }
        ArrayList<Term> varsList = new ArrayList<Term>();
        for (int i = 0; i < this.lastVariableOrder.length; ++i) {
            Term t = (Term)c.variablesToIntegers.indexToValue(this.lastVariableOrder[i]);
            if (!(t instanceof Variable)) continue;
            varsList.add(t);
        }
        Term[] retVal = new Term[varsList.size()];
        varsList.toArray(retVal);
        return retVal;
    }

    private class CompletelySymmetricLiterals {
        private Map<Integer, IntegerMultiMap<Integer>> termsToLiterals = new HashMap<Integer, IntegerMultiMap<Integer>>();

        public CompletelySymmetricLiterals(int[] literals) {
            HashMap ttl = new HashMap();
            for (int index = 0; index < literals.length; index += literals[index + 1] + 2) {
                if (!((String)SubsumptionEngineJ2.this.predicatesToIntegers.indexToValue(literals[index])).startsWith("&")) continue;
                int arity = literals[index + 1];
                MultiMap<Integer, Integer> mm = null;
                mm = (MultiMap<Integer, Integer>)ttl.get(literals[index]);
                if (mm == null) {
                    mm = new MultiMap<Integer, Integer>();
                    ttl.put(literals[index], mm);
                }
                for (int i = 0; i < arity; ++i) {
                    mm.put(literals[index + i + 2], index);
                }
            }
            for (Map.Entry entry : ttl.entrySet()) {
                this.termsToLiterals.put((Integer)entry.getKey(), IntegerMultiMap.createIntegerMultiMap((MultiMap)entry.getValue()));
            }
        }

        public boolean match(ClauseC c, int index, ClauseE e) {
            int[] cliterals = c.literals;
            if ((cliterals[index + 2] & 4) != 0) {
                return SubsumptionEngineJ2.this.matchSpecialLiteral(c, index, e);
            }
            int[] cliteral = new int[cliterals[index + 1] + 2];
            cliteral[0] = cliterals[index];
            cliteral[1] = cliterals[index + 1];
            IntegerSet domain = null;
            int i = index + 3;
            int j = 0;
            while (i < index + cliterals[index + 1] + 3) {
                int predicate = cliteral[0];
                if (c.groundedValues[cliterals[i]] != -1) {
                    int term = c.groundedValues[cliterals[i]];
                    if ((domain = domain == null ? this.termsToLiterals.get(predicate).get(term) : IntegerSet.intersection(domain, this.termsToLiterals.get(predicate).get(term))).isEmpty()) {
                        return false;
                    }
                }
                ++i;
                ++j;
            }
            return domain != null;
        }
    }

    private class LowArityLiterals {
        private VectorSet set = new VectorSet();
        private int maxArity;

        public LowArityLiterals(int[] literals, int maxArity) {
            this.maxArity = maxArity;
            for (int i = 0; i < literals.length; i += literals[i + 1] + 2) {
                this.add(literals, i);
            }
        }

        public void add(int[] literals, int index) {
            int arity = literals[index + 1];
            if (arity <= this.maxArity) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int j = 0; j < arity; ++j) {
                    list.add(j);
                }
                List subsequences = Combinatorics.allSubsequences(list);
                for (Tuple t : subsequences) {
                    int[] literal = new int[arity + 2];
                    Arrays.fill(literal, -this.maxArity - 2);
                    literal[0] = literals[index];
                    literal[1] = literals[index + 1];
                    for (int k = 0; k < t.size(); ++k) {
                        literal[((Integer)t.get((int)k)).intValue() + 2] = literals[index + 2 + (Integer)t.get(k)];
                    }
                    this.set.add(literal);
                }
            }
        }

        public boolean match(ClauseC c, int index, ClauseE e, int[] auxBuffer) {
            int[] cliterals = c.literals;
            if ((cliterals[index + 2] & 4) != 0) {
                return SubsumptionEngineJ2.this.matchSpecialLiteral(c, index, e);
            }
            auxBuffer[0] = cliterals[index];
            auxBuffer[1] = cliterals[index + 1];
            int i = index + 3;
            int j = 0;
            while (i < index + cliterals[index + 1] + 3) {
                auxBuffer[j + 2] = c.groundedValues[cliterals[i]] == -1 ? -this.maxArity - 2 : c.groundedValues[cliterals[i]];
                ++i;
                ++j;
            }
            return this.set.contains(auxBuffer);
        }
    }

    private class HighArityLiterals {
        private Map<Triple<Integer, Integer, Integer>, Integer> lower;
        private Map<Triple<Integer, Integer, Integer>, Integer> upper;
        private int[] literals;
        private int maxArity;

        public HighArityLiterals(int[] lits, int maxArity) {
            int j;
            int i;
            this.maxArity = maxArity;
            ArrayList<Integer> tempLiterals = new ArrayList<Integer>();
            MultiMap<Triple<Integer, Integer, Integer>, Integer> bag = new MultiMap<Triple<Integer, Integer, Integer>, Integer>();
            for (i = 0; i < lits.length; i += lits[i + 1] + 2) {
                if (lits[i + 1] <= this.maxArity) continue;
                for (j = 0; j < lits[i + 1] + 2; ++j) {
                    tempLiterals.add(lits[i + j]);
                }
            }
            this.literals = VectorUtils.toIntegerArray(tempLiterals);
            for (i = 0; i < this.literals.length; i += this.literals[i + 1] + 2) {
                for (j = 0; j < this.literals[i + 1]; ++j) {
                    bag.put(new Triple<Integer, Integer, Integer>(this.literals[i], j, this.literals[i + 2 + j]), i);
                }
            }
            this.lower = new HashMap<Triple<Integer, Integer, Integer>, Integer>();
            this.upper = new HashMap<Triple<Integer, Integer, Integer>, Integer>();
            for (Map.Entry entry : bag.entrySet()) {
                this.lower.put((Triple<Integer, Integer, Integer>)entry.getKey(), (Integer)Sugar.findBest(entry.getValue(), new Sugar.MyComparator<Integer>(){

                    @Override
                    public boolean isABetterThanB(Integer a, Integer b) {
                        return a < b;
                    }
                }));
                this.upper.put((Triple<Integer, Integer, Integer>)entry.getKey(), (Integer)Sugar.findBest(entry.getValue(), new Sugar.MyComparator<Integer>(){

                    @Override
                    public boolean isABetterThanB(Integer a, Integer b) {
                        return a >= b;
                    }
                }));
            }
        }

        public boolean match(ClauseC c, int index, ClauseE e) {
            int[] cliterals = c.literals;
            if ((cliterals[index + 2] & 4) != 0) {
                return SubsumptionEngineJ2.this.matchSpecialLiteral(c, index, e);
            }
            int lowerBound = 0;
            int upperBound = this.literals.length;
            int predicate = cliterals[index];
            int[] cliteral = new int[cliterals[index + 1] + 2];
            cliteral[0] = cliterals[index];
            cliteral[1] = cliterals[index + 1];
            Triple<Integer, Integer, Integer> t = new Triple<Integer, Integer, Integer>(predicate, 0, 0);
            int i = index + 3;
            int j = 0;
            while (i < index + cliterals[index + 1] + 3) {
                if (c.groundedValues[cliterals[i]] == -1) {
                    cliteral[j + 2] = -this.maxArity - 2;
                } else {
                    Integer fromUpper;
                    cliteral[j + 2] = c.groundedValues[cliterals[i]];
                    t.s = j;
                    t.t = c.groundedValues[cliterals[i]];
                    Integer fromLower = this.lower.get(t);
                    if (fromLower == null || (fromUpper = this.upper.get(t)) == null) {
                        return false;
                    }
                    lowerBound = Math.max(lowerBound, fromLower);
                    upperBound = Math.min(upperBound, fromUpper);
                }
                ++i;
                ++j;
            }
            int iters = 0;
            block1: for (int i2 = lowerBound; i2 <= upperBound; i2 += this.literals[i2 + 1] + 2) {
                ++iters;
                for (int j2 = 0; j2 < cliteral.length; ++j2) {
                    if (cliteral[j2] > -1 && this.literals[i2 + j2] != cliteral[j2]) continue block1;
                }
                return true;
            }
            return false;
        }
    }

    public class ClauseE {
        protected Map<Pair<Integer, Integer>, IntegerSet> variableDomains = new HashMap<Pair<Integer, Integer>, IntegerSet>();
        private IntegerMultiMap<Integer> typedTerms = new IntegerMultiMap();
        protected int[] literals;
        private IntegerSet allTerms;
        private IntegerSet predicates;
        protected IntegerSet[] domainsByPredicates;
        private LowArityLiterals lal;
        private HighArityLiterals hal;
        private CompletelySymmetricLiterals csl;
        private Map<Term, Integer> numbers = new HashMap<Term, Integer>();

        public ClauseE(Clause clause) {
            MultiMap<Integer, Integer> integerMultiMap = new MultiMap<Integer, Integer>();
            HashSet<Integer> predicates = new HashSet<Integer>();
            int literalIndex = 0;
            for (Literal literal : clause.literals()) {
                if (literal.isNegated()) continue;
                integerMultiMap.put(SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(literal.predicateName()), literalIndex);
                literalIndex += 2 + literal.arity();
                predicates.add(SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(literal.predicateName()));
            }
            this.predicates = IntegerSet.createIntegerSet(predicates);
            this.domainsByPredicates = new IntegerSet[SubsumptionEngineJ2.this.predicatesToIntegers.max() + 1];
            for (Map.Entry entry : integerMultiMap.entrySet()) {
                if ((Integer)entry.getKey() < 0) continue;
                this.domainsByPredicates[((Integer)entry.getKey()).intValue()] = IntegerSet.createIntegerSet((Set)entry.getValue());
            }
            this.literals = new int[literalIndex];
            HashMap<Literal, Integer> intLitMap = new HashMap<Literal, Integer>();
            HashMap<Integer, Literal> hashMap = new HashMap<Integer, Literal>();
            int index = 0;
            MultiMap<Pair<Integer, Integer>, Integer> varDomains = new MultiMap<Pair<Integer, Integer>, Integer>();
            for (Literal literal : clause.literals()) {
                if (literal.isNegated()) continue;
                this.literals[index] = SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(literal.predicateName());
                this.literals[index + 1] = literal.arity();
                intLitMap.put(literal, index);
                hashMap.put(index, literal);
                index += 2;
                if (literal.predicateName().startsWith("&")) {
                    for (int i = 0; i < literal.arity(); ++i) {
                        for (int j = 0; j < literal.arity(); ++j) {
                            this.literals[index + j] = SubsumptionEngineJ2.this.termsToIntegers.valueToIndex(literal.get(j));
                            varDomains.put(new Pair<Integer, Integer>(this.literals[index - 2], i), this.literals[index + j]);
                        }
                    }
                } else {
                    for (int j = 0; j < literal.arity(); ++j) {
                        this.literals[index + j] = SubsumptionEngineJ2.this.termsToIntegers.valueToIndex(literal.get(j));
                        varDomains.put(new Pair<Integer, Integer>(this.literals[index - 2], j), this.literals[index + j]);
                    }
                }
                index += literal.arity();
            }
            for (Map.Entry entry : varDomains.entrySet()) {
                this.variableDomains.put((Pair<Integer, Integer>)entry.getKey(), IntegerSet.createIntegerSet((Set)entry.getValue()));
            }
            this.lal = new LowArityLiterals(this.literals, SubsumptionEngineJ2.this.lowArity);
            this.hal = new HighArityLiterals(this.literals, SubsumptionEngineJ2.this.lowArity);
            this.csl = new CompletelySymmetricLiterals(this.literals);
            HashSet<Integer> allTermsHere = new HashSet<Integer>();
            MultiMap<Integer, Integer> multiMap = new MultiMap<Integer, Integer>();
            for (Term t : clause.terms()) {
                allTermsHere.add(SubsumptionEngineJ2.this.termsToIntegers.valueToIndex(t));
                if (t.type() == null) continue;
                multiMap.put(SubsumptionEngineJ2.this.typesToIntegers.valueToIndex(t.type()), SubsumptionEngineJ2.this.termsToIntegers.valueToIndex(t));
            }
            this.allTerms = IntegerSet.createIntegerSet(allTermsHere);
            this.typedTerms = IntegerMultiMap.createIntegerMultiMap(multiMap);
        }

        public IntegerSet typedTerms(int type) {
            return this.typedTerms.get(type);
        }

        public boolean checkLiteral(ClauseC c, int index, boolean negated) {
            int[] cliterals = c.literals;
            if (negated) {
                if (SubsumptionEngineJ2.this.isGround(cliterals, c.groundedValues, index)) {
                    if ((cliterals[index + 2] & 2) > 0) {
                        return !this.csl.match(c, index, this);
                    }
                    if (cliterals[index + 1] <= SubsumptionEngineJ2.this.lowArity) {
                        return !this.lal.match(c, index, this, c.lowArityAuxBuffers[cliterals[index + 1]]);
                    }
                    return !this.hal.match(c, index, this);
                }
                return true;
            }
            if ((cliterals[index + 2] & 2) > 0) {
                return this.csl.match(c, index, this);
            }
            if (cliterals[index + 1] <= SubsumptionEngineJ2.this.lowArity) {
                return this.lal.match(c, index, this, c.lowArityAuxBuffers[cliterals[index + 1]]);
            }
            return this.hal.match(c, index, this);
        }

        public String literalToString(int literal) {
            StringBuilder sb = new StringBuilder();
            sb.append((String)SubsumptionEngineJ2.this.predicatesToIntegers.indexToValue(this.literals[literal]));
            sb.append("(");
            for (int i = 0; i < this.literals[literal + 1]; ++i) {
                sb.append(SubsumptionEngineJ2.this.termsToIntegers.indexToValue(this.literals[literal + 2 + i]));
                if (i >= this.literals[literal + 1] - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }

        public Set<Term> terms() {
            HashSet<Term> retVal = new HashSet<Term>();
            for (int termID : this.allTerms.values()) {
                retVal.add(SubsumptionEngineJ2.this.termsToIntegers.indexToValue(termID));
            }
            return retVal;
        }

        public IntegerSet allTerms() {
            return this.allTerms;
        }
    }

    public class ClauseC
    implements ClauseStructure {
        private boolean contradiction = false;
        protected int[] literals;
        private IntegerSet predicates;
        protected int[] variableTypes;
        protected IntegerSet[] variableDomains;
        protected int[] groundedValues;
        private int[] occurrences;
        private IntegerSet negations;
        private IntegerSet[] containedIn;
        private IntegerSet[] neighbours;
        private boolean[] constantsMask;
        private int numActualVariables;
        private int numActualConstants;
        private ValueToIndex<Term> variablesToIntegers = new ValueToIndex();
        private int[] auxBuffer1;
        private int[][] lowArityAuxBuffers;
        private boolean useFirstSuccessFC = true;
        private ArrayList<GlobalConstraint> globalConstraints = new ArrayList();

        protected ClauseC() {
        }

        /*
         * WARNING - void declaration
         */
        public ClauseC(Clause c) {
            void var10_20;
            void var10_17;
            void var10_15;
            HashSet<Integer> predicateSet = new HashSet<Integer>();
            int literalsArrayLength = 0;
            for (Literal l : c.literals()) {
                literalsArrayLength += 3 + l.arity();
                int predicate = SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(l.predicateName());
                if (l.isNegated() || SubsumptionEngineJ2.this.specialPredicateIds.contains(predicate)) continue;
                predicateSet.add(predicate);
            }
            HashSet<Integer> negations = new HashSet<Integer>();
            this.predicates = IntegerSet.createIntegerSet(predicateSet);
            this.literals = new int[literalsArrayLength];
            HashMap<Literal, Integer> intLitMap = new HashMap<Literal, Integer>();
            HashMap<Integer, Literal> litIntMap = new HashMap<Integer, Literal>();
            int index = 0;
            for (Literal literal : c.literals()) {
                if (literal.isNegated()) {
                    negations.add(index);
                }
                this.literals[index] = SubsumptionEngineJ2.this.predicatesToIntegers.valueToIndex(literal.predicateName());
                this.literals[index + 1] = literal.arity();
                if (literal.predicateName().startsWith("&")) {
                    int n = index + 2;
                    this.literals[n] = this.literals[n] | 2;
                }
                if (SubsumptionEngineJ2.this.specialPredicateIds.contains(this.literals[index])) {
                    int n = index + 2;
                    this.literals[n] = this.literals[n] | 4;
                    if (this.literals[index] == -12 && !literal.isNegated()) {
                        this.contradiction = true;
                    } else if (this.literals[index] == -11 && literal.isNegated()) {
                        this.contradiction = true;
                    }
                }
                intLitMap.put(literal, index);
                litIntMap.put(index, literal);
                index += 3;
                for (int j = 0; j < literal.arity(); ++j) {
                    this.literals[index + j] = this.variablesToIntegers.valueToIndex(literal.get(j));
                }
                index += literal.arity();
            }
            this.negations = IntegerSet.createIntegerSet(negations);
            this.containedIn = new IntegerSet[this.variablesToIntegers.size()];
            this.occurrences = new int[this.variablesToIntegers.size()];
            MultiMap containedInBag = new MultiMap();
            for (Literal l : c.literals()) {
                for (int i2 = 0; i2 < l.arity(); ++i2) {
                    containedInBag.put(this.variablesToIntegers.valueToIndex(l.get(i2)), intLitMap.get(l));
                    int n = this.variablesToIntegers.valueToIndex(l.get(i2));
                    this.occurrences[n] = this.occurrences[n] + 1;
                }
            }
            for (Map.Entry entry : containedInBag.entrySet()) {
                int term = (Integer)entry.getKey();
                this.containedIn[term] = IntegerSet.createIntegerSet(entry.getValue());
            }
            this.neighbours = new IntegerSet[this.containedIn.length];
            boolean bl = false;
            while (var10_15 < this.containedIn.length) {
                HashSet<Integer> set = new HashSet<Integer>();
                for (int literalsIndex : this.containedIn[var10_15].values()) {
                    for (int j = literalsIndex + 3; j < literalsIndex + 3 + this.literals[literalsIndex + 1]; ++j) {
                        if (this.literals[j] == var10_15) continue;
                        set.add(this.literals[j]);
                    }
                }
                this.neighbours[var10_15] = IntegerSet.createIntegerSet(set);
                ++var10_15;
            }
            this.variableDomains = new IntegerSet[c.terms().size()];
            this.groundedValues = new int[c.terms().size()];
            this.constantsMask = new boolean[c.terms().size()];
            Arrays.fill(this.groundedValues, -1);
            boolean bl2 = false;
            while (var10_17 < this.groundedValues.length) {
                if (this.variablesToIntegers.indexToValue((int)var10_17) instanceof Constant) {
                    this.groundedValues[var10_17] = SubsumptionEngineJ2.this.termsToIntegers.valueToIndex(this.variablesToIntegers.indexToValue((int)var10_17));
                    this.constantsMask[var10_17] = true;
                    ++this.numActualConstants;
                } else {
                    ++this.numActualVariables;
                }
                ++var10_17;
            }
            this.variableTypes = new int[this.variablesToIntegers.size()];
            for (Term t : this.variablesToIntegers.values()) {
                if (t.type() != null && t instanceof Variable) {
                    this.variableTypes[this.variablesToIntegers.valueToIndex((Term)t)] = SubsumptionEngineJ2.this.typesToIntegers.valueToIndex(t.type());
                    continue;
                }
                this.variableTypes[this.variablesToIntegers.valueToIndex((Term)t)] = -1;
            }
            this.auxBuffer1 = new int[this.variableDomains.length];
            this.lowArityAuxBuffers = new int[SubsumptionEngineJ2.this.lowArity + 1][];
            boolean bl3 = false;
            while (var10_20 <= SubsumptionEngineJ2.this.lowArity) {
                this.lowArityAuxBuffers[var10_20] = new int[var10_20 + 2];
                ++var10_20;
            }
        }

        @Override
        public boolean initialize(ClauseE e) {
            int i;
            Arrays.fill(this.variableDomains, null);
            for (int k = 0; k < this.literals.length; k += this.literals[k + 1] + 3) {
                if (!((String)SubsumptionEngineJ2.this.predicatesToIntegers.indexToValue(this.literals[k])).equals("@in")) continue;
                boolean groundRightPart = true;
                int arity = this.literals[k + 1];
                for (int j = 1; j < arity; ++j) {
                    if (this.isConstant(this.literals[k + j + 3])) continue;
                    groundRightPart = false;
                    break;
                }
                if (!groundRightPart) continue;
                int varIndex = this.literals[k + 3];
                int[] groundValues = new int[arity - 1];
                for (int j = 0; j < groundValues.length; ++j) {
                    groundValues[j] = SubsumptionEngineJ2.this.termsToIntegers.valueToIndex(this.variablesToIntegers.indexToValue(this.literals[k + j + 3 + 1]));
                }
                IntegerSet dom = IntegerSet.createIntegerSet(groundValues);
                if (this.negations.contains(k)) {
                    dom = IntegerSet.difference(e.allTerms, dom);
                }
                this.variableDomains[varIndex] = this.variableDomains[varIndex] == null ? dom : IntegerSet.intersection(this.variableDomains[varIndex], dom);
            }
            for (i = 0; i < this.variableDomains.length; ++i) {
                if (this.variablesToIntegers.indexToValue(i) instanceof Variable) {
                    for (int ciLit : this.containedIn[i].values()) {
                        for (int j = 0; j < this.literals[ciLit + 1]; ++j) {
                            if (this.literals[ciLit + j + 3] != i) continue;
                            if (this.variableDomains[i] == null) {
                                if (this.negations.contains(ciLit) || SubsumptionEngineJ2.this.specialPredicateIds.contains(this.literals[ciLit])) {
                                    if (this.variableTypes[i] == -1) {
                                        this.variableDomains[i] = e.allTerms;
                                        continue;
                                    }
                                    this.variableDomains[i] = e.typedTerms(this.variableTypes[i]);
                                    continue;
                                }
                                if (this.variableTypes[i] == -1) {
                                    this.variableDomains[i] = e.variableDomains.get(new Pair<Integer, Integer>(this.literals[ciLit], j));
                                    continue;
                                }
                                this.variableDomains[i] = IntegerSet.intersection(e.variableDomains.get(new Pair<Integer, Integer>(this.literals[ciLit], j)), e.typedTerms(this.variableTypes[i]));
                                continue;
                            }
                            if (this.negations.contains(ciLit) || SubsumptionEngineJ2.this.specialPredicateIds.contains(this.literals[ciLit])) continue;
                            IntegerSet varDomain = e.variableDomains.get(new Pair<Integer, Integer>(this.literals[ciLit], j));
                            if (varDomain != null) {
                                this.variableDomains[i] = IntegerSet.intersection(varDomain, this.variableDomains[i]);
                                continue;
                            }
                            return false;
                        }
                    }
                } else {
                    int termId = SubsumptionEngineJ2.this.termsToIntegers.valueToIndex(this.variablesToIntegers.indexToValue(i));
                    this.variableDomains[i] = IntegerSet.createIntegerSet(termId);
                    if (this.variableTypes[i] != -1 && !e.typedTerms(this.variableTypes[i]).contains(termId)) {
                        this.variableDomains[i] = IntegerSet.emptySet;
                    }
                }
                if (this.variableDomains[i] != null && !this.variableDomains[i].isEmpty()) continue;
                return false;
            }
            Arrays.fill(this.groundedValues, -1);
            for (i = 0; i < this.groundedValues.length; ++i) {
                if (!(this.variablesToIntegers.indexToValue(i) instanceof Constant) || this.ground(i, SubsumptionEngineJ2.this.termsToIntegers.valueToIndex(this.variablesToIntegers.indexToValue(i)), e)) continue;
                return false;
            }
            return true;
        }

        public void addGlobalConstraint(GlobalConstraint gc) {
            if (gc.needsStrongPropagation()) {
                this.useFirstSuccessFC = false;
            }
            this.globalConstraints.add(gc);
        }

        public void removeGlobalConstraints() {
            this.globalConstraints.clear();
        }

        protected boolean ground(int variable, int value, ClauseE e) {
            this.groundedValues[variable] = value;
            if (!this.useFirstSuccessFC) {
                this.variableDomains[variable] = IntegerSet.createIntegerSet(value);
            }
            for (int ciLit : this.containedIn[variable].values()) {
                if (e.checkLiteral(this, ciLit, this.negations.contains(ciLit))) continue;
                return false;
            }
            return true;
        }

        private boolean groundFC(int variable, int value, ClauseE e) {
            ++countFC;
            if (!this.ground(variable, value, e)) {
                return false;
            }
            if (this.useFirstSuccessFC) {
                Arrays.fill(this.auxBuffer1, 0);
                block0: for (int neighb : this.neighbours[variable].values()) {
                    if (this.groundedValues[neighb] != -1 || this.containedIn[neighb].size() <= 1) continue;
                    for (int val : this.variableDomains[neighb].values()) {
                        boolean succ = this.ground(neighb, val, e);
                        this.unground(neighb);
                        if (succ) continue block0;
                        int n = neighb;
                        this.auxBuffer1[n] = this.auxBuffer1[n] + 1;
                    }
                    return false;
                }
                for (int neighb : this.neighbours[variable].values()) {
                    if (this.auxBuffer1[neighb] <= 0) continue;
                    this.variableDomains[neighb] = IntegerSet.createIntegerSetFromSortedArray(Arrays.copyOfRange(this.variableDomains[neighb].values(), this.auxBuffer1[neighb], this.variableDomains[neighb].size()));
                }
                return true;
            }
            for (int neighb : this.neighbours[variable].values()) {
                if (this.groundedValues[neighb] != -1 || this.containedIn[neighb].size() <= 1) continue;
                int[] domain = new int[this.variableDomains[neighb].size()];
                int index = 0;
                for (int val : this.variableDomains[neighb].values()) {
                    boolean succ = this.ground(neighb, val, e);
                    this.unground(neighb);
                    if (!succ) continue;
                    domain[index] = val;
                    ++index;
                }
                this.variableDomains[neighb] = IntegerSet.createIntegerSetFromSortedArray(Arrays.copyOfRange(domain, 0, index));
                if (!this.variableDomains[neighb].isEmpty()) continue;
                return false;
            }
            return true;
        }

        private Set<Integer> revise(Set<Integer> domain1, int var1, Set<Integer> domain2, int var2, ClauseE e, int literal) {
            LinkedHashSet<Integer> filtered = new LinkedHashSet<Integer>();
            if (this.groundedValues[var1] == -1 && this.groundedValues[var2] == -1) {
                for (Integer d1 : domain1) {
                    this.groundedValues[var1] = d1;
                    for (Integer d2 : domain2) {
                        this.groundedValues[var2] = d2;
                        if (e.checkLiteral(this, literal, this.negations.contains(literal))) {
                            filtered.add(d1);
                            this.unground(var2);
                            break;
                        }
                        this.unground(var2);
                    }
                    this.unground(var1);
                }
            } else if (this.groundedValues[var1] > -1) {
                filtered.add(this.groundedValues[var1]);
            } else if (this.groundedValues[var1] == -1 && this.groundedValues[var2] > -1) {
                for (Integer d1 : domain1) {
                    this.groundedValues[var1] = d1;
                    if (e.checkLiteral(this, literal, this.negations.contains(literal))) {
                        filtered.add(d1);
                    }
                    this.unground(var1);
                }
            } else {
                return domain1;
            }
            return filtered;
        }

        protected void restoreDomains(IntegerSet[] oldDomains) {
            this.variableDomains = oldDomains;
        }

        protected IntegerSet[] oldDomains() {
            IntegerSet[] oldDoms = new IntegerSet[this.variableDomains.length];
            System.arraycopy(this.variableDomains, 0, oldDoms, 0, oldDoms.length);
            return oldDoms;
        }

        protected void unground() {
            for (int i = 0; i < this.groundedValues.length; ++i) {
                this.unground(i);
            }
        }

        protected void unground(int variable) {
            if (this.variablesToIntegers.indexToValue(variable) instanceof Variable) {
                this.groundedValues[variable] = -1;
            }
        }

        public String toString() {
            return this.toClause().toString();
        }

        public Clause toOriginalClause() {
            ArrayList<Literal> lits = new ArrayList<Literal>();
            for (int i = 0; i < this.literals.length; i += this.literals[i + 1] + 3) {
                Literal l = new Literal((String)SubsumptionEngineJ2.this.predicatesToIntegers.indexToValue(this.literals[i]), this.negations.contains(i), this.literals[i + 1]);
                for (int j = 0; j < this.literals[i + 1]; ++j) {
                    l.set(this.variablesToIntegers.indexToValue(this.literals[i + 3 + j]), j);
                }
                lits.add(l);
            }
            return new Clause(lits);
        }

        public Clause toClause() {
            ArrayList<Literal> lits = new ArrayList<Literal>();
            for (int i = 0; i < this.literals.length; i += this.literals[i + 1] + 3) {
                Literal l = new Literal((String)SubsumptionEngineJ2.this.predicatesToIntegers.indexToValue(this.literals[i]), this.negations.contains(i), this.literals[i + 1]);
                for (int j = 0; j < this.literals[i + 1]; ++j) {
                    if (this.groundedValues[this.literals[i + 3 + j]] != -1) {
                        l.set((Term)Constant.construct(String.valueOf(this.groundedValues[this.literals[i + 3 + j]])), j);
                        continue;
                    }
                    l.set(this.variablesToIntegers.indexToValue(this.literals[i + 3 + j]), j);
                }
                lits.add(l);
            }
            return new Clause(lits);
        }

        @Override
        public IntegerSet predicates() {
            return this.predicates;
        }

        public Pair<Term[], Term[]> getVariableAssignment(ClauseE example) {
            Term[] template = new Term[this.groundedValues.length];
            Term[] assignment = new Term[this.groundedValues.length];
            for (int i = 0; i < template.length; ++i) {
                template[i] = this.variablesToIntegers.indexToValue(i);
                assignment[i] = SubsumptionEngineJ2.this.termsToIntegers.indexToValue(this.groundedValues[i]);
            }
            return new Pair<Term[], Term[]>(template, assignment);
        }

        public boolean isConstant(int index) {
            return this.constantsMask[index];
        }

        public int numActualVariables() {
            return this.numActualVariables;
        }

        public int numActualConstants() {
            return this.numActualConstants;
        }

        @Override
        public boolean contradiction() {
            return this.contradiction;
        }
    }

    public static interface ClauseStructure {
        public boolean initialize(ClauseE var1);

        public IntegerSet predicates();

        public boolean contradiction();
    }
}

