/*
 * Decompiled with CFR 0.152.
 */
package ida.utils;

import ida.utils.DoubleFunction;
import ida.utils.MatrixUtils;
import ida.utils.Sugar;
import ida.utils.VectorUtils;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class Statistics {
    public static double[] mean(double[][] data) {
        int i;
        double[] mean = new double[data[0].length];
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < mean.length; ++j) {
                int n = j;
                mean[n] = mean[n] + data[i][j];
            }
        }
        i = 0;
        while (i < mean.length) {
            int n = i++;
            mean[n] = mean[n] / (double)data.length;
        }
        return mean;
    }

    public static double[] mean(double[][] data, double[] weights) {
        int i;
        double weightSum = VectorUtils.sum(weights);
        double[] mean = new double[data[0].length];
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < mean.length; ++j) {
                int n = j;
                mean[n] = mean[n] + weights[i] * data[i][j];
            }
        }
        i = 0;
        while (i < mean.length) {
            int n = i++;
            mean[n] = mean[n] / weightSum;
        }
        return mean;
    }

    public static double[][] covariance(double[][] data, double[] weights) {
        double weightSum = VectorUtils.sum(weights);
        double[] mean = Statistics.mean(data, weights);
        double[][] cov = new double[data[0].length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                for (int k = 0; k < data[0].length; ++k) {
                    double[] dArray = cov[j];
                    int n = k;
                    dArray[n] = dArray[n] + weights[i] * (data[i][j] - mean[j]) * (data[i][k] - mean[k]);
                }
            }
        }
        MatrixUtils.multiply(cov, 1.0 / weightSum);
        return cov;
    }

    public static double[][] covariance(double[][] data) {
        double[] mean = Statistics.mean(data);
        double[][] cov = new double[data[0].length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                for (int k = 0; k < data[0].length; ++k) {
                    double[] dArray = cov[j];
                    int n = k;
                    dArray[n] = dArray[n] + (data[i][j] - mean[j]) * (data[i][k] - mean[k]);
                }
            }
        }
        if (data.length > 1) {
            MatrixUtils.multiply(cov, 1.0 / (double)(data.length - 1));
        } else {
            MatrixUtils.multiply(cov, 1.0 / (double)data.length);
        }
        return cov;
    }

    public static double[][] correlation(double[][] data) {
        return Statistics.correlation(data, null);
    }

    public static double[][] correlation(double[][] data, double[] weights) {
        double[][] covariance = weights == null ? Statistics.covariance(data) : Statistics.covariance(data, weights);
        double[][] retVal = new double[covariance.length][covariance.length];
        for (int i = 0; i < covariance.length; ++i) {
            for (int j = 0; j < covariance.length; ++j) {
                retVal[i][j] = i == j ? 1.0 : (covariance[i][i] == 0.0 || covariance[j][j] == 0.0 ? 0.0 : covariance[i][j] / Math.sqrt(covariance[i][i] * covariance[j][j]));
            }
        }
        return retVal;
    }

    public static double[][] covariance_SchafferStrimmer(double[][] data) {
        double[][] standardizedData = Statistics.standardizeDataMatrix(data);
        double[][] correlation = Statistics.correlation(data);
        double[] variance = Statistics.variance(data);
        double n = data.length;
        double[][] varHatCorr = new double[correlation.length][correlation.length];
        int k = 0;
        while ((double)k < n) {
            for (int i = 0; i < correlation.length; ++i) {
                for (int j = 0; j < correlation.length; ++j) {
                    double[] dArray = varHatCorr[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + Sugar.square(standardizedData[k][i] * standardizedData[k][j] - (n - 1.0) / n * correlation[i][j]);
                }
            }
            ++k;
        }
        for (int i = 0; i < correlation.length; ++i) {
            int j = 0;
            while (j < correlation.length) {
                double[] dArray = varHatCorr[i];
                int n3 = j++;
                dArray[n3] = dArray[n3] * (n / ((n - 1.0) * (n - 1.0) * (n - 1.0)));
            }
        }
        double num = 0.0;
        double denom = 0.0;
        for (int i = 0; i < correlation.length; ++i) {
            for (int j = 0; j < correlation.length; ++j) {
                if (i == j) continue;
                num += varHatCorr[i][j];
                denom += Sugar.square(correlation[i][j]);
            }
        }
        double lambda = num / denom;
        double[][] retVal = new double[correlation.length][correlation.length];
        for (int i = 0; i < correlation.length; ++i) {
            for (int j = 0; j < correlation.length; ++j) {
                retVal[i][j] = i == j ? variance[i] : correlation[i][j] * Math.min(1.0, Math.max(0.0, 1.0 - lambda)) * Math.sqrt(variance[i] * variance[j]);
            }
        }
        return retVal;
    }

    public static double[][] covariance_SchafferStrimmer(double[][] data, double[] weights) {
        double[][] standardizedData = Statistics.standardizeDataMatrix(data, weights);
        double[][] correlation = Statistics.correlation(data, weights);
        double[] variance = Statistics.variance(data, weights);
        double sum = VectorUtils.sum(weights);
        double[][] varHatCorr = new double[correlation.length][correlation.length];
        for (int k = 0; k < data.length; ++k) {
            for (int i = 0; i < correlation.length; ++i) {
                for (int j = 0; j < correlation.length; ++j) {
                    double[] dArray = varHatCorr[i];
                    int n = j;
                    dArray[n] = dArray[n] + weights[k] * Sugar.square(standardizedData[k][i] * standardizedData[k][j] - correlation[i][j]);
                }
            }
        }
        for (int i = 0; i < correlation.length; ++i) {
            int j = 0;
            while (j < correlation.length) {
                double[] dArray = varHatCorr[i];
                int n = j++;
                dArray[n] = dArray[n] * (1.0 / (sum * sum));
            }
        }
        double num = 0.0;
        double denom = 0.0;
        for (int i = 0; i < correlation.length; ++i) {
            for (int j = 0; j < correlation.length; ++j) {
                if (i == j) continue;
                num += varHatCorr[i][j];
                denom += Sugar.square(correlation[i][j]);
            }
        }
        double lambda = num / denom;
        double[][] retVal = new double[correlation.length][correlation.length];
        for (int i = 0; i < correlation.length; ++i) {
            for (int j = 0; j < correlation.length; ++j) {
                retVal[i][j] = i == j ? variance[i] : correlation[i][j] * Math.min(1.0, Math.max(0.0, 1.0 - lambda)) * Math.sqrt(variance[i] * variance[j]);
            }
        }
        return retVal;
    }

    public static double[] variance(double[][] data) {
        double[] mean = Statistics.mean(data);
        double[] var = new double[data[0].length];
        for (double[] sample : data) {
            for (int j = 0; j < sample.length; ++j) {
                int n = j;
                var[n] = var[n] + (sample[j] - mean[j]) * (sample[j] - mean[j]);
            }
        }
        int i = 0;
        while (i < var.length) {
            int n = i++;
            var[n] = var[n] / (double)(data.length - 1);
        }
        return var;
    }

    public static double[] variance(double[][] data, double[] weights) {
        double[] mean = Statistics.mean(data, weights);
        double[] var = new double[data[0].length];
        double sum = VectorUtils.sum(weights);
        int exampleIndex = 0;
        for (double[] sample : data) {
            for (int j = 0; j < sample.length; ++j) {
                int n = j;
                var[n] = var[n] + weights[exampleIndex] * (sample[j] - mean[j]) * (sample[j] - mean[j]);
            }
            ++exampleIndex;
        }
        int i = 0;
        while (i < var.length) {
            int n = i++;
            var[n] = var[n] / sum;
        }
        return var;
    }

    public static double spearmanCorrelation(double[] dataX, double[] dataY) {
        int j;
        double average;
        int count;
        int i;
        ArrayList<Pair<Double, Integer>> pairsX = new ArrayList<Pair<Double, Integer>>();
        ArrayList<Pair<Double, Integer>> pairsY = new ArrayList<Pair<Double, Integer>>();
        for (i = 0; i < dataX.length; ++i) {
            pairsX.add(new Pair<Double, Integer>(dataX[i], i));
            pairsY.add(new Pair<Double, Integer>(dataY[i], i));
        }
        Collections.sort(pairsX, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return (int)Math.signum((Double)o1.r - (Double)o2.r);
            }
        });
        Collections.sort(pairsY, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return (int)Math.signum((Double)o1.r - (Double)o2.r);
            }
        });
        for (i = 0; i < pairsX.size(); ++i) {
            count = 0;
            for (int j2 = i + 1; j2 < pairsX.size() && ((Double)((Pair)pairsX.get((int)i)).r).equals(((Pair)pairsX.get((int)j2)).r); ++j2) {
                count = j2 - i;
            }
            average = (double)i + (double)count / 2.0;
            for (j = 0; j <= count; ++j) {
                ((Pair)pairsX.get((int)(i + j))).r = average;
            }
            i += count;
        }
        for (i = 0; i < pairsY.size(); ++i) {
            count = 0;
            for (int j3 = i + 1; j3 < pairsY.size() && ((Double)((Pair)pairsY.get((int)i)).r).equals(((Pair)pairsY.get((int)j3)).r); ++j3) {
                count = j3 - i;
            }
            average = (double)i + (double)count / 2.0;
            for (j = 0; j <= count; ++j) {
                ((Pair)pairsY.get((int)(i + j))).r = average;
            }
            i += count;
        }
        Collections.sort(pairsX, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return (int)Math.signum((Integer)o1.s - (Integer)o2.s);
            }
        });
        Collections.sort(pairsY, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return (int)Math.signum((Integer)o1.s - (Integer)o2.s);
            }
        });
        double avgRank = (double)(pairsX.size() - 1) / 2.0;
        double sumNumerator = 0.0;
        double sumVarX = 0.0;
        double sumVarY = 0.0;
        for (int i2 = 0; i2 < pairsX.size(); ++i2) {
            sumNumerator += ((Double)((Pair)pairsX.get((int)i2)).r - avgRank) * ((Double)((Pair)pairsY.get((int)i2)).r - avgRank);
            sumVarX += ((Double)((Pair)pairsX.get((int)i2)).r - avgRank) * ((Double)((Pair)pairsX.get((int)i2)).r - avgRank);
            sumVarY += ((Double)((Pair)pairsY.get((int)i2)).r - avgRank) * ((Double)((Pair)pairsY.get((int)i2)).r - avgRank);
        }
        return sumNumerator / Math.sqrt(sumVarX * sumVarY);
    }

    public static double[] spearmanCorrelation(double[][] data) {
        double[] dataY = new double[data.length];
        double[] dataX = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            dataY[i] = data[i][data[0].length - 1];
        }
        double[] correlationCoeficients = new double[data[0].length];
        for (int i = 0; i < data[0].length - 1; ++i) {
            for (int j = 0; j < data.length; ++j) {
                dataX[j] = data[j][i];
            }
            correlationCoeficients[i] = Statistics.spearmanCorrelation(dataX, dataY);
        }
        correlationCoeficients[data[0].length - 1] = 1.0;
        return correlationCoeficients;
    }

    public static double[][] standardizeDataMatrix(double[][] data) {
        return Statistics.standardizeDataMatrix(data, null);
    }

    public static double[][] standardizeDataMatrix(double[][] data, double[] weights) {
        int i;
        double[][] standardizedData = new double[data.length][data[0].length];
        double[] mean = weights == null ? Statistics.mean(data) : Statistics.mean(data, weights);
        double[] dev = weights == null ? Statistics.variance(data) : Statistics.variance(data, weights);
        for (i = 0; i < dev.length; ++i) {
            dev[i] = Math.sqrt(dev[i]);
        }
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                standardizedData[i][j] = dev[j] != 0.0 ? (data[i][j] - mean[j]) / dev[j] : data[i][j] - mean[j];
            }
        }
        return standardizedData;
    }

    public static double[][] logDataMatrix(double[][] data) {
        double[][] standardizedData = new double[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                standardizedData[i][j] = Math.log(1.0 + data[i][j]);
            }
        }
        return standardizedData;
    }

    public static double[][] sigmoidDataMatrix(double[][] data) {
        double[][] standardizedData = new double[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                standardizedData[i][j] = 1.0 / (1.0 + Math.exp(-data[i][j]));
            }
        }
        return standardizedData;
    }

    public static DoubleFunction isotonicRegression(final double[] x, double[] fx) {
        for (int i = 0; i < x.length - 1; ++i) {
            if (!(x[i] > x[i + 1])) continue;
            throw new IllegalArgumentException("The argument x[] must be nondecreasing");
        }
        double[] fxprime = new double[fx.length];
        final double[] output = new double[fx.length];
        double[] wprime = new double[fx.length];
        ArrayList<Integer> s = new ArrayList<Integer>();
        s.add(1);
        fxprime[0] = fx[0];
        wprime[0] = 1.0;
        int j = 0;
        for (int i = 1; i < fx.length; ++i) {
            fxprime[++j] = fx[i];
            wprime[j] = 1.0;
            while (j > 0 && fxprime[j] < fxprime[j - 1]) {
                fxprime[j - 1] = (wprime[j] * fxprime[j] + wprime[j - 1] * fxprime[j - 1]) / (wprime[j] + wprime[j - 1]);
                wprime[j - 1] = wprime[j - 1] + wprime[j];
                --j;
            }
            if (j >= s.size()) {
                s.add(i + 1);
                continue;
            }
            s.set(j, i + 1);
        }
        for (int k = 0; k <= j; ++k) {
            int l;
            int n = l = k == 0 ? 0 : (Integer)s.get(k - 1);
            while (l < (Integer)s.get(k)) {
                output[l] = fxprime[k];
                ++l;
            }
        }
        return new DoubleFunction(){
            private double[] xx;
            private double[] fxx;
            {
                this.xx = x;
                this.fxx = output;
            }

            @Override
            public double f(double ... args) {
                double x2 = args[0];
                if (x2 < this.xx[0]) {
                    return this.fxx[0];
                }
                if (x2 > this.xx[this.xx.length - 1]) {
                    return this.fxx[this.fxx.length - 1];
                }
                int ind = Arrays.binarySearch(this.xx, x2);
                if (ind >= 0) {
                    return this.fxx[ind];
                }
                int insertionPoint = -ind - 1;
                if (this.xx[insertionPoint] - x2 > x2 - this.xx[insertionPoint - 1]) {
                    return this.fxx[insertionPoint - 1];
                }
                return this.fxx[insertionPoint];
            }
        };
    }

    public static <T> List<T> makeBootstrapSample(Collection<T> dataset, Random random) {
        ArrayList list = Sugar.arrayListFromCollections(dataset);
        ArrayList retVal = new ArrayList();
        int datasetSize = dataset.size();
        for (int i = 0; i < datasetSize; ++i) {
            retVal.add(list.get(random.nextInt(datasetSize)));
        }
        return retVal;
    }

    public static void main(String[] args) {
        double[] x = VectorUtils.doubleSequence(1.0, 10.0, 1.0);
        double[] y = VectorUtils.doubleSequence(2.0, 20.0, 2.0);
        y = VectorUtils.plus(y, VectorUtils.randomDoubleVector(y.length, 4.0));
        DoubleFunction df = Statistics.isotonicRegression(x, y);
        for (double i = 1.0; i < 10.0; i += 0.2) {
            System.out.println(df.f(i));
        }
    }
}

