/*
 * Decompiled with CFR 0.152.
 */
package ida.utils;

import ida.utils.Combinatorics;
import ida.utils.Sugar;
import ida.utils.collections.NaturalNumbersList;
import ida.utils.tuples.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class VectorUtils {
    private static Random random = new Random(2015L);

    private VectorUtils() {
    }

    public static double[] times(double[] a, double b) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] * b;
        }
        return c;
    }

    public static void multiply(double[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] * b;
        }
    }

    public static void add(double[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] + b;
        }
    }

    public static void add(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] + b[i];
        }
    }

    public static double[] plus(double[] a, double b) {
        double[] c = new double[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] + b;
        }
        return c;
    }

    public static double[] plus(double[] a, double[] b) {
        double[] c = new double[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    public static double[] minus(double[] a, double b) {
        double[] c = new double[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] - b;
        }
        return c;
    }

    public static double[] minus(double[] a, double[] b) {
        double[] c = new double[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public static void increment(double[] a) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] + 1.0;
        }
    }

    public static void increment(int[] a) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] + 1;
        }
    }

    public static void decrement(double[] a) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] - 1.0;
        }
    }

    public static void decrement(int[] a) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] - 1;
        }
    }

    public static int[] times(int[] a, int b) {
        int[] c = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] * b;
        }
        return c;
    }

    public static int[] plus(int[] a, int b) {
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] + b;
        }
        return c;
    }

    public static int[] plus(int[] a, int[] b) {
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    public static int[] minus(int[] a, int b) {
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] - b;
        }
        return c;
    }

    public static int[] minus(int[] a, int[] b) {
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public static boolean[] or(boolean[] a, boolean[] b) {
        boolean[] c = new boolean[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] | b[i];
        }
        return c;
    }

    public static boolean[] and(boolean[] a, boolean[] b) {
        boolean[] c = new boolean[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] & b[i];
        }
        return c;
    }

    public static boolean[] xor(boolean[] a, boolean[] b) {
        boolean[] c = new boolean[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] ^ b[i];
        }
        return c;
    }

    public static boolean[] not(boolean[] a) {
        boolean[] c = new boolean[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = !a[i];
        }
        return c;
    }

    public static double[] cummulative(double[] values) {
        double[] cumm = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (i == 0) {
                cumm[0] = values[0];
                continue;
            }
            cumm[i] = cumm[i - 1] + values[i];
        }
        return cumm;
    }

    public static double min(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        for (double value : values) {
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    public static double min(double[] values, boolean[] mask) {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        for (double value : values) {
            if (mask[i] && value < min) {
                min = value;
            }
            ++i;
        }
        return min;
    }

    public static int minIndex(double[] values) {
        double min = Double.NEGATIVE_INFINITY;
        int minIndex = 0;
        int index = 0;
        for (double value : values) {
            if (value < min) {
                min = value;
                minIndex = index;
            }
            ++index;
        }
        return minIndex;
    }

    public static int minIndex(double[] values, boolean[] mask) {
        double min = Double.NEGATIVE_INFINITY;
        int minIndex = 0;
        int index = 0;
        for (double value : values) {
            if (mask[index] && value < min) {
                min = value;
                minIndex = index;
            }
            ++index;
        }
        return minIndex;
    }

    public static double max(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        for (double value : values) {
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    public static int maxIndex(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        int maxIndex = 0;
        int index = 0;
        for (double value : values) {
            if (value > max) {
                max = value;
                maxIndex = index;
            }
            ++index;
        }
        return maxIndex;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum;
    }

    public static double product(double[] values) {
        double product = 1.0;
        for (double value : values) {
            product *= value;
        }
        return product;
    }

    public static double mean(double[] values) {
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum / (double)values.length;
    }

    public static double variance(double[] values) {
        if (values.length < 2) {
            return 0.0;
        }
        double mean = VectorUtils.mean(values);
        double var = 0.0;
        for (double d : values) {
            var += (d - mean) * (d - mean);
        }
        return var / (double)(values.length - 1);
    }

    public static double kurtosis(double[] values) {
        double s1 = 0.0;
        double s2 = 0.0;
        double mean = VectorUtils.mean(values);
        for (int i = 0; i < values.length; ++i) {
            double xi = values[i];
            s1 += (xi - mean) * (xi - mean) * (xi - mean) * (xi - mean);
            s2 += (xi - mean) * (xi - mean);
        }
        return s1 / (double)values.length / (s2 / (double)values.length * (s2 / (double)values.length)) - 3.0;
    }

    public static double mean_Double(List<Double> values) {
        return VectorUtils.mean(VectorUtils.toDoubleArray(values));
    }

    public static int median(int[] values) {
        if (values.length == 0) {
            return 0;
        }
        values = VectorUtils.copyArray(values);
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static double median(double[] values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        values = VectorUtils.copyArray(values);
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static int[] cummulative(int[] values) {
        int[] cumm = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (i == 0) {
                cumm[0] = values[0];
                continue;
            }
            cumm[i] = cumm[i - 1] + values[i];
        }
        return cumm;
    }

    public static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        for (int value : values) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static int minIndex(int[] values) {
        int min = Integer.MAX_VALUE;
        int minIndex = 0;
        int index = 0;
        for (int value : values) {
            if (value < min) {
                min = value;
                minIndex = index;
            }
            ++index;
        }
        return minIndex;
    }

    public static int max(int[] values) {
        int max = Integer.MIN_VALUE;
        for (int value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static int maxIndex(int[] values) {
        int max = Integer.MIN_VALUE;
        int maxIndex = 0;
        int index = 0;
        for (int value : values) {
            if (value > max) {
                max = value;
                maxIndex = index;
            }
            ++index;
        }
        return maxIndex;
    }

    public static List<Integer> maxIndices(int[] values) {
        int max = VectorUtils.max(values);
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != max) continue;
            retVal.add(i);
        }
        return retVal;
    }

    public static List<Integer> maxIndices(double[] values) {
        double max = VectorUtils.max(values);
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != max) continue;
            retVal.add(i);
        }
        return retVal;
    }

    public static int sum(int[] values) {
        int sum = 0;
        for (int value : values) {
            sum += value;
        }
        return sum;
    }

    public static int product(int[] values) {
        int product = 1;
        for (int value : values) {
            product *= value;
        }
        return product;
    }

    public static int occurrences(int[] values, int value) {
        int sum = 0;
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double v = nArray[i];
            if (v != (double)value) continue;
            ++sum;
        }
        return sum;
    }

    public static int occurrences(double[] values, double value) {
        int sum = 0;
        for (double v : values) {
            if (v != value) continue;
            ++sum;
        }
        return sum;
    }

    public static int occurrences(boolean[] values, boolean value) {
        int sum = 0;
        for (boolean v : values) {
            if (v != value) continue;
            ++sum;
        }
        return sum;
    }

    public static int find(int[] array, int value) {
        return VectorUtils.find(array, value, 0);
    }

    public static int find(int[] array, int value, int start) {
        for (int i = start; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int find(double[] array, double value) {
        return VectorUtils.find(array, value, 0);
    }

    public static int find(double[] array, double value, int start) {
        for (int i = start; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int find(boolean[] array, boolean value) {
        return VectorUtils.find(array, value, 0);
    }

    public static int find(boolean[] array, boolean value, int start) {
        for (int i = start; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int[] findAll(int[] array, int value) {
        int[] retVal = new int[VectorUtils.occurrences(array, value)];
        int index = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            retVal[index++] = i;
        }
        return retVal;
    }

    public static int[] findAll(double[] array, double value) {
        int[] retVal = new int[VectorUtils.occurrences(array, value)];
        int index = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            retVal[index++] = i;
        }
        return retVal;
    }

    public static int[] findAll(boolean[] array, boolean value) {
        int[] retVal = new int[VectorUtils.occurrences(array, value)];
        int index = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            retVal[index++] = i;
        }
        return retVal;
    }

    public static double mean(int[] values) {
        double sum = 0.0;
        for (int value : values) {
            sum += (double)value;
        }
        return sum / (double)values.length;
    }

    public static double mean_Integer(List<Integer> values) {
        return VectorUtils.mean(VectorUtils.toIntegerArray(values));
    }

    public static void shuffle(int[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            if (!(Math.random() < 0.5)) continue;
            VectorUtils.swap(array, i, random.nextInt(array.length - i) + i);
        }
    }

    public static void shuffle(int[] array, Random random) {
        for (int i = 0; i < array.length / 2; ++i) {
            if (!random.nextBoolean()) continue;
            VectorUtils.swap(array, i, random.nextInt(array.length - i) + i);
        }
    }

    public static void shuffle(Object[] array) {
        VectorUtils.shuffle(array, random);
    }

    public static void shuffle(Object[] array, Random random) {
        for (int i = 0; i < array.length / 2; ++i) {
            if (!random.nextBoolean()) continue;
            VectorUtils.swap(array, i, random.nextInt(array.length - i) + i);
        }
    }

    public static void swap(int[] array, int i1, int i2) {
        int temp = array[i1];
        array[i1] = array[i2];
        array[i2] = temp;
    }

    public static void swap(boolean[] array, int i1, int i2) {
        boolean temp = array[i1];
        array[i1] = array[i2];
        array[i2] = temp;
    }

    public static void swap(double[] array, int i1, int i2) {
        double temp = array[i1];
        array[i1] = array[i2];
        array[i2] = temp;
    }

    public static void swap(char[] array, int i1, int i2) {
        char temp = array[i1];
        array[i1] = array[i2];
        array[i2] = temp;
    }

    public static void swap(Object[] array, int i1, int i2) {
        Object temp = array[i1];
        array[i1] = array[i2];
        array[i2] = temp;
    }

    public static double[] toDoubleArray(Collection<Double> values) {
        double[] ret = new double[values.size()];
        int i = 0;
        Iterator<Double> iterator = values.iterator();
        while (iterator.hasNext()) {
            double d;
            ret[i] = d = iterator.next().doubleValue();
            ++i;
        }
        return ret;
    }

    public static boolean[] toBooleanArray(Collection<Boolean> values) {
        boolean[] ret = new boolean[values.size()];
        int i = 0;
        Iterator<Boolean> iterator = values.iterator();
        while (iterator.hasNext()) {
            boolean b;
            ret[i] = b = iterator.next().booleanValue();
            ++i;
        }
        return ret;
    }

    public static int[] toIntegerArray(Collection<Integer> values) {
        int[] ret = new int[values.size()];
        int i = 0;
        Iterator<Integer> iterator = values.iterator();
        while (iterator.hasNext()) {
            int integer;
            ret[i] = integer = iterator.next().intValue();
            ++i;
        }
        return ret;
    }

    public static int[] toIntegerArray(Set<Integer> values) {
        int[] ret = new int[values.size()];
        int i = 0;
        for (int val : values) {
            ret[i++] = val;
        }
        return ret;
    }

    public static double[] copyArray(double[] array) {
        double[] retVal = new double[array.length];
        System.arraycopy(array, 0, retVal, 0, array.length);
        return retVal;
    }

    public static int[] copyArray(int[] array) {
        int[] retVal = new int[array.length];
        System.arraycopy(array, 0, retVal, 0, array.length);
        return retVal;
    }

    public static boolean[] copyArray(boolean[] array) {
        boolean[] retVal = new boolean[array.length];
        System.arraycopy(array, 0, retVal, 0, array.length);
        return retVal;
    }

    public static double[] copyArray(double[] array, int start, int length) {
        double[] retVal = new double[length];
        System.arraycopy(array, 0, retVal, start, length);
        return retVal;
    }

    public static int[] copyArray(int[] array, int start, int length) {
        int[] retVal = new int[length];
        System.arraycopy(array, 0, retVal, start, length);
        return retVal;
    }

    public static boolean[] copyArray(boolean[] array, int start, int length) {
        boolean[] retVal = new boolean[length];
        System.arraycopy(array, 0, retVal, start, length);
        return retVal;
    }

    public static double[] concat(double[] array1, double[] array2) {
        double[] retVal = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, retVal, 0, array1.length);
        System.arraycopy(array2, 0, retVal, array1.length, array2.length);
        return retVal;
    }

    public static int[] concat(int[] array1, int[] array2) {
        int[] retVal = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, retVal, 0, array1.length);
        System.arraycopy(array2, 0, retVal, array1.length, array2.length);
        return retVal;
    }

    public static long[] concat(long[] array1, long[] array2) {
        long[] retVal = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, retVal, 0, array1.length);
        System.arraycopy(array2, 0, retVal, array1.length, array2.length);
        return retVal;
    }

    public static boolean[] concat(boolean[] array1, boolean[] array2) {
        boolean[] retVal = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, retVal, 0, array1.length);
        System.arraycopy(array2, 0, retVal, array1.length, array2.length);
        return retVal;
    }

    public static double[] parseDoubleArray(String s) {
        s = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
        String[] items = s.split(",");
        ArrayList<Double> d = new ArrayList<Double>();
        for (String strItem : items) {
            if ((strItem = strItem.trim()).length() <= 0) continue;
            d.add(Double.parseDouble(strItem));
        }
        return VectorUtils.toDoubleArray(d);
    }

    public static int[] parseIntegerArray(String s) {
        s = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
        String[] items = s.split(",");
        ArrayList<Integer> d = new ArrayList<Integer>();
        for (String strItem : items) {
            if ((strItem = strItem.trim()).length() <= 0) continue;
            d.add(Integer.parseInt(strItem));
        }
        return VectorUtils.toIntegerArray(d);
    }

    public static String intArrayToString(int[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int a : array) {
            sb.append(a).append(", ");
        }
        if (sb.lastIndexOf(", ") != -1) {
            sb.delete(sb.lastIndexOf(", "), sb.length());
        }
        sb.append("]");
        return sb.toString();
    }

    public static String longArrayToString(long[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (long a : array) {
            sb.append(a).append(", ");
        }
        if (sb.lastIndexOf(", ") != -1) {
            sb.delete(sb.lastIndexOf(", "), sb.length());
        }
        sb.append("]");
        return sb.toString();
    }

    public static String doubleArrayToString(double[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (double a : array) {
            sb.append(a).append(", ");
        }
        if (sb.lastIndexOf(", ") != -1) {
            sb.delete(sb.lastIndexOf(", "), sb.length());
        }
        sb.append("]");
        return sb.toString();
    }

    public static String booleanArrayToString(boolean[] array) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (boolean a : array) {
            sb.append((a ? 1 : 0) + ", ");
        }
        if (sb.lastIndexOf(", ") != -1) {
            sb.delete(sb.lastIndexOf(", "), sb.length());
        }
        sb.append("]");
        return sb.toString();
    }

    public static int[] randomVector(int size) {
        return VectorUtils.randomVector(size, Integer.MAX_VALUE);
    }

    public static int[] randomVector(int size, int max) {
        return VectorUtils.randomVector(size, max, random);
    }

    public static int[] randomVector(int size, int max, Random rand) {
        int[] retVal = new int[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = rand.nextInt(max);
        }
        return retVal;
    }

    public static double[] randomDoubleVector(int size) {
        return VectorUtils.randomDoubleVector(size, 1.0);
    }

    public static double[] randomDoubleVector(int size, double max) {
        return VectorUtils.randomDoubleVector(size, max, random);
    }

    public static double[] randomDoubleVector(int size, double max, Random rand) {
        double[] retVal = new double[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = rand.nextDouble() * max;
        }
        return retVal;
    }

    public static boolean[] randomBooleanVector(int size) {
        return VectorUtils.randomBooleanVector(size, random);
    }

    public static boolean[] randomBooleanVector(int size, Random random) {
        boolean[] retVal = new boolean[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = random.nextBoolean();
        }
        return retVal;
    }

    public static boolean[] randomBooleanVector(int size, int numTrues) {
        return VectorUtils.randomBooleanVector(size, numTrues, random);
    }

    public static boolean[] randomBooleanVector(int size, int numTrues, Random random) {
        Tuple<Integer> tuple = Combinatorics.randomCombination(new NaturalNumbersList(0, size), numTrues, random);
        boolean[] retVal = new boolean[size];
        for (int i = 0; i < tuple.size(); ++i) {
            retVal[tuple.get((int)i).intValue()] = true;
        }
        return retVal;
    }

    public static char[] randomCharacterVector(int size) {
        char[] retVal = new char[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = (char)(65 + random.nextInt(25));
        }
        return retVal;
    }

    public static List<Integer> toList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : array) {
            list.add(i);
        }
        return list;
    }

    public static List<Double> toList(double[] array) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (double i : array) {
            list.add(i);
        }
        return list;
    }

    public static List<Boolean> toList(boolean[] array) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (boolean i : array) {
            list.add(i);
        }
        return list;
    }

    public static boolean[] trues(int size) {
        boolean[] b = new boolean[size];
        Arrays.fill(b, true);
        return b;
    }

    public static boolean[] falses(int size) {
        boolean[] b = new boolean[size];
        Arrays.fill(b, false);
        return b;
    }

    public static boolean allEqual(int[] values) {
        if (values.length == 0) {
            return true;
        }
        int value = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == value) continue;
            return false;
        }
        return true;
    }

    public static boolean allEqual(double[] values) {
        if (values.length == 0) {
            return true;
        }
        double value = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == value) continue;
            return false;
        }
        return true;
    }

    public static boolean allEqual(boolean[] values) {
        if (values.length == 0) {
            return true;
        }
        boolean value = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == value) continue;
            return false;
        }
        return true;
    }

    public static boolean lowerThan(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean greaterThan(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] > b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean lowerOrEqual(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean greaterThanOrEqual(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] >= b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(int[] a, int[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equal(boolean[] a, boolean[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equal(double[] a, double[] b) {
        return Arrays.equals(a, b);
    }

    public static void reverse(int[] ch) {
        for (int i = 0; i < ch.length / 2; ++i) {
            VectorUtils.swap(ch, i, ch.length - i - 1);
        }
    }

    public static void reverse(boolean[] ch) {
        for (int i = 0; i < ch.length / 2; ++i) {
            VectorUtils.swap(ch, i, ch.length - i - 1);
        }
    }

    public static void reverse(double[] ch) {
        for (int i = 0; i < ch.length / 2; ++i) {
            VectorUtils.swap(ch, i, ch.length - i - 1);
        }
    }

    public static void reverse(char[] ch) {
        for (int i = 0; i < ch.length / 2; ++i) {
            VectorUtils.swap(ch, i, ch.length - i - 1);
        }
    }

    public static boolean allSmallerThan(double[] vector, double value) {
        for (double d : vector) {
            if (!(d >= value)) continue;
            return false;
        }
        return true;
    }

    public static boolean allGreaterThan(double[] vector, double value) {
        for (double d : vector) {
            if (!(d <= value)) continue;
            return false;
        }
        return true;
    }

    public static boolean allSmallerThan(int[] vector, int value) {
        int[] nArray = vector;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double d = nArray[i];
            if (!(d >= (double)value)) continue;
            return false;
        }
        return true;
    }

    public static boolean allGreaterThan(int[] vector, int value) {
        int[] nArray = vector;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double d = nArray[i];
            if (!(d <= (double)value)) continue;
            return false;
        }
        return true;
    }

    public static double integrate(double[] x, double[] y) {
        double area = 0.0;
        for (int i = 0; i < x.length - 1; ++i) {
            area += (x[i + 1] - x[i]) * (y[i] + y[i + 1]) / 2.0;
        }
        return area;
    }

    public static int[] sequence(int start, int end) {
        return VectorUtils.sequence(start, end, 1);
    }

    public static double[] doubleSequence(double start, double end, double increment) {
        if (start == end) {
            return new double[]{start};
        }
        double[] retVal = new double[(int)Math.ceil((end - start) / increment) + 1];
        double a = start;
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = a;
            a += increment;
        }
        return retVal;
    }

    public static int[] sequence(int start, int end, int increment) {
        if (start == end) {
            return new int[]{start};
        }
        int[] retVal = new int[(int)Math.ceil((double)(end - start) / (double)increment) + 1];
        int a = start;
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = a;
            a += increment;
        }
        return retVal;
    }

    public static double[] subvector(double[] vector, int start, int end) {
        double[] retVal = new double[end - start];
        for (int i = start; i < end; ++i) {
            retVal[i - start] = vector[i];
        }
        return retVal;
    }

    public static int[] subvector(int[] vector, int start, int end) {
        int[] retVal = new int[end - start];
        for (int i = start; i < end; ++i) {
            retVal[i - start] = vector[i];
        }
        return retVal;
    }

    public static int[] subvector(int[] vector, int[] indexes) {
        int[] retVal = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            retVal[i] = vector[indexes[i]];
        }
        return retVal;
    }

    public static boolean[] subvector(boolean[] vector, int start, int end) {
        boolean[] retVal = new boolean[end - start];
        for (int i = start; i < end; ++i) {
            retVal[i - start] = vector[i];
        }
        return retVal;
    }

    public static int[] repeat(int repeats, int value) {
        int[] retVal = new int[repeats];
        Arrays.fill(retVal, value);
        return retVal;
    }

    public static double[] repeat(int repeats, double value) {
        double[] retVal = new double[repeats];
        Arrays.fill(retVal, value);
        return retVal;
    }

    public static boolean[] repeat(int repeats, boolean value) {
        boolean[] retVal = new boolean[repeats];
        Arrays.fill(retVal, value);
        return retVal;
    }

    public static int[] repeat(int repeats, int[] seq) {
        int[] retVal = new int[repeats * seq.length];
        for (int i = 0; i < repeats; ++i) {
            System.arraycopy(seq, 0, retVal, i * seq.length, seq.length);
        }
        return retVal;
    }

    public static int distinct(long[] vector) {
        HashSet<Long> set = new HashSet<Long>();
        for (long l : vector) {
            set.add(l);
        }
        return set.size();
    }

    public static int hammingDistance(boolean[] a, boolean[] b) {
        int hd = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            ++hd;
        }
        return hd;
    }

    public static double[] exp(double[] a) {
        double[] retVal = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = Math.exp(a[i]);
        }
        return retVal;
    }

    public static double[] fun(double[] a, Sugar.Fun<Double, Double> fun) {
        double[] retVal = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = fun.apply(a[i]);
        }
        return retVal;
    }

    public static double dotProduct(double[] a, double[] b) {
        double retVal = 0.0;
        for (int i = 0; i < a.length; ++i) {
            retVal += a[i] * b[i];
        }
        return retVal;
    }

    public static BitSet toBitSet(boolean[] b) {
        BitSet bs = new BitSet(b.length);
        for (int i = 0; i < b.length; ++i) {
            bs.set(i, b[i]);
        }
        return bs;
    }

    public static BitSet[] toBitSets(boolean[][] b) {
        BitSet[] retVal = new BitSet[b.length];
        for (int i = 0; i < b.length; ++i) {
            retVal[i] = VectorUtils.toBitSet(b[i]);
        }
        return retVal;
    }
}

