/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import ida.utils.tuples.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Counters<T> {
    private HashMap<T, Integer> map = new HashMap();

    public Counters() {
    }

    public Counters(Collection<T> elements) {
        this();
        for (T t : elements) {
            this.increment(t);
        }
    }

    public static <T> Counters<T> createCounters(Set<Pair<T, Integer>> pairs) {
        Counters counters = new Counters();
        for (Pair<T, Integer> pair : pairs) {
            counters.add(pair.r, (Integer)pair.s);
        }
        return counters;
    }

    public void add(T key, int value) {
        this.addPre(key, value);
    }

    public int addPre(T key, int value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, value);
        } else {
            this.map.put(key, this.map.get(key) + value);
        }
        return this.map.get(key);
    }

    public int addPost(T key, int value) {
        int oldValue = 0;
        if (!this.map.containsKey(key)) {
            this.map.put(key, value);
        } else {
            oldValue = this.map.get(key);
            this.map.put(key, this.map.get(key) + value);
        }
        return oldValue;
    }

    public void increment(T key) {
        this.incrementPre(key);
    }

    public void decrement(T key) {
        this.decrementPre(key);
    }

    public int get(T key) {
        if (!this.map.containsKey(key)) {
            return 0;
        }
        return this.map.get(key);
    }

    public int incrementPre(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, 1);
        } else {
            this.map.put(key, this.map.get(key) + 1);
        }
        return this.map.get(key);
    }

    public int incrementPost(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, 1);
        } else {
            this.map.put(key, this.map.get(key) + 1);
        }
        return this.map.get(key) - 1;
    }

    public int decrementPre(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, -1);
        } else {
            this.map.put(key, this.map.get(key) - 1);
        }
        return this.map.get(key);
    }

    public int decrementPost(T key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, -1);
        } else {
            this.map.put(key, this.map.get(key) - 1);
        }
        return this.map.get(key) + 1;
    }

    public Set<T> keySet() {
        return this.map.keySet();
    }

    public Collection<Integer> counts() {
        return this.map.values();
    }

    public void addAll(Counters<T> counters) {
        for (Map.Entry<T, Integer> entry : counters.map.entrySet()) {
            if (this.map.containsKey(entry.getKey())) {
                this.map.put(entry.getKey(), this.map.get(entry.getKey()) + entry.getValue());
                continue;
            }
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Counters) {
            return ((Counters)o).map.equals(this.map);
        }
        return false;
    }

    public Map<T, Integer> toMap() {
        HashMap<T, Integer> copy = new HashMap<T, Integer>();
        copy.putAll(this.map);
        return copy;
    }

    public int size() {
        return this.map.size();
    }

    public int findMinCount() {
        int min = Integer.MAX_VALUE;
        for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
            min = Math.min(min, entry.getValue());
        }
        return min;
    }

    public int findMaxCount() {
        int max = Integer.MIN_VALUE;
        for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
            max = Math.max(max, entry.getValue());
        }
        return max;
    }

    public T findMin() {
        T retVal = null;
        int min = Integer.MAX_VALUE;
        for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
            min = Math.min(min, entry.getValue());
            retVal = entry.getKey();
        }
        return retVal;
    }

    public T findMax() {
        T retVal = null;
        int max = Integer.MIN_VALUE;
        for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
            max = Math.max(max, entry.getValue());
            retVal = entry.getKey();
        }
        return retVal;
    }
}

