/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import ida.utils.Sugar;
import ida.utils.VectorUtils;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Heap<T> {
    private double[] keys;
    private T[] values;
    private Map<T, Integer> indexes = new HashMap<T, Integer>();
    private int last = 0;
    private double growFactor = 2.0;
    private int maxSize = 0;

    public Heap() {
        this(32);
    }

    public Heap(int initialCapacity) {
        this.keys = new double[initialCapacity];
        this.keys[0] = -2.147483648E9;
        this.values = new Object[initialCapacity];
    }

    public T removeMin() {
        if (this.last > 1) {
            T ret = this.values[1];
            this.swap(1, this.last);
            this.values[this.last] = null;
            --this.last;
            this.repairTopDown(1);
            this.indexes.remove(ret);
            return ret;
        }
        if (this.last == 1) {
            this.last = 0;
            this.indexes.remove(this.values[1]);
            return this.values[1];
        }
        throw new IllegalStateException();
    }

    public T lookAtMinValue() {
        return this.values[1];
    }

    public void updateKey(double newKey, T elementToBeUpdated) {
        if (!this.indexes.containsKey(elementToBeUpdated)) {
            this.add(newKey, elementToBeUpdated);
        } else if (this.last > 1) {
            int originalIndex = this.indexes.get(elementToBeUpdated);
            this.swap(originalIndex, this.last);
            --this.last;
            this.repairTopDown(originalIndex);
            this.add(newKey, elementToBeUpdated);
        } else {
            this.keys[1] = newKey;
        }
    }

    public boolean containsElement(T element) {
        return this.indexes.containsKey(element);
    }

    public void removeElement(T elementToBeRemoved) {
        if (!this.indexes.containsKey(elementToBeRemoved)) {
            throw new IllegalArgumentException("The removed element is not contained iterable the heap.");
        }
        if (this.last > 1) {
            int originalIndex = this.indexes.get(elementToBeRemoved);
            this.swap(originalIndex, this.last);
            --this.last;
            this.repairTopDown(originalIndex);
            this.indexes.remove(elementToBeRemoved);
            this.values[this.last + 1] = null;
        } else {
            this.last = 0;
            this.indexes.remove(this.values[1]);
            this.values[1] = null;
        }
    }

    public double lookAtMinKey() {
        return this.keys[1];
    }

    public boolean hasNext() {
        return this.last != 0;
    }

    public int size() {
        return this.last;
    }

    public void add(double key, T value) {
        ++this.last;
        if (this.last == this.keys.length) {
            this.realloc();
        }
        this.values[this.last] = value;
        this.indexes.put(value, this.last);
        this.keys[this.last] = key;
        this.repairBottomUp(this.last);
        this.maxSize = Math.max(this.maxSize, this.last - 1);
    }

    private void repairBottomUp(int leaf) {
        while (leaf > 1 && this.keys[leaf] < this.keys[leaf / 2]) {
            this.swap(leaf, leaf / 2);
            leaf /= 2;
        }
    }

    private void repairTopDown(int root) {
        while (true) {
            if (2 * root + 1 <= this.last && this.keys[2 * root + 1] < this.keys[2 * root] && this.keys[root] > this.keys[2 * root + 1]) {
                this.swap(root, 2 * root + 1);
                root = 2 * root + 1;
                continue;
            }
            if (2 * root > this.last || !(this.keys[root] > this.keys[2 * root])) break;
            this.swap(root, 2 * root);
            root *= 2;
        }
    }

    private void swap(int a, int b) {
        double temp = this.keys[a];
        this.keys[a] = this.keys[b];
        this.keys[b] = temp;
        T ttemp = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = ttemp;
        this.indexes.put(this.values[a], a);
        this.indexes.put(this.values[b], b);
    }

    private void realloc() {
        double[] newKeys = new double[(int)((double)this.keys.length * this.growFactor)];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        this.keys = newKeys;
        Object[] newValues = new Object[(int)((double)this.values.length * this.growFactor)];
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        this.values = newValues;
    }

    public List<Pair<T, Double>> values() {
        ArrayList<Pair<T, Double>> list = new ArrayList<Pair<T, Double>>();
        for (int i = 1; i <= this.last; ++i) {
            list.add(new Pair<T, Double>(this.values[i], this.keys[i]));
        }
        return list;
    }

    public String toString() {
        return "Heap.values: " + Sugar.objectArrayToString(this.values) + ", Heap.keys: " + VectorUtils.doubleArrayToString(this.keys);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values) + Arrays.hashCode(this.keys);
    }

    public boolean equals(Object o) {
        if (o instanceof Heap) {
            Heap h = (Heap)o;
            return Arrays.equals(this.values, h.values) && Arrays.equals(this.keys, h.keys);
        }
        return false;
    }

    public static void main(String[] args) {
        int i;
        Heap<Integer> h = new Heap<Integer>();
        for (i = 0; i < 20; ++i) {
            h.add((int)(2.0 * Math.random()), i);
        }
        while (h.hasNext()) {
            System.out.print(h.lookAtMinKey() + " -> " + h.removeMin() + ", ");
        }
        System.out.println();
        for (i = 0; i < 20; ++i) {
            h.add(2.0 * Math.random(), i);
        }
        while (h.hasNext()) {
            System.out.print(h.lookAtMinKey() + " -> " + h.removeMin() + ", ");
        }
        System.out.println();
        h.add(2.0, 1);
        h.add(1.0, 2);
        h.add(3.0, 3);
        h.add(4.0, 4);
        h.add(6.0, 5);
        h.updateKey(1.0, 1);
        h.updateKey(2.0, 2);
        h.updateKey(5.0, 5);
        while (h.hasNext()) {
            System.out.print(h.lookAtMinKey() + " -> " + h.removeMin() + ", ");
        }
        System.out.println();
        h.add(2.0, 1);
        h.add(1.0, 2);
        h.add(3.0, 3);
        h.add(4.0, 4);
        h.add(6.0, 5);
        h.removeElement(1);
        h.removeElement(2);
        h.removeElement(5);
        while (h.hasNext()) {
            System.out.print(h.lookAtMinKey() + " -> " + h.removeMin() + ", ");
        }
        System.out.println();
    }
}

