/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.functions.specific;

import java.util.function.Function;
import java.util.logging.Logger;
import networks.computation.evaluation.functions.Activation;
import networks.structure.metadata.states.AggregationState;
import utils.generic.Pair;

public class ReLu
extends Activation {
    private static final Logger LOG = Logger.getLogger(ReLu.class.getName());
    private static final Function<Double, Double> signum = in -> in > 0.0 ? in : 0.0;
    private static final Function<Double, Double> zerograd = in -> in > 0.0 ? 1.0 : 0.0;

    @Override
    public String getName() {
        return ReLu.class.getSimpleName();
    }

    public ReLu() {
        super(signum, zerograd);
    }

    @Override
    public ReLu replaceWithSingleton() {
        return Activation.Singletons.relu;
    }

    @Override
    public AggregationState getAggregationState() {
        return new AggregationState.ActivationState(this);
    }

    @Override
    public Pair<Double, Double> getSaturationRange() {
        return new Pair<Double, Double>(0.01, (Double)Double.MAX_VALUE);
    }
}

