/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.results;

import java.util.logging.Logger;
import networks.computation.evaluation.functions.ErrorFcn;
import networks.computation.evaluation.functions.specific.Crossentropy;
import networks.computation.evaluation.functions.specific.SquaredDiff;
import networks.computation.evaluation.values.Value;
import settings.Settings;

public class Result
implements Comparable<Result> {
    private static final Logger LOG = Logger.getLogger(Result.class.getName());
    ErrorFcn errorFcn;
    String sampleId;
    Value output;
    Value target;

    private Result(ErrorFcn errorFcn, String sampleId, Value target, Value output) {
        this.errorFcn = errorFcn;
        this.sampleId = sampleId;
        this.target = target;
        this.output = output;
    }

    public Value errorValue() {
        return this.errorFcn.evaluate(this.output, this.target);
    }

    public Value errorGradient() {
        return this.errorFcn.differentiate(this.output, this.target);
    }

    public String toString() {
        return this.sampleId + " -> " + this.output + " : " + this.target;
    }

    @Override
    public int compareTo(Result other) {
        if (this.output.greaterThan(other.output)) {
            return 1;
        }
        if (this.output.equals(other.output)) {
            return 0;
        }
        return -1;
    }

    public static class Factory {
        Settings settings;
        ErrorFcn errorFcn;

        public Factory(Settings settings) {
            this.settings = settings;
            this.errorFcn = this.getErrFcn(settings);
        }

        public Result create(String sampleId, Value target, Value output) {
            Result result = new Result(this.errorFcn, sampleId, target, output);
            return result;
        }

        private ErrorFcn getErrFcn(Settings settings) {
            if (settings.errorFunction == Settings.ErrorFcn.SQUARED_DIFF) {
                return new SquaredDiff();
            }
            if (settings.errorFunction == Settings.ErrorFcn.CROSSENTROPY) {
                return new Crossentropy();
            }
            return null;
        }
    }
}

