/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.values;

import com.sun.istack.internal.NotNull;
import java.util.Iterator;
import java.util.function.Function;
import java.util.logging.Logger;
import networks.computation.evaluation.values.MatrixValue;
import networks.computation.evaluation.values.Value;
import networks.computation.evaluation.values.VectorValue;
import networks.computation.evaluation.values.distributions.ValueInitializer;
import settings.Settings;

public class ScalarValue
extends Value {
    private static final Logger LOG = Logger.getLogger(ScalarValue.class.getName());
    public double value;

    public ScalarValue() {
        this.value = 0.0;
    }

    public ScalarValue(double val) {
        this.value = val;
    }

    public ScalarValue(ValueInitializer valueInitializer) {
        this.initialize(valueInitializer);
    }

    @Override
    @NotNull
    public Iterator<Double> iterator() {
        return new ValueIterator();
    }

    @Override
    public void initialize(ValueInitializer valueInitializer) {
        valueInitializer.initScalar(this);
    }

    @Override
    public ScalarValue zero() {
        this.value = 0.0;
        return this;
    }

    @Override
    public Value clone() {
        return new ScalarValue(this.value);
    }

    @Override
    public Value getForm() {
        return new ScalarValue(0.0);
    }

    @Override
    public void transpose() {
    }

    @Override
    public Value transposedView() {
        return this;
    }

    @Override
    public int[] size() {
        return new int[0];
    }

    @Override
    public Value apply(Function<Double, Double> function) {
        return new ScalarValue(function.apply(this.value));
    }

    @Override
    public double get(int i) {
        if (i != 0) {
            LOG.severe("Scalar value: asking for i-th element!");
        }
        return this.value;
    }

    @Override
    public void set(int i, double value) {
        if (i != 0) {
            LOG.severe("Scalar value: asking for i-th element!");
        }
        this.value = value;
    }

    @Override
    public void increment(int i, double value) {
        if (i != 0) {
            LOG.severe("Scalar value: asking for i-th element!");
        }
        this.value += value;
    }

    @Override
    public String toString() {
        return Settings.detailedNumberFormat.format(this.value);
    }

    @Override
    public String toDetailedString() {
        return Settings.superDetailedNumberFormat.format(this.value);
    }

    @Override
    public Value times(Value value) {
        return value.times(this);
    }

    @Override
    protected ScalarValue times(ScalarValue value) {
        return new ScalarValue(this.value * value.value);
    }

    @Override
    protected VectorValue times(VectorValue vector) {
        VectorValue clone = vector.clone();
        int i = 0;
        while (i < vector.values.length) {
            int n = i++;
            clone.values[n] = clone.values[n] * this.value;
        }
        return clone;
    }

    @Override
    protected MatrixValue times(MatrixValue value) {
        MatrixValue clone = value.clone();
        for (int i = 0; i < clone.rows; ++i) {
            int j = 0;
            while (j < clone.cols) {
                double[] dArray = clone.values[i];
                int n = j++;
                dArray[n] = dArray[n] * this.value;
            }
        }
        return clone;
    }

    @Override
    public Value elementTimes(Value value) {
        return value.elementTimes(this);
    }

    @Override
    protected Value elementTimes(ScalarValue value) {
        return new ScalarValue(this.value * value.value);
    }

    @Override
    protected Value elementTimes(VectorValue vector) {
        VectorValue clone = vector.clone();
        int i = 0;
        while (i < vector.values.length) {
            int n = i++;
            clone.values[n] = clone.values[n] * this.value;
        }
        return clone;
    }

    @Override
    protected Value elementTimes(MatrixValue value) {
        MatrixValue clone = value.clone();
        for (int i = 0; i < clone.rows; ++i) {
            int j = 0;
            while (j < clone.cols) {
                double[] dArray = clone.values[i];
                int n = j++;
                dArray[n] = dArray[n] * this.value;
            }
        }
        return clone;
    }

    @Override
    public Value plus(Value value) {
        return value.plus(this);
    }

    @Override
    protected ScalarValue plus(ScalarValue value) {
        return new ScalarValue(this.value + value.value);
    }

    @Override
    protected VectorValue plus(VectorValue value) {
        VectorValue clone = value.clone();
        int i = 0;
        while (i < clone.values.length) {
            int n = i++;
            clone.values[n] = clone.values[n] + this.value;
        }
        return clone;
    }

    @Override
    protected MatrixValue plus(MatrixValue value) {
        MatrixValue clone = value.clone();
        for (int i = 0; i < clone.rows; ++i) {
            int j = 0;
            while (j < clone.cols) {
                double[] dArray = clone.values[i];
                int n = j++;
                dArray[n] = dArray[n] + this.value;
            }
        }
        return clone;
    }

    @Override
    public Value minus(Value value) {
        return value.minus(this);
    }

    @Override
    protected ScalarValue minus(ScalarValue value) {
        return new ScalarValue(value.value - this.value);
    }

    @Override
    protected VectorValue minus(VectorValue value) {
        VectorValue clone = value.clone();
        int i = 0;
        while (i < clone.values.length) {
            int n = i++;
            clone.values[n] = clone.values[n] - this.value;
        }
        return clone;
    }

    @Override
    protected MatrixValue minus(MatrixValue value) {
        MatrixValue clone = value.clone();
        for (int i = 0; i < clone.rows; ++i) {
            int j = 0;
            while (j < clone.cols) {
                double[] dArray = clone.values[i];
                int n = j++;
                dArray[n] = dArray[n] - this.value;
            }
        }
        return clone;
    }

    @Override
    public void incrementBy(Value value) {
        value.incrementBy(this);
    }

    @Override
    protected void incrementBy(ScalarValue value) {
        value.value += this.value;
    }

    @Override
    protected void incrementBy(VectorValue value) {
        int i = 0;
        while (i < value.values.length) {
            int n = i++;
            value.values[n] = value.values[n] + this.value;
        }
    }

    @Override
    protected void incrementBy(MatrixValue value) {
        for (int i = 0; i < value.rows; ++i) {
            int j = 0;
            while (j < value.cols) {
                double[] dArray = value.values[i];
                int n = j++;
                dArray[n] = dArray[n] + this.value;
            }
        }
    }

    @Override
    public boolean greaterThan(Value maxValue) {
        return maxValue.greaterThan(this);
    }

    @Override
    protected boolean greaterThan(ScalarValue maxValue) {
        return maxValue.value > this.value;
    }

    @Override
    protected boolean greaterThan(VectorValue maxValue) {
        int greater = 0;
        for (int i = 0; i < maxValue.values.length; ++i) {
            if (!(maxValue.values[i] > this.value)) continue;
            ++greater;
        }
        return greater > maxValue.values.length / 2;
    }

    @Override
    protected boolean greaterThan(MatrixValue maxValue) {
        int greater = 0;
        for (int i = 0; i < maxValue.rows; ++i) {
            for (int j = 0; j < maxValue.cols; ++j) {
                if (!(maxValue.values[i][j] > this.value)) continue;
                ++greater;
            }
        }
        return greater > maxValue.cols * maxValue.rows / 2;
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScalarValue) {
            ScalarValue obj1 = (ScalarValue)obj;
            if (obj1.value == this.value) {
                return true;
            }
        }
        return false;
    }

    protected class ValueIterator
    implements Iterator<Double> {
        int i = 0;

        protected ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i == 0;
        }

        @Override
        public Double next() {
            ++this.i;
            return ScalarValue.this.value;
        }
    }
}

