/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.values;

import com.sun.istack.internal.NotNull;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import networks.computation.evaluation.values.MatrixValue;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.Value;
import networks.computation.evaluation.values.distributions.ValueInitializer;
import settings.Settings;

public class VectorValue
extends Value {
    private static final Logger LOG = Logger.getLogger(VectorValue.class.getName());
    public double[] values;
    public boolean rowOrientation = false;

    public VectorValue(int size) {
        this.values = new double[size];
    }

    public VectorValue(List<Double> vector) {
        this.values = vector.stream().mapToDouble(d -> d).toArray();
    }

    public VectorValue(int size, ValueInitializer valueInitializer) {
        this.values = new double[size];
        this.initialize(valueInitializer);
    }

    private VectorValue(double[] values, boolean rowOrientation) {
        this.values = values;
        this.rowOrientation = rowOrientation;
    }

    @Override
    @NotNull
    public Iterator<Double> iterator() {
        return new ValueIterator();
    }

    @Override
    public void initialize(ValueInitializer valueInitializer) {
        valueInitializer.initVector(this);
    }

    @Override
    public VectorValue zero() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = 0.0;
        }
        return this;
    }

    @Override
    public VectorValue clone() {
        VectorValue clone = new VectorValue(this.values.length);
        clone.rowOrientation = this.rowOrientation;
        for (int i = 0; i < clone.values.length; ++i) {
            clone.values[i] = this.values[i];
        }
        return clone;
    }

    @Override
    public VectorValue getForm() {
        VectorValue form = new VectorValue(this.values.length);
        form.rowOrientation = this.rowOrientation;
        return form;
    }

    @Override
    public void transpose() {
        this.rowOrientation = !this.rowOrientation;
    }

    @Override
    public Value transposedView() {
        return new VectorValue(this.values, !this.rowOrientation);
    }

    @Override
    public int[] size() {
        if (this.rowOrientation) {
            return new int[]{1, this.values.length};
        }
        return new int[]{this.values.length, 1};
    }

    @Override
    public Value apply(Function<Double, Double> function) {
        VectorValue result = new VectorValue(this.values.length);
        double[] resultValues = result.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = function.apply(this.values[i]);
        }
        return result;
    }

    @Override
    public double get(int i) {
        return this.values[i];
    }

    @Override
    public void set(int i, double value) {
        this.values[i] = value;
    }

    @Override
    public void increment(int i, double value) {
        int n = i;
        this.values[n] = this.values[n] + value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(",").append(Settings.shortNumberFormat.format(this.values[i]));
        }
        sb.replace(0, 1, "[");
        sb.replace(0, 1, "[");
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Value times(Value value) {
        return value.times(this);
    }

    @Override
    protected VectorValue times(ScalarValue value) {
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        double otherValue = value.value;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] * otherValue;
        }
        return result;
    }

    @Override
    protected Value times(VectorValue value) {
        if (value.rowOrientation && !this.rowOrientation && value.values.length == this.values.length) {
            ScalarValue result = new ScalarValue(0.0);
            double resultValue = 0.0;
            double[] otherValues = value.values;
            for (int i = 0; i < this.values.length; ++i) {
                resultValue += this.values[i] * otherValues[i];
            }
            result.value = resultValue;
            return result;
        }
        if (!value.rowOrientation && this.rowOrientation) {
            LOG.finest("Performing vector x vector matrix multiplication.");
            MatrixValue result = new MatrixValue(value.values.length, this.values.length);
            double[][] resultValues = result.values;
            for (int i = 0; i < value.values.length; ++i) {
                for (int j = 0; j < this.values.length; ++j) {
                    resultValues[i][j] = value.values[i] * this.values[j];
                }
            }
            return result;
        }
        LOG.severe("Incompatible dimensions for vector multiplication: " + Arrays.toString(value.size()) + " x " + Arrays.toString(this.size()) + " (try transposition)");
        return null;
    }

    @Override
    protected VectorValue times(MatrixValue value) {
        if (value.cols != this.values.length) {
            LOG.severe("Matrix row length mismatch with vector length for multiplication");
        }
        if (value.cols > 1 && this.rowOrientation) {
            LOG.severe("Multiplying matrix with a row-oriented vector!");
        }
        VectorValue result = new VectorValue(value.rows);
        double[] resultValues = result.values;
        double[][] matrixValues = value.values;
        for (int i = 0; i < value.rows; ++i) {
            for (int j = 0; j < value.cols; ++j) {
                int n = i;
                resultValues[n] = resultValues[n] + matrixValues[i][j] * this.values[j];
            }
        }
        return result;
    }

    @Override
    public Value elementTimes(Value value) {
        return value.elementTimes(this);
    }

    @Override
    protected Value elementTimes(ScalarValue value) {
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        double otherValue = value.value;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] * otherValue;
        }
        return result;
    }

    @Override
    protected Value elementTimes(VectorValue value) {
        if (value.values.length != this.values.length) {
            LOG.severe("Vector element-wise multiplication dimension mismatch");
        }
        VectorValue result = value.getForm();
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] * otherValues[i];
        }
        return result;
    }

    @Override
    protected Value elementTimes(MatrixValue value) {
        LOG.warning("Calculation matrix element-wise product with vector...");
        if (value.cols != this.values.length) {
            LOG.severe("Matrix row length mismatch with vector length for multiplication");
        }
        MatrixValue result = new MatrixValue(value.rows, value.cols);
        double[][] resultValues = result.values;
        double[][] matrixValues = value.values;
        for (int i = 0; i < value.rows; ++i) {
            for (int j = 0; j < value.cols; ++j) {
                resultValues[i][j] = matrixValues[i][j] * this.values[j];
            }
        }
        return result;
    }

    @Override
    public Value plus(Value value) {
        return value.plus(this);
    }

    @Override
    protected VectorValue plus(ScalarValue value) {
        double other = value.value;
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] + other;
        }
        return result;
    }

    @Override
    protected VectorValue plus(VectorValue value) {
        if (value.values.length != this.values.length) {
            LOG.severe("Vector element-wise addition dimension mismatch");
        }
        VectorValue result = value.getForm();
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = this.values[i] + otherValues[i];
        }
        return result;
    }

    @Override
    protected Value plus(MatrixValue value) {
        LOG.severe("Incompatible summation of matrix plus vector ");
        return null;
    }

    @Override
    public Value minus(Value value) {
        return null;
    }

    @Override
    protected Value minus(ScalarValue value) {
        double other = value.value;
        VectorValue result = this.getForm();
        double[] resultValues = result.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = other - this.values[i];
        }
        return result;
    }

    @Override
    protected Value minus(VectorValue value) {
        if (value.values.length != this.values.length) {
            LOG.severe("Vector element-wise addition dimension mismatch");
        }
        VectorValue result = value.getForm();
        double[] resultValues = result.values;
        double[] otherValues = value.values;
        for (int i = 0; i < this.values.length; ++i) {
            resultValues[i] = otherValues[i] - this.values[i];
        }
        return result;
    }

    @Override
    protected Value minus(MatrixValue value) {
        LOG.severe("Incompatible dimensions of algebraic operation - matrix minus vector");
        return null;
    }

    @Override
    public void incrementBy(Value value) {
        value.incrementBy(this);
    }

    @Override
    protected void incrementBy(ScalarValue value) {
        LOG.severe("Incompatible dimensions of algebraic operation - scalar increment by vector");
    }

    @Override
    protected void incrementBy(VectorValue value) {
        if (value.values.length != this.values.length) {
            LOG.severe("Vector element-wise increment dimension mismatch");
        }
        double[] otherValues = value.values;
        for (int i = 0; i < otherValues.length; ++i) {
            int n = i;
            otherValues[n] = otherValues[n] + this.values[i];
        }
    }

    @Override
    protected void incrementBy(MatrixValue value) {
        LOG.severe("Incompatible dimensions of algebraic operation - matrix increment by vector");
    }

    @Override
    public boolean greaterThan(Value maxValue) {
        return maxValue.greaterThan(this);
    }

    @Override
    protected boolean greaterThan(ScalarValue maxValue) {
        int greater = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(maxValue.value > this.values[i])) continue;
            ++greater;
        }
        return greater > this.values.length / 2;
    }

    @Override
    protected boolean greaterThan(VectorValue maxValue) {
        if (maxValue.values.length != this.values.length) {
            LOG.severe("Vector element-wise comparison dimension mismatch");
        }
        int greater = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(maxValue.values[i] > this.values[i])) continue;
            ++greater;
        }
        return greater > this.values.length / 2;
    }

    @Override
    protected boolean greaterThan(MatrixValue maxValue) {
        LOG.severe("Incompatible dimensions of algebraic operation - matrix greaterThan vector");
        return false;
    }

    public int hashCode() {
        long hashCode = 1L;
        for (int i = 0; i < this.values.length; ++i) {
            hashCode = 31L * hashCode + (long)Double.valueOf(this.values[i]).hashCode();
        }
        return Long.hashCode(hashCode);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VectorValue)) {
            return false;
        }
        VectorValue vectorValue = (VectorValue)obj;
        if (vectorValue.values.length != this.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == vectorValue.values[i]) continue;
            return false;
        }
        return true;
    }

    protected class ValueIterator
    implements Iterator<Double> {
        int i = 0;

        protected ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < VectorValue.this.values.length;
        }

        @Override
        public Double next() {
            return VectorValue.this.values[this.i++];
        }
    }
}

