/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.values.distributions;

import java.util.logging.Logger;
import networks.computation.evaluation.values.MatrixValue;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.VectorValue;
import networks.computation.evaluation.values.distributions.Uniform;
import networks.computation.evaluation.values.distributions.ValueInitializer;
import networks.structure.components.weights.Weight;
import settings.Settings;

public class GlorotInitializer
implements ValueInitializer {
    private static final Logger LOG = Logger.getLogger(GlorotInitializer.class.getName());
    Uniform distribution;

    public GlorotInitializer(Settings settings) {
        this.distribution = new Uniform(settings.random, settings);
    }

    public void initWeight(Weight weight) {
        weight.value.initialize(this);
    }

    @Override
    public void initScalar(ScalarValue scalar) {
        double limit = this.getLimit(scalar);
        scalar.value = this.distribution.getDoubleValue(-limit, limit);
    }

    @Override
    public void initVector(VectorValue vector) {
        double limit = this.getLimit(vector);
        for (int i = 0; i < vector.values.length; ++i) {
            vector.values[i] = this.distribution.getDoubleValue(-limit, limit);
        }
    }

    @Override
    public void initMatrix(MatrixValue matrix) {
        double limit = this.getLimit(matrix);
        for (int i = 0; i < matrix.rows; ++i) {
            for (int j = 0; j < matrix.cols; ++j) {
                matrix.values[i][j] = this.distribution.getDoubleValue(-limit, limit);
            }
        }
    }

    private double getLimit(MatrixValue value) {
        return Math.sqrt(6.0) / Math.sqrt(value.cols + value.rows);
    }

    private double getLimit(VectorValue value) {
        return Math.sqrt(6.0) / Math.sqrt(value.values.length + 1);
    }

    private double getLimit(ScalarValue value) {
        return Math.sqrt(6.0) / Math.sqrt(2.0);
    }
}

