/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.values.distributions;

import java.util.logging.Logger;
import networks.computation.evaluation.values.MatrixValue;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.VectorValue;
import networks.computation.evaluation.values.distributions.Distribution;
import networks.computation.evaluation.values.distributions.ValueInitializer;
import networks.structure.components.weights.Weight;
import settings.Settings;

public class SimpleInitializer
implements ValueInitializer {
    private static final Logger LOG = Logger.getLogger(SimpleInitializer.class.getName());
    Distribution distribution;

    public SimpleInitializer(Settings settings) {
        this.distribution = Distribution.getDistribution(settings);
    }

    public void initWeight(Weight weight) {
        weight.value.initialize(this);
    }

    @Override
    public void initScalar(ScalarValue scalar) {
        scalar.value = this.distribution.getDoubleValue();
    }

    @Override
    public void initVector(VectorValue vector) {
        for (int i = 0; i < vector.values.length; ++i) {
            vector.values[i] = this.distribution.getDoubleValue();
        }
    }

    @Override
    public void initMatrix(MatrixValue matrix) {
        for (int i = 0; i < matrix.rows; ++i) {
            for (int j = 0; j < matrix.cols; ++j) {
                matrix.values[i][j] = this.distribution.getDoubleValue();
            }
        }
    }
}

