/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.iteration.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.Value;
import networks.computation.iteration.IterationStrategy;
import networks.computation.iteration.modes.BFS;
import networks.computation.iteration.modes.DFSstack;
import networks.computation.iteration.modes.Topologic;
import networks.computation.iteration.visitors.neurons.Accumulator;
import networks.computation.iteration.visitors.neurons.NeuronVisitor;
import networks.computation.iteration.visitors.states.StateVisiting;
import networks.computation.training.NeuralSample;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.QueryNeuron;
import networks.structure.components.types.TopologicNetwork;
import networks.structure.metadata.states.State;
import settings.Settings;
import utils.generic.Pair;

public class Accumulating {
    private static final Logger LOG = Logger.getLogger(Accumulating.class.getName());
    private Settings settings;
    private StateVisiting.Computation stateVisitor;

    public Accumulating(Settings settings, StateVisiting.Computation stateVisitor) {
        this.settings = settings;
        this.stateVisitor = stateVisitor;
    }

    private IterationStrategy getIterationStrategy(NeuralNetwork<State.Structure> network, Neurons outputNeuron, Accumulator accumulator) {
        if (network instanceof TopologicNetwork) {
            Topologic topologic = new Topologic((TopologicNetwork)network);
            topologic.getClass();
            return topologic.new Topologic.BUpIterator(outputNeuron, (NeuronVisitor.Weighted)accumulator);
        }
        if (this.settings.iterationMode == Settings.IterationMode.DFS_STACK) {
            DFSstack dFSstack = new DFSstack();
            dFSstack.getClass();
            return dFSstack.new DFSstack.TDownIterator(network, outputNeuron, accumulator);
        }
        BFS bFS = new BFS();
        bFS.getClass();
        return bFS.new BFS.TDownIterator(network, outputNeuron, accumulator);
    }

    public Value accumulate(NeuralNetwork<State.Structure> neuralNetwork, Neurons outputNeuron) {
        Accumulator accumulator = new Accumulator(neuralNetwork, this.stateVisitor);
        IterationStrategy iterationStrategy = this.getIterationStrategy(neuralNetwork, outputNeuron, accumulator);
        iterationStrategy.iterate();
        return accumulator.accumulated;
    }

    public List<Pair<Value, Value>> accumulateStats(List<NeuralSample> samples) {
        ArrayList<Pair<Value, Value>> values = new ArrayList<Pair<Value, Value>>();
        for (NeuralSample sample : samples) {
            Value acc = this.accumulate((NeuralNetwork)((QueryNeuron)sample.query).evidence, ((QueryNeuron)sample.query).neuron);
            values.add(new Pair<Value, ScalarValue>(acc, new ScalarValue(((NeuralNetwork)((QueryNeuron)sample.query).evidence).getNeuronCount().intValue())));
        }
        return values;
    }
}

