/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.iteration.actions;

import java.util.logging.Logger;
import networks.computation.iteration.IterationStrategy;
import networks.computation.iteration.modes.BFS;
import networks.computation.iteration.modes.DFSstack;
import networks.computation.iteration.modes.Topologic;
import networks.computation.iteration.visitors.neurons.Independent;
import networks.computation.iteration.visitors.neurons.NeuronVisitor;
import networks.computation.iteration.visitors.states.StateVisiting;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.types.TopologicNetwork;
import settings.Settings;

public class IndependentNeuronProcessing {
    private static final Logger LOG = Logger.getLogger(IndependentNeuronProcessing.class.getName());
    Settings settings;
    StateVisiting.Computation visitor;

    public IndependentNeuronProcessing(Settings settings, StateVisiting.Computation visitor) {
        this.settings = settings;
        this.visitor = visitor;
    }

    private IterationStrategy getIterationStrategy(NeuralNetwork network, Neurons outputNeuron) {
        Independent inval = new Independent(network, this.visitor);
        if (network instanceof TopologicNetwork) {
            Topologic topologic = new Topologic((TopologicNetwork)network);
            topologic.getClass();
            return topologic.new Topologic.BUpIterator(outputNeuron, (NeuronVisitor.Weighted)inval);
        }
        if (this.settings.iterationMode == Settings.IterationMode.DFS_STACK) {
            DFSstack dFSstack = new DFSstack();
            dFSstack.getClass();
            return dFSstack.new DFSstack.TDownIterator(network, outputNeuron, inval);
        }
        BFS bFS = new BFS();
        bFS.getClass();
        return bFS.new BFS.TDownIterator(network, outputNeuron, inval);
    }

    public void process(NeuralNetwork network, Neurons outputNeuron) {
        IterationStrategy iterationStrategy = this.getIterationStrategy(network, outputNeuron);
        iterationStrategy.iterate();
    }
}

