/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.iteration.modes;

import java.util.Iterator;
import java.util.logging.Logger;
import networks.computation.evaluation.values.Value;
import networks.computation.iteration.BottomUp;
import networks.computation.iteration.NeuronVisiting;
import networks.computation.iteration.TopDown;
import networks.computation.iteration.visitors.neurons.NeuronVisitor;
import networks.computation.iteration.visitors.states.StateVisiting;
import networks.computation.iteration.visitors.weights.WeightUpdater;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.WeightedNeuron;
import networks.structure.components.weights.Weight;
import networks.structure.metadata.states.State;
import utils.generic.Pair;

public class DFSrecursion {
    private static final Logger LOG = Logger.getLogger(DFSrecursion.class.getName());

    public class BUpVisitor
    extends NeuronVisiting.Weighted
    implements BottomUp<Value> {
        NeuronVisitor.Weighted neuronVisitor;
        StateVisiting.Computation stateVisitor;

        public BUpVisitor(NeuralNetwork<State.Structure> network, Neurons outputNeuron, NeuronVisitor.Weighted pureNeuronVisitor) {
            super(network, outputNeuron);
            this.neuronVisitor = pureNeuronVisitor;
            this.stateVisitor = pureNeuronVisitor.stateVisitor;
        }

        @Override
        public Value bottomUp() {
            this.outputNeuron.visit(this);
            return this.outputNeuron.getComputationView(this.stateVisitor.stateIndex).getValue();
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
            Iterator<T> inputs = this.network.getInputs(neuron);
            while (inputs.hasNext()) {
                Neurons input = (Neurons)inputs.next();
                State.Neural.Computation computationView = input.getComputationView(this.stateVisitor.stateIndex);
                if (computationView.ready4expansion(this.stateVisitor)) continue;
                input.visit(this);
            }
            neuron.visit(this.neuronVisitor);
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
            Pair<Iterator<T>, Iterator<Weight>> inputs = this.network.getInputs(neuron);
            Iterator inputNeurons = (Iterator)inputs.r;
            while (inputNeurons.hasNext()) {
                Neurons input = (Neurons)inputNeurons.next();
                State.Neural.Computation computationView = input.getComputationView(this.stateVisitor.stateIndex);
                if (computationView.ready4expansion(this.stateVisitor)) continue;
                input.visit(this);
            }
            neuron.visit(this.neuronVisitor);
        }
    }

    public class TDownVisitor
    extends NeuronVisiting.Weighted
    implements TopDown {
        StateVisiting.Computation stateVisitor;
        WeightUpdater weightUpdater;

        public TDownVisitor(NeuralNetwork<State.Structure> network, Neurons neuron, StateVisiting.Computation topDown, WeightUpdater weightUpdater) {
            super(network, neuron);
            this.weightUpdater = weightUpdater;
            this.stateVisitor = topDown;
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
            State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
            Value gradient = this.stateVisitor.visit(state);
            Iterator<T> inputs = this.network.getInputs(neuron);
            while (inputs.hasNext()) {
                Neurons input = (Neurons)inputs.next();
                State.Neural.Computation computationView = input.getComputationView(this.stateVisitor.stateIndex);
                computationView.storeGradient(gradient);
                if (!computationView.ready4expansion(this.stateVisitor)) continue;
                input.visit(this);
            }
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
            State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
            Value gradient = this.stateVisitor.visit(state);
            Pair<Iterator<T>, Iterator<Weight>> inputs = this.network.getInputs(neuron);
            this.weightUpdater.visit(neuron.offset, gradient);
            Iterator inputNeurons = (Iterator)inputs.r;
            Iterator inputWeights = (Iterator)inputs.s;
            while (inputNeurons.hasNext() && inputWeights.hasNext()) {
                Neurons input = (Neurons)inputNeurons.next();
                Weight weight = (Weight)inputWeights.next();
                State.Neural.Computation computationView = input.getComputationView(this.stateVisitor.stateIndex);
                this.weightUpdater.visit(weight, gradient.times(computationView.getValue()));
                computationView.storeGradient(gradient.times(weight.value));
                if (!computationView.ready4expansion(this.stateVisitor)) continue;
                input.visit(this);
            }
        }

        @Override
        public void topdown() {
            this.outputNeuron.visit(this);
        }
    }
}

