/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.training.debugging;

import constructs.building.debugging.TemplateDebugger;
import constructs.template.Template;
import java.util.logging.Logger;
import java.util.stream.Stream;
import networks.computation.evaluation.results.Progress;
import networks.computation.training.NeuralModel;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.pipes.generic.FirstFromPairPipe;
import pipelines.pipes.generic.StreamifyPipe;
import settings.Settings;
import settings.Sources;
import utils.generic.Pair;

public class TrainingDebugger
extends TemplateDebugger {
    private static final Logger LOG = Logger.getLogger(TrainingDebugger.class.getName());

    public TrainingDebugger(String[] args, Settings settings) {
        super(args, settings);
        if (this.intermediateDebug) {
            settings.debugPipeline = true;
            settings.debugTemplate = true;
            settings.debugSampleTraining = true;
            settings.debugGrounding = true;
        }
    }

    public TrainingDebugger(Sources sources, Settings settings) {
        super(sources, settings);
        if (this.intermediateDebug) {
            settings.debugPipeline = true;
            settings.debugTemplate = true;
            settings.debugSampleTraining = true;
            settings.debugGrounding = true;
        }
    }

    public TrainingDebugger(Settings settings) {
        super(settings);
        if (this.intermediateDebug) {
            settings.debugPipeline = true;
            settings.debugTemplate = true;
            settings.debugSampleTraining = true;
            settings.debugGrounding = true;
        }
    }

    @Override
    public Pipeline<Sources, Stream<Template>> buildPipeline() {
        Pipeline<Sources, Pair<Pair<Template, NeuralModel>, Progress>> sourcesPairPipeline = this.pipeline.registerStart(this.end2endTrainigBuilder.buildPipeline());
        FirstFromPairPipe pairTemplatePipe1 = this.pipeline.register(new FirstFromPairPipe("FirstFromPairPipe1"));
        sourcesPairPipeline.connectAfter(pairTemplatePipe1);
        Pipe pairTemplatePipe = this.pipeline.register(pairTemplatePipe1.connectAfter(new FirstFromPairPipe("FirstFromPairPipe2")));
        this.pipeline.registerEnd(pairTemplatePipe.connectAfter(new StreamifyPipe()));
        return this.pipeline;
    }
}

