/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.training.strategies.trainers;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import networks.computation.evaluation.results.Result;
import networks.computation.training.NeuralModel;
import networks.computation.training.NeuralSample;
import networks.computation.training.optimizers.Optimizer;
import networks.computation.training.strategies.trainers.ListTrainer;
import networks.computation.training.strategies.trainers.SequentialTrainer;
import networks.computation.training.strategies.trainers.StreamTrainer;
import settings.Settings;

public class AsyncParallelTrainer
extends SequentialTrainer {
    private static final Logger LOG = Logger.getLogger(AsyncParallelTrainer.class.getName());

    public AsyncParallelTrainer(Settings settings, Optimizer optimizer, NeuralModel neuralModel) {
        super(settings, optimizer, neuralModel);
    }

    protected AsyncParallelTrainer() {
    }

    public class AsyncStreamTrainer
    implements StreamTrainer {
        @Override
        public Stream<Result> learnEpoch(NeuralModel neuralModel, Stream<NeuralSample> sampleStream) {
            Stream<Result> resultStream = ((Stream)sampleStream.parallel()).map(sample -> AsyncParallelTrainer.this.learnFromSample(neuralModel, (NeuralSample)sample, AsyncParallelTrainer.this.dropout, AsyncParallelTrainer.this.invalidation, AsyncParallelTrainer.this.evaluation, AsyncParallelTrainer.this.backpropagation));
            return resultStream;
        }
    }

    public class AsyncListTrainer
    implements ListTrainer {
        @Override
        public List<Result> learnEpoch(NeuralModel neuralModel, List<NeuralSample> sampleList) {
            List<Result> resultList = sampleList.parallelStream().map(neuralSample -> AsyncParallelTrainer.this.learnFromSample(neuralModel, (NeuralSample)neuralSample, AsyncParallelTrainer.this.dropout, AsyncParallelTrainer.this.invalidation, AsyncParallelTrainer.this.evaluation, AsyncParallelTrainer.this.backpropagation)).collect(Collectors.toList());
            return resultList;
        }

        @Override
        public List<Result> evaluate(List<NeuralSample> sampleList) {
            List<Result> resultList = sampleList.parallelStream().map(neuralSample -> AsyncParallelTrainer.this.evaluateSample(AsyncParallelTrainer.this.evaluation, (NeuralSample)neuralSample)).collect(Collectors.toList());
            return resultList;
        }

        @Override
        public void restart(Settings settings) {
            AsyncParallelTrainer.this.optimizer.restart(settings);
        }
    }
}

