/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.building.builders;

import constructs.building.factories.WeightFactory;
import java.util.logging.Logger;
import networks.structure.building.builders.StatesBuilder;
import networks.structure.building.factories.NeuralNetFactory;
import networks.structure.building.factories.NeuronFactory;
import settings.Settings;

public class NeuralBuilder {
    private static final Logger LOG = Logger.getLogger(NeuralBuilder.class.getName());
    Settings settings;
    public StatesBuilder statesBuilder;
    public NeuronFactory neuronFactory;
    public NeuralNetFactory networkFactory;
    public WeightFactory weightFactory;

    public NeuralBuilder(Settings settings) {
        this.settings = settings;
        this.statesBuilder = new StatesBuilder(settings);
        this.weightFactory = new WeightFactory();
        this.neuronFactory = new NeuronFactory(this.weightFactory, settings);
        this.networkFactory = new NeuralNetFactory(settings);
    }

    public void setFactoriesFrom(NeuralBuilder other) {
        this.neuronFactory = other.neuronFactory;
        this.networkFactory = other.networkFactory;
        this.weightFactory = other.weightFactory;
        this.statesBuilder = other.statesBuilder;
    }
}

