/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.building.debugging;

import grounding.GroundingSample;
import grounding.debugging.GroundingDebugger;
import java.util.logging.Logger;
import java.util.stream.Stream;
import networks.computation.training.NeuralSample;
import pipelines.Pipeline;
import settings.Settings;
import settings.Sources;
import utils.Debugger;
import utils.drawing.NeuralNetDrawer;

public class NeuralDebugger
extends Debugger<NeuralSample> {
    private static final Logger LOG = Logger.getLogger(NeuralDebugger.class.getName());
    public GroundingDebugger groundingDebugger;

    public NeuralDebugger(Settings settings) {
        super(settings);
        this.drawer = new NeuralNetDrawer(settings);
    }

    public NeuralDebugger(String[] args, Settings settings) {
        super(args, settings);
        this.drawer = new NeuralNetDrawer(settings);
        this.groundingDebugger = new GroundingDebugger(args, settings);
    }

    public NeuralDebugger(Sources sources, Settings settings) {
        super(sources, settings);
        this.drawer = new NeuralNetDrawer(settings);
    }

    @Override
    public void debug(NeuralSample neuralSample) {
        this.drawer.draw(neuralSample);
    }

    @Override
    public Pipeline<Sources, Stream<NeuralSample>> buildPipeline() {
        Pipeline<Sources, Stream<GroundingSample>> groundingPipeline = this.pipeline.registerStart(this.groundingDebugger.buildPipeline());
        if (this.intermediateDebug) {
            this.groundingDebugger.addDebugStream(groundingPipeline);
        }
        Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> buildNeuralNets = this.pipeline.registerEnd(this.end2endTrainigBuilder.buildNeuralNets(this.settings, this.groundingDebugger.getWeightFactory()));
        groundingPipeline.connectAfter(buildNeuralNets);
        return this.pipeline;
    }
}

