/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.building.factories;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.NeuronSets;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.types.AtomNeurons;
import networks.structure.components.types.DetailedNetwork;
import networks.structure.components.types.TopologicNetwork;
import networks.structure.metadata.inputMappings.LinkedMapping;
import networks.structure.metadata.inputMappings.NeuronMapping;
import networks.structure.metadata.states.State;
import settings.Settings;

public class NeuralNetFactory {
    private static final Logger LOG = Logger.getLogger(NeuralNetFactory.class.getName());
    Settings settings;

    public NeuralNetFactory(Settings settings) {
        this.settings = settings;
    }

    public <S extends State.Structure> NeuralNetwork<S> extractOptimizedNetwork(DetailedNetwork<S> network) {
        if (!this.settings.parentCounting) {
            return this.extractTopologicNetwork(network);
        }
        return new NeuralNetwork(network.getId(), network.getNeuronCount());
    }

    public <S extends State.Structure> TopologicNetwork<S> extractTopologicNetwork(DetailedNetwork<S> network) {
        TopologicNetwork topologicNetwork = new TopologicNetwork(network.getId(), network.allNeuronsTopologic, true);
        topologicNetwork.hasSharedNeurons = network.hasSharedNeurons;
        topologicNetwork.containsInputMasking = network.containsInputMasking;
        topologicNetwork.containsCrossProducts = network.containsCrossProducts;
        topologicNetwork.neuronStates = network.neuronStates;
        return topologicNetwork;
    }

    public DetailedNetwork createDetailedNetwork(List<AtomNeurons> queryNeurons, NeuronSets createdNeurons, String id, Map<Neurons, LinkedMapping> extraInputMapping) {
        DetailedNetwork detailedNetwork = queryNeurons != null ? new DetailedNetwork(id, createdNeurons, queryNeurons) : new DetailedNetwork(id, createdNeurons.getAllNeurons(), createdNeurons);
        if (!this.settings.possibleNeuronSharing) {
            detailedNetwork.sortIndices();
        }
        if (extraInputMapping != null && !extraInputMapping.isEmpty()) {
            detailedNetwork.extraInputMapping = new HashMap<BaseNeuron, NeuronMapping<Neurons>>();
            HashSet currentNeurons = new HashSet(detailedNetwork.allNeuronsTopologic);
            for (Map.Entry<Neurons, LinkedMapping> entry : extraInputMapping.entrySet()) {
                if (!currentNeurons.contains(entry.getKey())) continue;
                detailedNetwork.extraInputMapping.putIfAbsent((BaseNeuron)entry.getKey(), (NeuronMapping<Neurons>)entry.getValue());
            }
        }
        return detailedNetwork;
    }
}

