/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.building.factories;

import constructs.building.factories.WeightFactory;
import constructs.example.ValuedFact;
import constructs.template.components.GroundHeadRule;
import constructs.template.components.GroundRule;
import constructs.template.components.HeadAtom;
import constructs.template.components.WeightedRule;
import ida.ilp.logic.Literal;
import java.util.logging.Logger;
import networks.computation.evaluation.functions.Activation;
import networks.computation.evaluation.functions.Aggregation;
import networks.computation.evaluation.functions.CrossProduct;
import networks.computation.evaluation.values.ScalarValue;
import networks.structure.building.NeuronMaps;
import networks.structure.components.neurons.types.AggregationNeuron;
import networks.structure.components.neurons.types.AtomFact;
import networks.structure.components.neurons.types.AtomNeuron;
import networks.structure.components.neurons.types.FactNeuron;
import networks.structure.components.neurons.types.NegationNeuron;
import networks.structure.components.neurons.types.RuleNeuron;
import networks.structure.components.neurons.types.WeightedAtomNeuron;
import networks.structure.components.neurons.types.WeightedRuleNeuron;
import networks.structure.components.weights.Weight;
import networks.structure.metadata.states.State;
import networks.structure.metadata.states.States;
import settings.Settings;

public class NeuronFactory {
    private static final Logger LOG = Logger.getLogger(NeuronFactory.class.getName());
    private WeightFactory weightFactory;
    Settings settings;
    private int counter = 0;
    private Weight atomOffset;
    private Weight ruleOffset;
    public NeuronMaps neuronMaps;

    public NeuronFactory(WeightFactory weightFactory, Settings settings) {
        this.weightFactory = weightFactory;
        this.settings = settings;
        this.atomOffset = weightFactory.construct("fixedAtomOffset", new ScalarValue(settings.defaultAtomNeuronOffset), true, true);
        this.ruleOffset = weightFactory.construct("fixedRuleOffset", new ScalarValue(settings.defaultRuleNeuronOffset), true, true);
    }

    public WeightedAtomNeuron createWeightedAtomNeuron(HeadAtom head, Literal groundHead) {
        Activation activation = head.getActivation() != null ? head.getActivation() : Activation.getActivationFunction(this.settings.atomNeuronActivation);
        State.Neural.Computation state = State.createBaseState(this.settings, activation);
        Weight offset = head.getOffset();
        if (offset == null) {
            if (this.settings.defaultAtomOffsetsLearnable) {
                offset = this.settings.defaultAtomNeuronOffset != 0.0 ? this.weightFactory.construct(new ScalarValue(this.settings.defaultAtomNeuronOffset), false, true) : this.weightFactory.construct(new ScalarValue(this.settings.defaultAtomNeuronOffset), false, false);
            } else if (this.settings.defaultAtomNeuronOffset != 0.0) {
                offset = this.atomOffset;
            }
        }
        WeightedAtomNeuron<State.Neural.Computation> atomNeuron = new WeightedAtomNeuron<State.Neural.Computation>(groundHead, offset, this.counter++, state);
        this.neuronMaps.atomNeurons.put(groundHead, atomNeuron);
        LOG.finest("Created atom neuron: " + atomNeuron);
        return atomNeuron;
    }

    public AtomNeuron createUnweightedAtomNeuron(HeadAtom head, Literal groundHead) {
        Activation activation = head.getActivation() != null ? head.getActivation() : Activation.getActivationFunction(this.settings.atomNeuronActivation);
        State.Neural.Computation state = State.createBaseState(this.settings, activation);
        AtomNeuron<State.Neural.Computation> atomNeuron = new AtomNeuron<State.Neural.Computation>(groundHead, this.counter++, state);
        this.neuronMaps.atomNeurons.put(groundHead, atomNeuron);
        LOG.finest("Created atom neuron: " + atomNeuron);
        return atomNeuron;
    }

    public AggregationNeuron createAggNeuron(GroundHeadRule groundHeadRule) {
        WeightedRule weightedRule = groundHeadRule.weightedRule;
        Activation aggregation = weightedRule.getAggregationFcn() != null ? weightedRule.getActivationFcn() : Aggregation.getAggregation(this.settings.aggNeuronActivation);
        State.Neural.Computation state = State.createBaseState(this.settings, aggregation);
        AggregationNeuron<State.Neural.Computation> aggregationNeuron = new AggregationNeuron<State.Neural.Computation>(this.settings.fullAggNeuronStrings ? groundHeadRule.toFullString() : weightedRule.getOriginalString(), this.counter++, state);
        this.neuronMaps.aggNeurons.put(groundHeadRule, aggregationNeuron);
        LOG.finest("Created aggregation neuron: " + aggregationNeuron);
        return aggregationNeuron;
    }

    public RuleNeuron createRuleNeuron(GroundRule groundRule) {
        Activation activation;
        WeightedRule weightedRule = groundRule.weightedRule;
        Activation activation2 = activation = weightedRule.getActivationFcn() != null ? weightedRule.getActivationFcn() : Activation.getActivationFunction(this.settings.ruleNeuronActivation);
        if (weightedRule.isCrossProduct()) {
            activation = new CrossProduct(activation);
        }
        State.Neural.Computation state = State.createBaseState(this.settings, activation);
        RuleNeuron<State.Neural.Computation> ruleNeuron = new RuleNeuron<State.Neural.Computation>(this.settings.fullRuleNeuronStrings ? groundRule.toFullString() : weightedRule.getOriginalString(), this.counter++, state);
        this.neuronMaps.ruleNeurons.put(groundRule, ruleNeuron);
        LOG.finest("Created rule neuron: " + ruleNeuron);
        return ruleNeuron;
    }

    public WeightedRuleNeuron createWeightedRuleNeuron(GroundRule groundRule) {
        Weight offset;
        Activation activation;
        WeightedRule weightedRule = groundRule.weightedRule;
        Activation activation2 = activation = weightedRule.getActivationFcn() != null ? weightedRule.getActivationFcn() : Activation.getActivationFunction(this.settings.ruleNeuronActivation);
        if (weightedRule.isCrossProduct()) {
            activation = new CrossProduct(activation);
        }
        if ((offset = weightedRule.getOffset()) == null) {
            if (this.settings.defaultRuleOffsetsLearnable) {
                offset = this.settings.defaultRuleNeuronOffset != 0.0 ? this.weightFactory.construct(new ScalarValue(this.settings.defaultRuleNeuronOffset), false, true) : this.weightFactory.construct(new ScalarValue(this.settings.defaultRuleNeuronOffset), false, false);
            } else if (this.settings.defaultRuleNeuronOffset != 0.0) {
                offset = this.atomOffset;
            }
        }
        State.Neural.Computation state = State.createBaseState(this.settings, activation);
        WeightedRuleNeuron<State.Neural.Computation> weightedRuleNeuron = new WeightedRuleNeuron<State.Neural.Computation>(this.settings.fullRuleNeuronStrings ? groundRule.toFullString() : weightedRule.getOriginalString(), offset, this.counter++, state);
        this.neuronMaps.ruleNeurons.put(groundRule, weightedRuleNeuron);
        LOG.finest("Created weightedRule neuron: " + weightedRuleNeuron);
        return weightedRuleNeuron;
    }

    public FactNeuron createFactNeuron(ValuedFact fact) {
        FactNeuron result = this.neuronMaps.factNeurons.get(fact.literal);
        if (result == null) {
            States.SimpleValue simpleValue = new States.SimpleValue(fact.getValue() == null ? this.settings.defaultFactValue : fact.getValue());
            FactNeuron factNeuron = new FactNeuron(fact, this.counter++, simpleValue);
            this.neuronMaps.factNeurons.put(fact.literal, factNeuron);
            LOG.finest("Created fact neuron: " + factNeuron);
            return factNeuron;
        }
        return result;
    }

    public NegationNeuron createNegationNeuron(AtomFact atomFact, Activation negation) {
        Activation activation = negation != null ? negation : Activation.getActivationFunction(this.settings.negation);
        State.Neural.Computation state = State.createBaseState(this.settings, activation);
        NegationNeuron<State.Neural.Computation> negationNeuron = new NegationNeuron<State.Neural.Computation>(atomFact, this.counter++, state);
        this.neuronMaps.negationNeurons.add(negationNeuron);
        LOG.finest("Created negation neuron: " + negationNeuron);
        return negationNeuron;
    }
}

