/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.components.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.types.AtomNeurons;
import networks.structure.metadata.states.State;

public class TopologicNetwork<N extends State.Structure>
extends NeuralNetwork<N> {
    private static final Logger LOG = Logger.getLogger(TopologicNetwork.class.getName());
    public List<BaseNeuron<Neurons, State.Neural>> allNeuronsTopologic;

    public TopologicNetwork(String id, List<BaseNeuron<Neurons, State.Neural>> allNeurons) {
        super(id, allNeurons.size());
        this.allNeuronsTopologic = this.topologicSort(allNeurons);
        if (this.allNeuronsTopologic.size() != allNeurons.size()) {
            LOG.warning("Some neurons connected in the network are not in neuronmaps!");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(this.allNeuronsTopologic.toString());
        }
    }

    public TopologicNetwork(String id, int size) {
        super(id, size);
        this.allNeuronsTopologic = new ArrayList<BaseNeuron<Neurons, State.Neural>>(size);
    }

    public TopologicNetwork(String id, List<BaseNeuron<Neurons, State.Neural>> allNeurons, boolean sorted) {
        super(id, allNeurons.size());
        this.allNeuronsTopologic = allNeurons;
    }

    public TopologicNetwork(List<AtomNeurons> queryNeurons, String id) {
        super(id, -1);
        HashSet<Neurons> visited = new HashSet<Neurons>();
        LinkedList<BaseNeuron<Neurons, State.Neural>> stack = new LinkedList<BaseNeuron<Neurons, State.Neural>>();
        for (AtomNeurons queryNeuron : queryNeurons) {
            BaseNeuron outputStart1 = (BaseNeuron)((Object)queryNeuron);
            this.topoSortRecursive(outputStart1, visited, stack);
        }
        ArrayList<BaseNeuron<Neurons, State.Neural>> reverse = new ArrayList<BaseNeuron<Neurons, State.Neural>>(stack.size());
        Iterator<BaseNeuron> descendingIterator = stack.descendingIterator();
        descendingIterator.forEachRemaining(reverse::add);
        this.allNeuronsTopologic = reverse;
        this.neuronCount = this.allNeuronsTopologic.size();
    }

    public void sortIndices() {
        int i;
        int[] indices = new int[this.allNeuronsTopologic.size()];
        for (i = 0; i < indices.length; ++i) {
            indices[i] = this.allNeuronsTopologic.get((int)i).index;
        }
        Arrays.sort(indices);
        for (i = 0; i < this.allNeuronsTopologic.size(); ++i) {
            this.allNeuronsTopologic.get((int)i).index = indices[i];
        }
    }

    public void restartIndices() {
        for (int i = 0; i < this.allNeuronsTopologic.size(); ++i) {
            this.allNeuronsTopologic.get((int)i).index = i;
        }
    }

    @Deprecated
    public N getState(int index) {
        return (N)this.neuronStates.getState(index);
    }

    @Override
    public N getState(Neurons neuron) {
        if (this.neuronStates != null) {
            return (N)this.neuronStates.getState(neuron.getIndex());
        }
        return null;
    }

    public List<BaseNeuron<Neurons, State.Neural>> topologicSort(List<BaseNeuron<Neurons, State.Neural>> allNeurons) {
        HashSet<Neurons> visited = new HashSet<Neurons>();
        LinkedList<BaseNeuron<Neurons, State.Neural>> stack = new LinkedList<BaseNeuron<Neurons, State.Neural>>();
        for (BaseNeuron<Neurons, State.Neural> neuron : allNeurons) {
            if (visited.contains(neuron)) continue;
            this.topoSortRecursive(neuron, visited, stack);
        }
        ArrayList<BaseNeuron<Neurons, State.Neural>> reverse = new ArrayList<BaseNeuron<Neurons, State.Neural>>(stack.size());
        Iterator descendingIterator = stack.descendingIterator();
        while (descendingIterator.hasNext()) {
            reverse.add((BaseNeuron<Neurons, State.Neural>)descendingIterator.next());
        }
        return reverse;
    }

    public void topoSortRecursive(BaseNeuron<Neurons, State.Neural> neuron, Set<Neurons> visited, LinkedList<BaseNeuron<Neurons, State.Neural>> stack) {
        visited.add(neuron);
        Iterator<Neurons> inputs = this.getInputs(neuron);
        while (inputs.hasNext()) {
            Neurons next = inputs.next();
            if (visited.contains(next)) continue;
            this.topoSortRecursive((BaseNeuron)next, visited, stack);
        }
        stack.addFirst(neuron);
    }

    @Override
    public String toString() {
        return "net:" + this.id + ", neurons: " + this.allNeuronsTopologic.size();
    }
}

