/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.components.weights;

import com.sun.istack.internal.Nullable;
import constructs.template.metadata.WeightMetadata;
import networks.computation.evaluation.values.Value;
import networks.computation.evaluation.values.distributions.ValueInitializer;

public class Weight {
    public final int index;
    public String name;
    public Value value;
    public boolean isFixed = false;
    public Boolean isLearnable;
    public boolean manualInitialization = false;
    public boolean isShared;
    public boolean dropout = false;
    @Nullable
    double learningRate;
    public boolean isOffset;
    public Value momentum;
    public Value velocity;
    public WeightMetadata metadata;
    public static Weight unitWeight = new Weight(-1, "unitWeight", Value.ONE, true, true);
    public static Weight zeroWeight = new Weight(-1, "zeroWeight", Value.ZERO, true, true);

    public Weight(int index, String name, Value value, boolean fixed, boolean isInitialized) {
        this.index = index;
        this.name = name;
        this.value = value;
        this.isFixed = fixed;
        this.manualInitialization = isInitialized;
        if (isInitialized) {
            this.metadata = new WeightMetadata(value);
        }
        if (this.isFixed || index < 0) {
            this.isLearnable = false;
        }
    }

    public Weight clone() {
        Weight clone = new Weight(this.index, this.name, this.value.clone(), this.isFixed, this.manualInitialization);
        clone.metadata = this.metadata;
        clone.dropout = this.dropout;
        clone.isShared = this.isShared;
        if (this.momentum != null) {
            clone.momentum = this.momentum.clone();
            clone.velocity = this.velocity.clone();
        }
        return clone;
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Weight)) {
            return false;
        }
        Weight obj1 = (Weight)obj;
        return this.index == obj1.index;
    }

    public void init(ValueInitializer valueInitializer) {
        if (this.isFixed) {
            return;
        }
        if (this.velocity != null) {
            this.velocity.zero();
        }
        if (this.momentum != null) {
            this.momentum.zero();
        }
        if (this.manualInitialization) {
            this.value = (Value)this.metadata.getByName("initValue");
            return;
        }
        this.value.initialize(valueInitializer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.manualInitialization || this.isFixed || this.isShared) {
            sb.append("<" + this.name + "> ");
        }
        sb.append(this.value.toString());
        return sb.toString();
    }

    public boolean isLearnable() {
        if (this.isLearnable != null) {
            return this.isLearnable;
        }
        if (this.isFixed) {
            this.isLearnable = false;
        }
        if (this.index < 0) {
            this.isLearnable = false;
        }
        if (this.value == Value.ONE || this.value == Value.ZERO) {
            this.isLearnable = false;
        }
        this.isLearnable = true;
        return this.isLearnable;
    }
}

