/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.transforming;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.QueryNeuron;
import networks.structure.components.types.DetailedNetwork;
import networks.structure.metadata.states.State;
import networks.structure.transforming.IsoValueNetworkCompressor;
import networks.structure.transforming.LinearChainReducer;
import networks.structure.transforming.ParallelEdgeMerger;
import settings.Settings;
import utils.exporting.Exportable;

public interface NetworkReducing
extends Exportable {
    public NeuralNetwork reduce(DetailedNetwork<State.Structure> var1, List<QueryNeuron> var2);

    public NeuralNetwork reduce(DetailedNetwork<State.Structure> var1, QueryNeuron var2);

    public static NetworkReducing getReducer(Settings settings) {
        return new LinearChainReducer(settings);
    }

    public static NetworkReducing getCompressor(Settings settings) {
        return new IsoValueNetworkCompressor(settings);
    }

    public static NetworkReducing getEdgeMerger(Settings settings) {
        return new ParallelEdgeMerger(settings);
    }

    public static void supervisedNetReconstruction(DetailedNetwork<State.Structure> inet, BaseNeuron<Neurons, State.Neural> outputStart) {
        HashSet<Neurons> visited = new HashSet<Neurons>();
        LinkedList<BaseNeuron<Neurons, State.Neural>> stack = new LinkedList<BaseNeuron<Neurons, State.Neural>>();
        BaseNeuron<Neurons, State.Neural> outputStart1 = outputStart;
        inet.topoSortRecursive(outputStart1, visited, stack);
        ArrayList reverse = new ArrayList(stack.size());
        Iterator<BaseNeuron<Neurons, State.Neural>> descendingIterator = stack.descendingIterator();
        descendingIterator.forEachRemaining(reverse::add);
        inet.allNeuronsTopologic = reverse;
    }

    public static void supervisedNetReconstruction(DetailedNetwork<State.Structure> inet, List<BaseNeuron<Neurons, State.Neural>> allQueryNeurons) {
        inet.allNeuronsTopologic = inet.topologicSort(allQueryNeurons);
    }

    public void finish();
}

